/*
 * Decompiled with CFR 0.152.
 */
package alluxio.resource;

import alluxio.resource.AlluxioResourceLeakDetectorFactory;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.io.netty.util.ResourceLeakDetector;
import alluxio.shaded.client.io.netty.util.ResourceLeakTracker;
import alluxio.shaded.client.javax.annotation.Nullable;
import java.io.Closeable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockResource
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(LockResource.class);
    private static final ResourceLeakDetector<LockResource> DETECTOR = AlluxioResourceLeakDetectorFactory.instance().newResourceLeakDetector(LockResource.class);
    protected Lock mLock;
    private final Runnable mCloseAction;
    @Nullable
    private ResourceLeakTracker<LockResource> mTracker = DETECTOR.track(this);

    public LockResource(Lock lock) {
        this(lock, true, false);
    }

    public LockResource(Lock lock, boolean acquireLock, boolean useTryLock) {
        this(lock, acquireLock, useTryLock, null);
    }

    public LockResource(Lock lock, boolean acquireLock, boolean useTryLock, @Nullable Runnable closeAction) {
        this.mLock = lock;
        this.mCloseAction = closeAction;
        if (acquireLock) {
            if (useTryLock) {
                while (!this.mLock.tryLock()) {
                    LockSupport.parkNanos(10000L);
                }
            } else {
                this.mLock.lock();
            }
        }
    }

    @VisibleForTesting
    public boolean hasSameLock(LockResource other) {
        return this.mLock == other.mLock;
    }

    @Override
    public void close() {
        if (this.mCloseAction != null) {
            this.mCloseAction.run();
        }
        if (this.mTracker != null) {
            this.mTracker.close(this);
        }
        this.mLock.unlock();
    }
}

