/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.grpc;

import alluxio.shaded.client.io.grpc.ExperimentalApi;
import alluxio.shaded.client.io.grpc.ServerCredentials;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/7621")
public final class ChoiceServerCredentials
extends ServerCredentials {
    private final List<ServerCredentials> creds;

    public static ServerCredentials create(ServerCredentials ... creds) {
        if (creds.length == 0) {
            throw new IllegalArgumentException("At least one credential is required");
        }
        return new ChoiceServerCredentials(creds);
    }

    private ChoiceServerCredentials(ServerCredentials ... creds) {
        for (ServerCredentials cred : creds) {
            if (cred != null) continue;
            throw new NullPointerException();
        }
        this.creds = Collections.unmodifiableList(new ArrayList<ServerCredentials>(Arrays.asList(creds)));
    }

    public List<ServerCredentials> getCredentialsList() {
        return this.creds;
    }
}

