/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.ha.client.zookeeper;

import java.io.File;
import java.io.IOException;
import javax.security.auth.login.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.delegation.ZKDelegationTokenSecretManager;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.AuthTypes$;
import org.apache.kyuubi.ha.client.RetryPolicies$;
import org.apache.kyuubi.ha.client.zookeeper.ZookeeperACLProvider;
import org.apache.kyuubi.shade.org.apache.curator.framework.CuratorFramework;
import org.apache.kyuubi.shade.org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.kyuubi.shade.org.apache.curator.retry.BoundedExponentialBackoffRetry;
import org.apache.kyuubi.shade.org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.kyuubi.shade.org.apache.curator.retry.RetryNTimes;
import org.apache.kyuubi.shade.org.apache.curator.retry.RetryOneTime;
import org.apache.kyuubi.shade.org.apache.curator.retry.RetryUntilElapsed;
import org.apache.kyuubi.shade.org.apache.curator.retry.SleepingRetry;
import org.apache.kyuubi.util.KyuubiHadoopUtils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.math.Numeric$IntIsIntegral$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcII$sp;
import scala.util.Random$;

public final class ZookeeperClientProvider$
implements Logging {
    public static ZookeeperClientProvider$ MODULE$;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new ZookeeperClientProvider$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public CuratorFramework buildZookeeperClient(KyuubiConf conf) {
        Object object;
        SleepingRetry sleepingRetry;
        this.setUpZooKeeperAuth(conf);
        String connectionStr = conf.get(HighAvailabilityConf$.MODULE$.HA_ADDRESSES());
        int sessionTimeout = BoxesRunTime.unboxToInt(conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_SESSION_TIMEOUT()));
        int connectionTimeout = BoxesRunTime.unboxToInt(conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_CONN_TIMEOUT()));
        int baseSleepTime = BoxesRunTime.unboxToInt(conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_CONN_BASE_RETRY_WAIT()));
        int maxSleepTime = BoxesRunTime.unboxToInt(conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_CONN_MAX_RETRY_WAIT()));
        int maxRetries = BoxesRunTime.unboxToInt(conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_CONN_MAX_RETRIES()));
        String retryPolicyName = conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_CONN_RETRY_POLICY());
        Enumeration.Value value = RetryPolicies$.MODULE$.withName(retryPolicyName);
        Enumeration.Value value2 = RetryPolicies$.MODULE$.ONE_TIME();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !((Object)value2).equals(value3) : value3 != null)) {
            sleepingRetry = new RetryOneTime(baseSleepTime);
        } else {
            Enumeration.Value value4 = RetryPolicies$.MODULE$.N_TIME();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !((Object)value4).equals(value5) : value5 != null)) {
                sleepingRetry = new RetryNTimes(maxRetries, baseSleepTime);
            } else {
                Enumeration.Value value6 = RetryPolicies$.MODULE$.BOUNDED_EXPONENTIAL_BACKOFF();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !((Object)value6).equals(value7) : value7 != null)) {
                    sleepingRetry = new BoundedExponentialBackoffRetry(baseSleepTime, maxSleepTime, maxRetries);
                } else {
                    Enumeration.Value value8 = RetryPolicies$.MODULE$.UNTIL_ELAPSED();
                    Enumeration.Value value9 = value;
                    sleepingRetry = !(value8 != null ? !((Object)value8).equals(value9) : value9 != null) ? new RetryUntilElapsed(maxSleepTime, baseSleepTime) : new ExponentialBackoffRetry(baseSleepTime, maxRetries);
                }
            }
        }
        RetryOneTime retryPolicy = sleepingRetry;
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(connectionStr).sessionTimeoutMs(sessionTimeout).connectionTimeoutMs(connectionTimeout).aclProvider(new ZookeeperACLProvider(conf)).retryPolicy(retryPolicy);
        Option option = (Option)((Object)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_AUTH_DIGEST()));
        if (option instanceof Some) {
            Some some = (Some)option;
            String anthString = (String)some.value();
            object = builder.authorization("digest", anthString.getBytes("UTF-8"));
        } else {
            object = BoxedUnit.UNIT;
        }
        return builder.build();
    }

    public long getGracefulStopThreadDelay(KyuubiConf conf) {
        long l;
        int baseSleepTime = BoxesRunTime.unboxToInt(conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_CONN_BASE_RETRY_WAIT()));
        int maxSleepTime = BoxesRunTime.unboxToInt(conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_CONN_MAX_RETRY_WAIT()));
        int maxRetries = BoxesRunTime.unboxToInt(conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_CONN_MAX_RETRIES()));
        String retryPolicyName = conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_CONN_RETRY_POLICY());
        Enumeration.Value value = RetryPolicies$.MODULE$.withName(retryPolicyName);
        Enumeration.Value value2 = RetryPolicies$.MODULE$.ONE_TIME();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !((Object)value2).equals(value3) : value3 != null)) {
            l = baseSleepTime;
        } else {
            Enumeration.Value value4 = RetryPolicies$.MODULE$.N_TIME();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !((Object)value4).equals(value5) : value5 != null)) {
                l = maxRetries * baseSleepTime;
            } else {
                Enumeration.Value value6 = RetryPolicies$.MODULE$.BOUNDED_EXPONENTIAL_BACKOFF();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !((Object)value6).equals(value7) : value7 != null)) {
                    l = BoxesRunTime.unboxToInt(((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), maxRetries).map((JFunction1$mcII$sp & Serializable)retryCount -> {
                        int retryWait = baseSleepTime * Math.max(1, Random$.MODULE$.nextInt(1 << retryCount + 1));
                        return Math.min(retryWait, maxSleepTime);
                    }, IndexedSeq$.MODULE$.canBuildFrom())).sum(Numeric$IntIsIntegral$.MODULE$));
                } else {
                    Enumeration.Value value8 = RetryPolicies$.MODULE$.UNTIL_ELAPSED();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !((Object)value8).equals(value9) : value9 != null)) {
                        l = maxSleepTime;
                    } else {
                        Enumeration.Value value10 = RetryPolicies$.MODULE$.EXPONENTIAL_BACKOFF();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !((Object)value10).equals(value11) : value11 != null)) {
                            l = BoxesRunTime.unboxToInt(((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), maxRetries).map((JFunction1$mcII$sp & Serializable)retryCount -> baseSleepTime * Math.max(1, Random$.MODULE$.nextInt(1 << retryCount + 1)), IndexedSeq$.MODULE$.canBuildFrom())).sum(Numeric$IntIsIntegral$.MODULE$));
                        } else {
                            throw new MatchError(value);
                        }
                    }
                }
            }
        }
        return l;
    }

    public void setUpZooKeeperAuth(KyuubiConf conf) throws Exception {
        block2: {
            block1: {
                if (!((Option)((Object)conf.get(HighAvailabilityConf$.MODULE$.HA_ENGINE_REF_ID()))).isEmpty()) break block1;
                Enumeration.Value value = AuthTypes$.MODULE$.withName(conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_AUTH_TYPE()));
                Enumeration.Value value2 = AuthTypes$.MODULE$.KERBEROS();
                if (value != null ? !((Object)value).equals(value2) : value2 != null) break block1;
                this.setupZkAuth$1(conf);
                break block2;
            }
            if (!((Option)((Object)conf.get(HighAvailabilityConf$.MODULE$.HA_ENGINE_REF_ID()))).nonEmpty()) break block2;
            Enumeration.Value value = AuthTypes$.MODULE$.withName(conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_ENGINE_AUTH_TYPE()));
            Enumeration.Value value3 = AuthTypes$.MODULE$.KERBEROS();
            if (!(value != null ? !((Object)value).equals(value3) : value3 != null)) {
                this.setupZkAuth$1(conf);
            }
        }
    }

    private Option<String> getKeyTabFile(KyuubiConf conf) {
        String zkAuthKeytabPath;
        String relativeFileName;
        Option<String> zkAuthKeytab = conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_AUTH_KEYTAB());
        return zkAuthKeytab.isDefined() ? (new File(relativeFileName = new File(zkAuthKeytabPath = zkAuthKeytab.get()).getName()).exists() ? new Some<String>(relativeFileName) : new Some<String>(zkAuthKeytabPath)) : None$.MODULE$;
    }

    private final void setupZkAuth$1(KyuubiConf conf$1) {
        block1: {
            boolean kerberized;
            Option<String> keyTabFile = this.getKeyTabFile(conf$1);
            Option<String> maybePrincipal = conf$1.get(HighAvailabilityConf$.MODULE$.HA_ZK_AUTH_PRINCIPAL());
            boolean bl = kerberized = maybePrincipal.isDefined() && keyTabFile.isDefined();
            if (!UserGroupInformation.isSecurityEnabled() || !kerberized) break block1;
            if (!new File(keyTabFile.get()).exists()) {
                throw new IOException(new StringBuilder(16).append(HighAvailabilityConf$.MODULE$.HA_ZK_AUTH_KEYTAB().key()).append(" does not exists").toString());
            }
            System.setProperty("zookeeper.sasl.clientconfig", "KyuubiZooKeeperClient");
            String principal = maybePrincipal.get();
            principal = KyuubiHadoopUtils$.MODULE$.getServerPrincipal(principal);
            ZKDelegationTokenSecretManager.JaasConfiguration jaasConf = new ZKDelegationTokenSecretManager.JaasConfiguration("KyuubiZooKeeperClient", principal, keyTabFile.get());
            Configuration.setConfiguration((Configuration)jaasConf);
        }
    }

    private ZookeeperClientProvider$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

