/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.ApplicationInfo;
import org.apache.kyuubi.engine.ApplicationState$;
import org.apache.kyuubi.engine.EngineType$;
import org.apache.kyuubi.engine.KyuubiApplicationManager;
import org.apache.kyuubi.engine.ProcBuilder;
import org.apache.kyuubi.engine.ShareLevel$;
import org.apache.kyuubi.engine.flink.FlinkProcessBuilder;
import org.apache.kyuubi.engine.hive.HiveProcessBuilder;
import org.apache.kyuubi.engine.jdbc.JdbcProcessBuilder;
import org.apache.kyuubi.engine.spark.SparkProcessBuilder;
import org.apache.kyuubi.engine.trino.TrinoProcessBuilder;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryPaths$;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.package$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005-h!B\u0013'\u0001!r\u0003\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u0011\u0005\u0003!\u0011!Q\u0001\n\tC\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\")1\u000b\u0001C\u0001)\"9!\f\u0001b\u0001\n\u0013Y\u0006B\u0002/\u0001A\u0003%!\tC\u0004^\u0001\t\u0007I\u0011\u00020\t\r\t\u0004\u0001\u0015!\u0003`\u0011\u001d\u0019\u0007A1A\u0005\n\u0011Da\u0001\u001e\u0001!\u0002\u0013)\u0007bB;\u0001\u0005\u0004%IA\u001e\u0005\u0007}\u0002\u0001\u000b\u0011B<\t\u0011}\u0004!\u0019!C\u0005\u0003\u0003A\u0001\"!\u0003\u0001A\u0003%\u00111\u0001\u0005\n\u0003\u0017\u0001!\u0019!C\u0005\u0003\u0003A\u0001\"!\u0004\u0001A\u0003%\u00111\u0001\u0005\t\u0003\u001f\u0001!\u0019!C\u00057\"9\u0011\u0011\u0003\u0001!\u0002\u0013\u0011\u0005\"CA\n\u0001\t\u0007I\u0011BA\u000b\u0011!\ti\u0002\u0001Q\u0001\n\u0005]\u0001bCA\u0010\u0001\u0001\u0007\t\u0019!C\u0005\u0003CA1\"!\u000b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002,!Y\u0011q\u0007\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0012\u0011%\tI\u0004\u0001b\u0001\n\u0003A3\fC\u0004\u0002<\u0001\u0001\u000b\u0011\u0002\"\t\u0013\u0005]\u0003A1A\u0005\u0002!Z\u0006bBA-\u0001\u0001\u0006IA\u0011\u0005\n\u00037\u0002!\u0019!C\u0001QmCq!!\u0018\u0001A\u0003%!\t\u0003\u0006\u0002b\u0001A)\u0019!C\u0001QmCq!!\u001a\u0001\t\u0013\t9\u0007C\u0004\u0002\"\u0002!I!a)\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u0002J\"I\u0011q\u001a\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u001b\u0005\b\u0003O\u0004A\u0011AAu\u0005%)enZ5oKJ+gM\u0003\u0002(Q\u00051QM\\4j]\u0016T!!\u000b\u0016\u0002\r-LX/\u001e2j\u0015\tYC&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002[\u0005\u0019qN]4\u0014\u0007\u0001yS\u0007\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014G\u0001\u0004B]f\u0014VM\u001a\t\u0003m]j\u0011\u0001K\u0005\u0003q!\u0012q\u0001T8hO&tw-\u0001\u0003d_:47\u0001\u0001\t\u0003y}j\u0011!\u0010\u0006\u0003}!\naaY8oM&<\u0017B\u0001!>\u0005)Y\u00150^;cS\u000e{gNZ\u0001\u0005kN,'\u000f\u0005\u0002D\u0015:\u0011A\t\u0013\t\u0003\u000bFj\u0011A\u0012\u0006\u0003\u000fj\na\u0001\u0010:p_Rt\u0014BA%2\u0003\u0019\u0001&/\u001a3fM&\u00111\n\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%\u000b\u0014aC3oO&tWMU3g\u0013\u0012\fQ\"\u001a8hS:,W*\u00198bO\u0016\u0014\bC\u0001)R\u001b\u00051\u0013B\u0001*'\u0005aY\u00150^;cS\u0006\u0003\b\u000f\\5dCRLwN\\'b]\u0006<WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bU3v\u000bW-\u0011\u0005A\u0003\u0001\"B\u001d\u0006\u0001\u0004Y\u0004\"B!\u0006\u0001\u0004\u0011\u0005\"B'\u0006\u0001\u0004\u0011\u0005\"\u0002(\u0006\u0001\u0004y\u0015aC:feZ,'o\u00159bG\u0016,\u0012AQ\u0001\rg\u0016\u0014h/\u001a:Ta\u0006\u001cW\rI\u0001\bi&lWm\\;u+\u0005y\u0006C\u0001\u0019a\u0013\t\t\u0017G\u0001\u0003M_:<\u0017\u0001\u0003;j[\u0016|W\u000f\u001e\u0011\u0002\u0015MD\u0017M]3MKZ,G.F\u0001f!\t1\u0017O\u0004\u0002h_:\u0011\u0001N\u001c\b\u0003S6t!A\u001b7\u000f\u0005\u0015[\u0017\"A\u0017\n\u0005-b\u0013BA\u0015+\u0013\t9\u0003&\u0003\u0002qM\u0005Q1\u000b[1sK2+g/\u001a7\n\u0005I\u001c(AC*iCJ,G*\u001a<fY*\u0011\u0001OJ\u0001\fg\"\f'/\u001a'fm\u0016d\u0007%\u0001\u0006f]\u001eLg.\u001a+za\u0016,\u0012a\u001e\t\u0003qnt!aZ=\n\u0005i4\u0013AC#oO&tW\rV=qK&\u0011A0 \u0002\u000b\u000b:<\u0017N\\3UsB,'B\u0001>'\u0003-)gnZ5oKRK\b/\u001a\u0011\u0002\u001bA|w\u000e\u001c+ie\u0016\u001c\bn\u001c7e+\t\t\u0019\u0001E\u00021\u0003\u000bI1!a\u00022\u0005\rIe\u000e^\u0001\u000fa>|G\u000e\u00165sKNDw\u000e\u001c3!\u00039\u0019G.[3oiB{w\u000e\\*ju\u0016\fqb\u00197jK:$\bk\\8m'&TX\rI\u0001\u000fG2LWM\u001c;Q_>dg*Y7f\u0003=\u0019G.[3oiB{w\u000e\u001c(b[\u0016\u0004\u0013\u0001\u0007'P\u0007.{F+S'F\u001fV#vl\u0015)B\u001d~3\u0015i\u0011+P%V\u0011\u0011q\u0003\t\u0004a\u0005e\u0011bAA\u000ec\t1Ai\\;cY\u0016\f\u0011\u0004T(D\u0017~#\u0016*T#P+R{6\u000bU!O?\u001a\u000b5\tV(SA\u00059!-^5mI\u0016\u0014XCAA\u0012!\r\u0001\u0016QE\u0005\u0004\u0003O1#a\u0003)s_\u000e\u0014U/\u001b7eKJ\f1BY;jY\u0012,'o\u0018\u0013fcR!\u0011QFA\u001a!\r\u0001\u0014qF\u0005\u0004\u0003c\t$\u0001B+oSRD\u0011\"!\u000e\u0018\u0003\u0003\u0005\r!a\t\u0002\u0007a$\u0013'\u0001\u0005ck&dG-\u001a:!\u0003%\u0019XO\u00193p[\u0006Lg.\u0001\u0006tk\n$w.\\1j]\u0002B3AGA !\u0011\t\t%a\u0015\u000e\u0005\u0005\r#\u0002BA#\u0003\u000f\n1\"\u00198o_R\fG/[8og*!\u0011\u0011JA&\u0003\u0019\u0019w.\\7p]*!\u0011QJA(\u0003\u00199wn\\4mK*\u0011\u0011\u0011K\u0001\u0004G>l\u0017\u0002BA+\u0003\u0007\u0012\u0011CV5tS\ndWMR8s)\u0016\u001cH/\u001b8h\u0003\u001d\t\u0007\u000f]+tKJ\f\u0001\"\u00199q+N,'\u000fI\u0001\u0012I\u00164\u0017-\u001e7u\u000b:<\u0017N\\3OC6,\u0017A\u00053fM\u0006,H\u000e^#oO&tWMT1nK\u0002B3AHA \u0003-)gnZ5oKN\u0003\u0018mY3)\u0007}\ty$A\u0006uef<\u0016\u000e\u001e5M_\u000e\\W\u0003BA5\u0003c\"B!a\u001b\u0002\u000eR!\u0011QNAB!\u0011\ty'!\u001d\r\u0001\u00119\u00111\u000f\u0011C\u0002\u0005U$!\u0001+\u0012\t\u0005]\u0014Q\u0010\t\u0004a\u0005e\u0014bAA>c\t9aj\u001c;iS:<\u0007c\u0001\u0019\u0002\u0000%\u0019\u0011\u0011Q\u0019\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002\u0006\u0002\"\t\u0019AAD\u0003\u00051\u0007#\u0002\u0019\u0002\n\u00065\u0014bAAFc\tAAHY=oC6,g\bC\u0004\u0002\u0010\u0002\u0002\r!!%\u0002\u001f\u0011L7oY8wKJL8\t\\5f]R\u0004B!a%\u0002\u001e6\u0011\u0011Q\u0013\u0006\u0005\u0003/\u000bI*\u0001\u0004dY&,g\u000e\u001e\u0006\u0004\u00037C\u0013A\u00015b\u0013\u0011\ty*!&\u0003\u001f\u0011K7oY8wKJL8\t\\5f]R\faa\u0019:fCR,GCBAS\u0003W\u000bi\u000b\u0005\u00041\u0003O\u0013\u00151A\u0005\u0004\u0003S\u000b$A\u0002+va2,'\u0007C\u0004\u0002\u0010\u0006\u0002\r!!%\t\u000f\u0005=\u0016\u00051\u0001\u00022\u0006qQ\r\u001f;sC\u0016sw-\u001b8f\u0019><\u0007#\u0002\u0019\u00024\u0006]\u0016bAA[c\t1q\n\u001d;j_:\u0004B!!/\u0002D6\u0011\u00111\u0018\u0006\u0005\u0003{\u000by,A\u0002m_\u001eT1!!1)\u0003%y\u0007/\u001a:bi&|g.\u0003\u0003\u0002F\u0006m&\u0001D(qKJ\fG/[8o\u0019><\u0017aC4fi>\u00138I]3bi\u0016$b!!*\u0002L\u00065\u0007bBAHE\u0001\u0007\u0011\u0011\u0013\u0005\n\u0003_\u0013\u0003\u0013!a\u0001\u0003c\u000bQcZ3u\u001fJ\u001c%/Z1uK\u0012\"WMZ1vYR$#'\u0006\u0002\u0002T*\"\u0011\u0011WAkW\t\t9\u000e\u0005\u0003\u0002Z\u0006\rXBAAn\u0015\u0011\ti.a8\u0002\u0013Ut7\r[3dW\u0016$'bAAqc\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00181\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!B2m_N,GCAA\u0017\u0001")
public class EngineRef
implements Logging {
    @VisibleForTesting
    private String engineSpace;
    private final KyuubiConf conf;
    private final String user;
    private final String engineRefId;
    private final KyuubiApplicationManager engineManager;
    private final String serverSpace;
    private final long timeout;
    private final Enumeration.Value shareLevel;
    private final Enumeration.Value engineType;
    private final int poolThreshold;
    private final int clientPoolSize;
    private final String clientPoolName;
    private final double LOCK_TIMEOUT_SPAN_FACTOR;
    private ProcBuilder builder;
    @VisibleForTesting
    private final String subdomain;
    private final String appUser;
    @VisibleForTesting
    private final String defaultEngineName;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private String serverSpace() {
        return this.serverSpace;
    }

    private long timeout() {
        return this.timeout;
    }

    private Enumeration.Value shareLevel() {
        return this.shareLevel;
    }

    private Enumeration.Value engineType() {
        return this.engineType;
    }

    private int poolThreshold() {
        return this.poolThreshold;
    }

    private int clientPoolSize() {
        return this.clientPoolSize;
    }

    private String clientPoolName() {
        return this.clientPoolName;
    }

    private double LOCK_TIMEOUT_SPAN_FACTOR() {
        return this.LOCK_TIMEOUT_SPAN_FACTOR;
    }

    private ProcBuilder builder() {
        return this.builder;
    }

    private void builder_$eq(ProcBuilder x$1) {
        this.builder = x$1;
    }

    public String subdomain() {
        return this.subdomain;
    }

    public String appUser() {
        return this.appUser;
    }

    public String defaultEngineName() {
        return this.defaultEngineName;
    }

    private String engineSpace$lzycompute() {
        EngineRef engineRef = this;
        synchronized (engineRef) {
            if (!this.bitmap$0) {
                String commonParent = new StringBuilder(3).append(this.serverSpace()).append("_").append(package$.MODULE$.KYUUBI_VERSION()).append("_").append(this.shareLevel()).append("_").append(this.engineType()).toString();
                Enumeration.Value value = this.shareLevel();
                Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
                Enumeration.Value value3 = value;
                String string = !(value2 != null ? !value2.equals(value3) : value3 != null) ? DiscoveryPaths$.MODULE$.makePath(commonParent, this.appUser(), (String[])((Object[])new String[]{this.engineRefId})) : DiscoveryPaths$.MODULE$.makePath(commonParent, this.appUser(), (String[])((Object[])new String[]{this.subdomain()}));
                this.engineSpace = string;
                this.bitmap$0 = true;
            }
        }
        return this.engineSpace;
    }

    public String engineSpace() {
        return !this.bitmap$0 ? this.engineSpace$lzycompute() : this.engineSpace;
    }

    private <T> T tryWithLock(DiscoveryClient discoveryClient, Function0<T> f) {
        Object object;
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            object = f.apply();
        } else {
            String lockPath = DiscoveryPaths$.MODULE$.makePath(new StringBuilder(2).append(this.serverSpace()).append("_").append(this.shareLevel()).append("_").append(this.engineType()).toString(), "lock", (String[])((Object[])new String[]{this.appUser(), this.subdomain()}));
            object = discoveryClient.tryWithLock(lockPath, this.timeout() + (long)(this.LOCK_TIMEOUT_SPAN_FACTOR() * (double)this.timeout()), f);
        }
        return (T)object;
    }

    private Tuple2<String, Object> create(DiscoveryClient discoveryClient, Option<OperationLog> extraEngineLog) {
        Tuple2 tuple2;
        Object object = new Object();
        try {
            tuple2 = (Tuple2)this.tryWithLock(discoveryClient, (Function0 & Serializable & scala.Serializable)() -> {
                Tuple2 tuple2;
                Logging logging;
                Option engineRef = discoveryClient.getServerHost(this.engineSpace());
                if (engineRef.nonEmpty()) {
                    throw new NonLocalReturnControl(object, engineRef.get());
                }
                $this.conf.set(HighAvailabilityConf$.MODULE$.HA_NAMESPACE(), (Object)this.engineSpace());
                $this.conf.set(HighAvailabilityConf$.MODULE$.HA_ENGINE_REF_ID(), (Object)$this.engineRefId);
                long started = System.currentTimeMillis();
                $this.conf.set("kyuubi.engine.submit.time", String.valueOf(started));
                Enumeration.Value value = this.engineType();
                Enumeration.Value value2 = EngineType$.MODULE$.SPARK_SQL();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    $this.conf.setIfMissing("spark.app.name", this.defaultEngineName());
                    logging = new SparkProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                } else {
                    Enumeration.Value value4 = EngineType$.MODULE$.FLINK_SQL();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        $this.conf.setIfMissing("yarn.application.name", this.defaultEngineName());
                        logging = new FlinkProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                    } else {
                        Enumeration.Value value6 = EngineType$.MODULE$.TRINO();
                        Enumeration.Value value7 = value;
                        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                            logging = new TrinoProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                        } else {
                            Enumeration.Value value8 = EngineType$.MODULE$.HIVE_SQL();
                            Enumeration.Value value9 = value;
                            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                                logging = new HiveProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                            } else {
                                Enumeration.Value value10 = EngineType$.MODULE$.JDBC();
                                Enumeration.Value value11 = value;
                                if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                                    logging = new JdbcProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                                } else {
                                    throw new MatchError((Object)value);
                                }
                            }
                        }
                    }
                }
                this.builder_$eq((ProcBuilder)logging);
                MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.incCount(MetricsConstants$.MODULE$.ENGINE_TOTAL());
                    return BoxedUnit.UNIT;
                });
                try {
                    String redactedCmd = this.builder().toString();
                    this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Launching engine:\n").append(redactedCmd).toString());
                    this.builder().validateConf();
                    Process process = this.builder().start();
                    None$ exitValue = None$.MODULE$;
                    while (engineRef.isEmpty()) {
                        if (exitValue.isEmpty() && process.waitFor(1L, TimeUnit.SECONDS) && BoxesRunTime.unboxToInt((Object)(exitValue = new Some((Object)BoxesRunTime.boxToInteger((int)process.exitValue()))).get()) != 0) {
                            Throwable error = this.builder().getError();
                            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                                EngineRef.$anonfun$create$4(this, error, ms);
                                return BoxedUnit.UNIT;
                            });
                            throw error;
                        }
                        None$ none$ = exitValue;
                        Some some = new Some((Object)BoxesRunTime.boxToInteger((int)0));
                        if (!(none$ != null ? !none$.equals(some) : some != null)) {
                            Option$.MODULE$.apply((Object)$this.engineManager).foreach((Function1 & Serializable & scala.Serializable)engineMgr -> {
                                EngineRef.$anonfun$create$5(this, engineMgr);
                                return BoxedUnit.UNIT;
                            });
                        }
                        if (started + this.timeout() <= System.currentTimeMillis()) {
                            Tuple2<Object, String> killMessage = $this.engineManager.killApplication(this.builder().clusterManager(), $this.engineRefId);
                            process.destroyForcibly();
                            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$2 -> {
                                x$2.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_TIMEOUT(), (String[])new String[]{this.appUser()}));
                                return BoxedUnit.UNIT;
                            });
                            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(70).append("Timeout(").append(this.timeout()).append(" ms, you can modify ").append(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT().key()).append(" to change it) to").append(" launched ").append(this.engineType()).append(" engine with ").append(redactedCmd).append(". ").append(killMessage).toString(), this.builder().getError(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                        }
                        engineRef = discoveryClient.getEngineByRefId(this.engineSpace(), $this.engineRefId);
                    }
                    tuple2 = (Tuple2)engineRef.get();
                }
                finally {
                    ProcBuilder qual$1 = this.builder();
                    boolean x$12 = qual$1.close$default$1();
                    qual$1.close(x$12);
                }
                return tuple2;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                tuple2 = (Tuple2)ex.value();
            }
            throw ex;
        }
        return tuple2;
    }

    public Tuple2<String, Object> getOrCreate(DiscoveryClient discoveryClient, Option<OperationLog> extraEngineLog) {
        return (Tuple2)discoveryClient.getServerHost(this.engineSpace()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.create(discoveryClient, extraEngineLog));
    }

    public Option<OperationLog> getOrCreate$default$2() {
        return None$.MODULE$;
    }

    public void close() {
        block2: {
            Enumeration.Value value = this.shareLevel();
            Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
            if ((value != null ? !value.equals(value2) : value2 != null) || this.builder() == null) break block2;
            try {
                Option<String> clusterManager = this.builder().clusterManager();
                this.builder().close(true);
                this.engineManager.killApplication(clusterManager, this.engineRefId);
            }
            catch (Exception e) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Error closing engine builder, engineRefId: ").append($this.engineRefId).toString(), e);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$create$4(EngineRef $this, Throwable error$1, MetricsSystem ms) {
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{$this.appUser()}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{error$1.getClass().getSimpleName()}));
    }

    public static final /* synthetic */ void $anonfun$create$7(EngineRef $this, MetricsSystem ms) {
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{$this.appUser()}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{"ENGINE_TERMINATE"}));
    }

    public static final /* synthetic */ void $anonfun$create$6(EngineRef $this, ApplicationInfo appInfo) {
        if (ApplicationState$.MODULE$.isTerminated(appInfo.state())) {
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                EngineRef.$anonfun$create$7($this, ms);
                return BoxedUnit.UNIT;
            });
            throw new KyuubiSQLException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(158).append("\n                     |The engine application has been terminated. Please check the engine log.\n                     |ApplicationInfo: ").append(appInfo.toMap().mkString("(\n", ",\n", "\n)")).append("\n                     |").toString())).stripMargin(), $this.builder().getError());
        }
    }

    public static final /* synthetic */ void $anonfun$create$5(EngineRef $this, KyuubiApplicationManager engineMgr) {
        engineMgr.getApplicationInfo($this.builder().clusterManager(), $this.engineRefId).foreach((Function1 & Serializable & scala.Serializable)appInfo -> {
            EngineRef.$anonfun$create$6($this, appInfo);
            return BoxedUnit.UNIT;
        });
    }

    public EngineRef(KyuubiConf conf, String user, String engineRefId, KyuubiApplicationManager engineManager) {
        String string;
        String string2;
        this.conf = conf;
        this.user = user;
        this.engineRefId = engineRefId;
        this.engineManager = engineManager;
        Logging.$init$((Logging)this);
        this.serverSpace = (String)conf.get(HighAvailabilityConf$.MODULE$.HA_NAMESPACE());
        this.timeout = BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT()));
        this.shareLevel = ShareLevel$.MODULE$.withName((String)conf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL()));
        this.engineType = EngineType$.MODULE$.withName((String)conf.get(KyuubiConf$.MODULE$.ENGINE_TYPE()));
        this.poolThreshold = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_SIZE_THRESHOLD()));
        this.clientPoolSize = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_SIZE()));
        this.clientPoolName = (String)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_NAME());
        this.LOCK_TIMEOUT_SPAN_FACTOR = Utils$.MODULE$.isTesting() ? 0.5 : 0.1;
        Option option = (Option)conf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL_SUBDOMAIN());
        if (option instanceof Some) {
            String _subdomain;
            Some some = (Some)option;
            string2 = _subdomain = (String)some.value();
        } else if (None$.MODULE$.equals(option) && this.clientPoolSize() > 0) {
            int poolSize = scala.math.package$.MODULE$.min(this.clientPoolSize(), this.poolThreshold());
            if (poolSize < this.clientPoolSize()) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Request engine pool size(").append(this.clientPoolSize()).append(") exceeds, fallback to ").append("system threshold ").append(this.poolThreshold()).toString());
            }
            string2 = new StringBuilder(1).append(this.clientPoolName()).append("-").append(Random$.MODULE$.nextInt(poolSize)).toString();
        } else {
            string2 = "default";
        }
        this.subdomain = string2;
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.SERVER();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            string = Utils$.MODULE$.currentUser();
        } else {
            Enumeration.Value value4 = ShareLevel$.MODULE$.GROUP();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                String string3;
                UserGroupInformation clientUGI = UserGroupInformation.createRemoteUser((String)user);
                Option option2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])clientUGI.getGroupNames())).headOption();
                if (option2 instanceof Some) {
                    String primaryGroup;
                    Some some = (Some)option2;
                    string3 = primaryGroup = (String)some.value();
                } else if (None$.MODULE$.equals(option2)) {
                    this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("There is no primary group for ").append($this.user).append(", use the client user name as group directly").toString());
                    string3 = user;
                } else {
                    throw new MatchError((Object)option2);
                }
                string = string3;
            } else {
                string = user;
            }
        }
        this.appUser = string;
        String commonNamePrefix = new StringBuilder(9).append("kyuubi_").append(this.shareLevel()).append("_").append(this.engineType()).append("_").append(this.appUser()).toString();
        Enumeration.Value value6 = this.shareLevel();
        Enumeration.Value value7 = ShareLevel$.MODULE$.CONNECTION();
        Enumeration.Value value8 = value6;
        String string4 = !(value7 != null ? !value7.equals(value8) : value8 != null) ? new StringBuilder(1).append(commonNamePrefix).append("_").append(engineRefId).toString() : new StringBuilder(2).append(commonNamePrefix).append("_").append(this.subdomain()).append("_").append(engineRefId).toString();
        this.defaultEngineName = string4;
    }
}

