/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.api.plugins;

import java.util.Arrays;
import org.apache.logging.log4j.catalog.api.ConstraintType;
import org.apache.logging.log4j.catalog.api.util.StringUtils;
import org.apache.logging.log4j.core.config.plugins.Plugin;

@Plugin(name="anyCaseEnum", category="Constraint")
public class CaseInsensitiveEnumConstraint
implements ConstraintType {
    @Override
    public void validate(boolean isRequestContext, String name, String value, String enums, StringBuilder error) {
        if (!StringUtils.isBlank(enums) && !StringUtils.isBlank(value)) {
            boolean result = Arrays.stream(enums.trim().split("\\s*,\\s*")).anyMatch(value::equalsIgnoreCase);
            if (!result) {
                StringUtils.appendNewline(error);
                if (isRequestContext) {
                    error.append("ThreadContext key ");
                }
                error.append(name).append(" does not match one of the values: ").append(enums);
            }
        }
    }
}

