/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.lucene.analysis.ko.util.ConnectionCostsWriter;

class ConnectionCostsBuilder {
    private ConnectionCostsBuilder() {
    }

    public static ConnectionCostsWriter build(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.US_ASCII);){
            ConnectionCostsWriter connectionCostsWriter;
            try (LineNumberReader lineReader = new LineNumberReader(reader);){
                String line = lineReader.readLine();
                String[] dimensions = line.split("\\s+");
                assert (dimensions.length == 2);
                int forwardSize = Integer.parseInt(dimensions[0]);
                int backwardSize = Integer.parseInt(dimensions[1]);
                assert (forwardSize > 0 && backwardSize > 0);
                ConnectionCostsWriter costs = new ConnectionCostsWriter(forwardSize, backwardSize);
                while ((line = lineReader.readLine()) != null) {
                    String[] fields = line.split("\\s+");
                    assert (fields.length == 3);
                    int forwardId = Integer.parseInt(fields[0]);
                    int backwardId = Integer.parseInt(fields[1]);
                    int cost = Integer.parseInt(fields[2]);
                    costs.add(forwardId, backwardId, cost);
                }
                connectionCostsWriter = costs;
            }
            return connectionCostsWriter;
        }
    }
}

