/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.internal.feature.FeatureExpression;
import org.apache.sis.internal.filter.Node;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.iso.Names;
import org.apache.sis.util.resources.Errors;

abstract class LeafExpression<R, V>
extends Node
implements FeatureExpression<R, V> {
    private static final long serialVersionUID = 4262341851590811918L;

    LeafExpression() {
    }

    @Override
    public final List<Expression<? super R, ?>> getParameters() {
        return Collections.emptyList();
    }

    static final class Transformed<R, V>
    extends Literal<R, V>
    implements Optimization.OnExpression<R, V> {
        private static final long serialVersionUID = -5120203649333919221L;
        final Expression<R, ?> original;

        Transformed(V v, Expression<R, ?> expression) {
            super(v);
            this.original = expression;
        }

        @Override
        public Expression<? super R, ? extends V> optimize(Optimization optimization) {
            return Optimization.literal(this.getValue());
        }

        @Override
        public <N> Expression<R, N> toValueType(Class<N> clazz) {
            try {
                N n = ObjectConverters.convert(this.value, clazz);
                return n != this.value ? new Literal(n) : this;
            }
            catch (UnconvertibleObjectException unconvertibleObjectException) {
                try {
                    return this.original.toValueType(clazz);
                }
                catch (RuntimeException runtimeException) {
                    ClassCastException classCastException = new ClassCastException(Errors.format((short)8, this.getFunctionName(), clazz));
                    classCastException.initCause(unconvertibleObjectException);
                    classCastException.addSuppressed(runtimeException);
                    throw classCastException;
                }
            }
        }
    }

    static class Literal<R, V>
    extends LeafExpression<R, V>
    implements org.apache.sis.internal.geoapi.filter.Literal<R, V> {
        private static final long serialVersionUID = -8383113218490957822L;
        protected final V value;
        private static final WeakValueHashMap<Class<?>, DefaultAttributeType<?>> TYPES = new WeakValueHashMap(Class.class);

        Literal(V v) {
            this.value = v;
        }

        @Override
        protected Collection<?> getChildren() {
            return Collections.singleton(this.value);
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public Class<?> getValueClass() {
            return this.value != null ? this.value.getClass() : Object.class;
        }

        @Override
        public V apply(Object object) {
            return this.value;
        }

        @Override
        public <N> Expression<R, N> toValueType(Class<N> clazz) {
            try {
                N n = ObjectConverters.convert(this.value, clazz);
                return n != this.value ? new Literal<R, N>(n) : this;
            }
            catch (UnconvertibleObjectException unconvertibleObjectException) {
                throw (ClassCastException)new ClassCastException(Errors.format((short)8, this.getFunctionName(), clazz)).initCause(unconvertibleObjectException);
            }
        }

        @Override
        public PropertyTypeBuilder expectedType(DefaultFeatureType defaultFeatureType, FeatureTypeBuilder featureTypeBuilder) {
            Class<?> clazz = this.getValueClass();
            DefaultAttributeType defaultAttributeType = TYPES.get(clazz);
            if (defaultAttributeType == null) {
                Class<?> clazz2 = Classes.getStandardType(clazz);
                defaultAttributeType = TYPES.computeIfAbsent(clazz2, Literal::newType);
                if (clazz != clazz2) {
                    TYPES.put(clazz, defaultAttributeType);
                }
            }
            return featureTypeBuilder.addProperty(defaultAttributeType);
        }

        private static <R> DefaultAttributeType<R> newType(Class<R> clazz) {
            return Literal.createType(clazz, Names.createLocalName(null, null, "Literal"));
        }
    }
}

