/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.DatumShiftGridCompressed;
import org.apache.sis.internal.referencing.provider.DatumShiftGridFile;
import org.apache.sis.internal.referencing.provider.DatumShiftGridGroup;
import org.apache.sis.internal.referencing.provider.DatumShiftGridLoader;
import org.apache.sis.internal.system.DataDirectory;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;

@XmlTransient
public final class NTv2
extends AbstractProvider {
    private static final long serialVersionUID = -4027618007780159180L;
    static final ParameterDescriptor<Path> FILE;
    private static final ParameterDescriptorGroup PARAMETERS;

    public NTv2() {
        super(2, 2, PARAMETERS);
    }

    public Class<Transformation> getOperationType() {
        return Transformation.class;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException, FactoryException {
        return NTv2.createMathTransform(NTv2.class, mathTransformFactory, parameterValueGroup, 2);
    }

    static MathTransform createMathTransform(Class<? extends AbstractProvider> clazz, MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup, int n) throws ParameterNotFoundException, FactoryException {
        Parameters parameters = Parameters.castOrWrap(parameterValueGroup);
        DatumShiftGridFile<Angle, Angle> datumShiftGridFile = NTv2.getOrLoad(clazz, parameters.getMandatoryValue(FILE), n);
        return DatumShiftGridFile.createGeodeticTransformation(clazz, mathTransformFactory, datumShiftGridFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DatumShiftGridFile<Angle, Angle> getOrLoad(Class<? extends AbstractProvider> clazz, Path path, int n) throws FactoryException {
        DatumShiftGridFile<Object, Object> datumShiftGridFile;
        block12: {
            Path path2 = DataDirectory.DATUM_CHANGES.resolve(path).toAbsolutePath();
            datumShiftGridFile = DatumShiftGridFile.CACHE.peek(path2);
            if (datumShiftGridFile == null) {
                Cache.Handler<DatumShiftGridFile<?, ?>> handler = DatumShiftGridFile.CACHE.lock(path2);
                try {
                    datumShiftGridFile = handler.peek();
                    if (datumShiftGridFile != null) break block12;
                    try (SeekableByteChannel seekableByteChannel = Files.newByteChannel(path2, new OpenOption[0]);){
                        DatumShiftGridLoader.startLoading(clazz, path);
                        Loader loader = new Loader((ReadableByteChannel)seekableByteChannel, path, n);
                        datumShiftGridFile = loader.readAllGrids();
                        loader.report(clazz);
                    }
                    catch (IOException | RuntimeException | NoninvertibleTransformException throwable) {
                        throw DatumShiftGridLoader.canNotLoad(clazz.getSimpleName(), path, (Exception)throwable);
                    }
                    datumShiftGridFile = datumShiftGridFile.useSharedData();
                }
                finally {
                    handler.putAndUnlock(datumShiftGridFile);
                }
            }
        }
        return datumShiftGridFile.castTo(Angle.class, Angle.class);
    }

    static {
        ParameterBuilder parameterBuilder = NTv2.builder();
        FILE = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("8656")).addName("Latitude and longitude difference file")).create(Path.class, null);
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier("9615")).addName("NTv2")).createGroup(new GeneralParameterDescriptor[]{FILE});
    }

    private static final class Loader
    extends DatumShiftGridLoader {
        private static final int RECORD_LENGTH = 16;
        private static final int KEY_LENGTH = 8;
        private static final Map<String, DataType> TYPES;
        private final Map<String, Object> header = new LinkedHashMap<String, Object>();
        private final String[] overviewKeys;
        private final boolean isV2;
        private boolean hasUnrecognized;
        private final int numGrids;
        private String created;
        private String updated;

        Loader(ReadableByteChannel readableByteChannel, Path path, int n) throws IOException, FactoryException {
            super(readableByteChannel, ByteBuffer.allocate(4096), path);
            this.ensureBufferContains(16);
            if (Loader.isLittleEndian(this.buffer.getInt(8))) {
                this.buffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            this.readHeader(n >= 2 ? 11 : 12, "NUM_OREC");
            String string = (String)this.get("VERSION", false);
            if (string != null) {
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c < '0' || c > '9') continue;
                    n = c - 48;
                    break;
                }
            }
            Integer n2 = (Integer)this.get("NUM_FILE", string != null && n >= 2);
            boolean bl = this.isV2 = n2 != null;
            if (this.isV2) {
                this.numGrids = n2;
                if (this.numGrids < 1) {
                    throw new FactoryException(Errors.format((short)144, "NUM_FILE", n2));
                }
            } else {
                this.numGrids = 1;
            }
            this.overviewKeys = this.header.keySet().toArray(new String[this.header.size()]);
        }

        private static boolean isLittleEndian(int n) {
            return Integer.compareUnsigned(n, Integer.reverseBytes(n)) > 0;
        }

        private String readString(int n) {
            byte[] byArray = this.buffer.array();
            int n2 = this.buffer.position();
            this.buffer.position(n2 + n);
            while (n > n2 && byArray[n2 + n - 1] <= 32) {
                --n;
            }
            return new String(byArray, n2, n, StandardCharsets.US_ASCII).trim();
        }

        private void readHeader(int n, String string) throws IOException, FactoryException {
            for (int i = 0; i < n; ++i) {
                Object object;
                this.ensureBufferContains(16);
                String string2 = this.readString(8).toUpperCase(Locale.US).replace(' ', '_');
                DataType dataType = TYPES.get(string2);
                if (dataType == null) {
                    object = null;
                    this.hasUnrecognized = true;
                } else {
                    switch (dataType) {
                        default: {
                            throw new AssertionError((Object)dataType);
                        }
                        case STRING: {
                            object = this.readString(8);
                            break;
                        }
                        case DOUBLE: {
                            object = this.buffer.getDouble();
                            break;
                        }
                        case INTEGER: {
                            int n2 = this.buffer.getInt();
                            this.buffer.position(this.buffer.position() + 4);
                            if (string2.equals(string) || string2.equals("HEADER")) {
                                n = n2;
                            }
                            object = n2;
                            break;
                        }
                    }
                }
                Object object2 = this.header.put(string2, object);
                if (object2 == null || object2.equals(object)) continue;
                throw new FactoryException(Errors.format((short)75, string2));
            }
            if (this.created == null) {
                this.created = Strings.trimOrNull((String)this.get("CREATED", false));
            }
            if (this.updated == null) {
                this.updated = Strings.trimOrNull((String)this.get("UPDATED", false));
            }
        }

        final DatumShiftGridFile<Angle, Angle> readAllGrids() throws IOException, FactoryException, NoninvertibleTransformException {
            HashMap<String, DatumShiftGridFile<Angle, Angle>> hashMap = new HashMap<String, DatumShiftGridFile<Angle, Angle>>(Containers.hashMapCapacity(this.numGrids));
            LinkedHashMap<String, List<DatumShiftGridFile<Angle, Angle>>> linkedHashMap = new LinkedHashMap<String, List<DatumShiftGridFile<Angle, Angle>>>();
            while (hashMap.size() < this.numGrids) {
                this.readGrid(hashMap, linkedHashMap);
            }
            ArrayList arrayList = new ArrayList();
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                DatumShiftGridFile datumShiftGridFile = (DatumShiftGridFile)hashMap.get(entry.getKey());
                List list = (List)entry.getValue();
                if (datumShiftGridFile != null) {
                    int n = list.size();
                    while (--n >= 0) {
                        if (list.get(n) != datumShiftGridFile) continue;
                        list.remove(n);
                        arrayList.add(datumShiftGridFile);
                        break;
                    }
                    if (list.isEmpty()) continue;
                    datumShiftGridFile.setSubGrids(list);
                    continue;
                }
                arrayList.addAll(list);
            }
            switch (arrayList.size()) {
                case 0: {
                    throw new FactoryException(Errors.format((short)12, this.file));
                }
                case 1: {
                    return (DatumShiftGridFile)arrayList.get(0);
                }
            }
            return DatumShiftGridGroup.create(this.file, arrayList);
        }

        private void readGrid(Map<String, DatumShiftGridFile<Angle, Angle>> map, Map<String, List<DatumShiftGridFile<Angle, Angle>>> map2) throws IOException, FactoryException, NoninvertibleTransformException {
            DatumShiftGridFile datumShiftGridFile;
            Object object;
            double d;
            Unit<Angle> unit;
            String string2;
            if (this.isV2) {
                this.readHeader((Integer)this.get("NUM_SREC", null, null), "NUM_SREC");
            }
            if ((string2 = (String)this.get("GS_TYPE", "TYPE", null)).equalsIgnoreCase("SECONDS")) {
                unit = Units.ARC_SECOND;
                d = 1.0E-4;
            } else if (string2.equalsIgnoreCase("MINUTES")) {
                unit = Units.ARC_MINUTE;
                d = 1.6666666666666667E-6;
            } else if (string2.equalsIgnoreCase("DEGREES")) {
                unit = Units.DEGREE;
                d = 2.777777777777778E-8;
            } else {
                throw new FactoryException(Errors.format((short)144, "GS_TYPE", string2));
            }
            double d2 = (Double)this.get("S_LAT", null, null);
            double d3 = (Double)this.get("N_LAT", null, null);
            double d4 = (Double)this.get("E_LONG", null, null);
            double d5 = (Double)this.get("W_LONG", null, null);
            double d6 = (Double)this.get("LAT_INC", "N_GRID", null);
            double d7 = (Double)this.get("LONG_INC", "W_GRID", null);
            Integer n = (Integer)this.get("GS_COUNT", false);
            int n2 = Math.toIntExact(Math.round((d5 - d4) / d7 + 1.0));
            int n3 = Math.toIntExact(Math.round((d3 - d2) / d6 + 1.0));
            int n4 = Math.multiplyExact(n2, n3);
            if (n != null && n4 != n) {
                throw new FactoryException(Errors.format((short)144, "GS_COUNT", n));
            }
            double d8 = Math.max(d7, d6);
            if (this.isV2) {
                object = new DatumShiftGridFile.Float<Angle, Angle>(2, unit, unit, true, -d4, d2, -d7, d6, n2, n3, PARAMETERS, this.file);
                float[] fArray = ((DatumShiftGridFile.Float)object).offsets[0];
                float[] fArray2 = ((DatumShiftGridFile.Float)object).offsets[1];
                ((DatumShiftGridFile.Float)object).accuracy = Double.NaN;
                for (int i = 0; i < n4; ++i) {
                    this.ensureBufferContains(16);
                    fArray2[i] = (float)((double)this.buffer.getFloat() / d6);
                    fArray[i] = (float)((double)this.buffer.getFloat() / d7);
                    double d9 = Math.min((double)this.buffer.getFloat() / d6, (double)this.buffer.getFloat() / d7);
                    if (!(d9 > 0.0) || d9 >= ((DatumShiftGridFile.Float)object).accuracy) continue;
                    ((DatumShiftGridFile.Float)object).accuracy = d9;
                }
                datumShiftGridFile = DatumShiftGridCompressed.compress(object, null, d / d8);
            } else {
                object = new DatumShiftGridFile.Double<Angle, Angle>(2, unit, unit, true, -d4, d2, -d7, d6, n2, n3, PARAMETERS, this.file);
                datumShiftGridFile = object;
                double[] dArray = ((DatumShiftGridFile.Double)object).offsets[0];
                double[] dArray2 = ((DatumShiftGridFile.Double)object).offsets[1];
                for (int i = 0; i < n4; ++i) {
                    this.ensureBufferContains(16);
                    dArray2[i] = this.buffer.getDouble() / d6;
                    dArray[i] = this.buffer.getDouble() / d7;
                }
            }
            if (!(datumShiftGridFile.accuracy > 0.0)) {
                datumShiftGridFile.accuracy = Units.DEGREE.getConverterTo(unit).convert(8.999280057595393E-8) / d8;
            }
            if (map.put((String)(object = (String)this.get("SUB_NAME", this.numGrids > 1)), datumShiftGridFile) != null) {
                throw new FactoryException(Errors.format((short)25, object));
            }
            map2.computeIfAbsent((String)this.get("PARENT", this.numGrids > 1), string -> new ArrayList()).add(datumShiftGridFile);
            this.header.keySet().retainAll(Arrays.asList(this.overviewKeys));
        }

        private Object get(String string, boolean bl) throws FactoryException {
            Object object = this.header.get(string);
            if (object != null || !bl) {
                return object;
            }
            throw new FactoryException(Errors.format((short)120, this.file, string));
        }

        private Object get(String string, String string2, String string3) throws FactoryException {
            Object object = this.header.get(string);
            if (object == null && (object = this.header.get(string2)) == null && (object = this.header.get(string3)) == null) {
                throw new FactoryException(Errors.format((short)120, this.file, string));
            }
            return object;
        }

        void report(Class<? extends AbstractProvider> clazz) {
            CharSequence charSequence;
            try {
                charSequence = (String)this.get("SYSTEM_F", "DATUM_F", "FROM");
                String string = (String)this.get("SYSTEM_T", "DATUM_T", "TO");
                Loader.log(clazz, Resources.forLocale(null).getLogRecord(Level.FINE, (short)93, charSequence, string, this.created != null ? this.created : "?", this.updated != null ? this.updated : "?"));
            }
            catch (FactoryException factoryException) {
                AbstractProvider.recoverableException(clazz, (Exception)((Object)factoryException));
            }
            if (this.hasUnrecognized) {
                charSequence = new StringBuilder();
                for (Map.Entry entry : this.header.entrySet()) {
                    if (entry.getValue() != null) continue;
                    if (((StringBuilder)charSequence).length() != 0) {
                        ((StringBuilder)charSequence).append(", ");
                    }
                    ((StringBuilder)charSequence).append((String)entry.getKey());
                }
                Loader.log(clazz, Messages.getResources(null).getLogRecord(Level.WARNING, (short)30, this.file, ((StringBuilder)charSequence).toString()));
            }
        }

        static {
            HashMap<String, DataType> hashMap = new HashMap<String, DataType>(38);
            hashMap.put("HEADER", DataType.INTEGER);
            hashMap.put("NUM_OREC", DataType.INTEGER);
            hashMap.put("NUM_SREC", DataType.INTEGER);
            hashMap.put("NUM_FILE", DataType.INTEGER);
            hashMap.put("TYPE", DataType.STRING);
            hashMap.put("GS_TYPE", DataType.STRING);
            hashMap.put("VERSION", DataType.STRING);
            hashMap.put("FROM", DataType.STRING);
            hashMap.put("TO", DataType.STRING);
            hashMap.put("SYSTEM_F", DataType.STRING);
            hashMap.put("SYSTEM_T", DataType.STRING);
            hashMap.put("DATUM_F", DataType.STRING);
            hashMap.put("DATUM_T", DataType.STRING);
            hashMap.put("MAJOR_F", DataType.DOUBLE);
            hashMap.put("MINOR_F", DataType.DOUBLE);
            hashMap.put("MAJOR_T", DataType.DOUBLE);
            hashMap.put("MINOR_T", DataType.DOUBLE);
            hashMap.put("SUB_NAME", DataType.STRING);
            hashMap.put("PARENT", DataType.STRING);
            hashMap.put("CREATED", DataType.STRING);
            hashMap.put("UPDATED", DataType.STRING);
            hashMap.put("S_LAT", DataType.DOUBLE);
            hashMap.put("N_LAT", DataType.DOUBLE);
            hashMap.put("E_LONG", DataType.DOUBLE);
            hashMap.put("W_LONG", DataType.DOUBLE);
            hashMap.put("N_GRID", DataType.DOUBLE);
            hashMap.put("W_GRID", DataType.DOUBLE);
            hashMap.put("LAT_INC", DataType.DOUBLE);
            hashMap.put("LONG_INC", DataType.DOUBLE);
            hashMap.put("GS_COUNT", DataType.INTEGER);
            TYPES = hashMap;
        }

        private static enum DataType {
            STRING,
            INTEGER,
            DOUBLE;

        }
    }
}

