/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.impl.XMLConverter;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomDocumentBase;

public class AtomEntry
extends AtomDocumentBase {
    private static final String DEFAULT_AUTHOR = "unknown";

    public AtomEntry() {
    }

    public AtomEntry(XMLStreamWriter writer) {
        this.setWriter(writer);
    }

    public void startEntry(boolean isRoot) throws XMLStreamException {
        XMLStreamWriter xsw = this.getWriter();
        xsw.writeStartElement("atom", "entry", "http://www.w3.org/2005/Atom");
        if (isRoot) {
            xsw.writeNamespace("atom", "http://www.w3.org/2005/Atom");
            xsw.writeNamespace("cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/");
            xsw.writeNamespace("cmisra", "http://docs.oasis-open.org/ns/cmis/restatom/200908/");
            xsw.writeNamespace("app", "http://www.w3.org/2007/app");
            this.writeAllCustomNamespace();
        }
    }

    public void endEntry() throws XMLStreamException {
        this.getWriter().writeEndElement();
    }

    public void writeSelfLink(String href, String id) throws XMLStreamException {
        this.writeSelfLink(href, "application/atom+xml;type=entry", id);
    }

    public void writeObject(ObjectData object, ObjectInfo info, String contentSrc, String contentType, String pathSegment, String relativePathSegment, CmisVersion cmisVersion) throws XMLStreamException {
        if (object == null) {
            return;
        }
        this.writeAuthor(info.getCreatedBy());
        this.writeId(info.getAtomId() == null ? this.generateAtomId(info.getId()) : info.getAtomId());
        this.writePublished(info.getCreationDate());
        this.writeTitle(info.getName());
        this.writeUpdated(info.getLastModificationDate());
        this.writeContent(contentSrc, contentType);
        XMLConverter.writeObject((XMLStreamWriter)this.getWriter(), (CmisVersion)cmisVersion, (boolean)false, (String)"object", (String)"http://docs.oasis-open.org/ns/cmis/restatom/200908/", (ObjectData)object);
        this.writePathSegment(pathSegment);
        this.writeRelativePathSegment(relativePathSegment);
    }

    public void writeDeletedObject(ObjectData object, CmisVersion cmisVersion) throws XMLStreamException {
        if (object == null) {
            return;
        }
        long now = System.currentTimeMillis();
        this.writeAuthor(DEFAULT_AUTHOR);
        this.writeId(this.generateAtomId(object.getId()));
        this.writePublished(now);
        this.writeTitle(object.getId());
        this.writeUpdated(now);
        XMLConverter.writeObject((XMLStreamWriter)this.getWriter(), (CmisVersion)cmisVersion, (boolean)false, (String)"object", (String)"http://docs.oasis-open.org/ns/cmis/restatom/200908/", (ObjectData)object);
    }

    public void writeType(TypeDefinition type, CmisVersion cmisVersion) throws XMLStreamException {
        if (type == null) {
            return;
        }
        long now = System.currentTimeMillis();
        this.writeAuthor(DEFAULT_AUTHOR);
        this.writeId(this.generateAtomId(type.getId()));
        this.writeTitle(type.getDisplayName());
        this.writeUpdated(now);
        XMLConverter.writeTypeDefinition((XMLStreamWriter)this.getWriter(), (CmisVersion)cmisVersion, (String)"http://docs.oasis-open.org/ns/cmis/restatom/200908/", (TypeDefinition)type);
    }

    public void writeContent(String src, String type) throws XMLStreamException {
        if (src == null) {
            return;
        }
        XMLStreamWriter xsw = this.getWriter();
        xsw.writeStartElement("atom", "content", "http://www.w3.org/2005/Atom");
        xsw.writeAttribute("src", src);
        if (type != null) {
            xsw.writeAttribute("type", type);
        }
        xsw.writeEndElement();
    }

    public void writeEmptyContent() throws XMLStreamException {
        XMLStreamWriter xsw = this.getWriter();
        xsw.writeStartElement("atom", "content", "http://www.w3.org/2005/Atom");
        xsw.writeEndElement();
    }
}

