/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.path;

import java.io.File;
import java.util.ArrayList;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Resource;
import org.apache.maven.project.path.PathTranslator;

@Deprecated
@Named
@Singleton
public class DefaultPathTranslator
implements PathTranslator {
    private static final String[] BASEDIR_EXPRESSIONS = new String[]{"${basedir}", "${pom.basedir}", "${project.basedir}"};

    @Override
    public void alignToBaseDirectory(Model model, File basedir) {
        Reporting reporting;
        if (basedir == null) {
            return;
        }
        Build build = model.getBuild();
        if (build != null) {
            build.setDirectory(this.alignToBaseDirectory(build.getDirectory(), basedir));
            build.setSourceDirectory(this.alignToBaseDirectory(build.getSourceDirectory(), basedir));
            build.setTestSourceDirectory(this.alignToBaseDirectory(build.getTestSourceDirectory(), basedir));
            for (Resource resource : build.getResources()) {
                resource.setDirectory(this.alignToBaseDirectory(resource.getDirectory(), basedir));
            }
            for (Resource resource : build.getTestResources()) {
                resource.setDirectory(this.alignToBaseDirectory(resource.getDirectory(), basedir));
            }
            if (build.getFilters() != null) {
                ArrayList<String> filters = new ArrayList<String>();
                for (String filter : build.getFilters()) {
                    filters.add(this.alignToBaseDirectory(filter, basedir));
                }
                build.setFilters(filters);
            }
            build.setOutputDirectory(this.alignToBaseDirectory(build.getOutputDirectory(), basedir));
            build.setTestOutputDirectory(this.alignToBaseDirectory(build.getTestOutputDirectory(), basedir));
        }
        if ((reporting = model.getReporting()) != null) {
            reporting.setOutputDirectory(this.alignToBaseDirectory(reporting.getOutputDirectory(), basedir));
        }
    }

    @Override
    public String alignToBaseDirectory(String path, File basedir) {
        if (basedir == null) {
            return path;
        }
        if (path == null) {
            return null;
        }
        String s = this.stripBasedirToken(path);
        File file = new File(s);
        s = file.isAbsolute() ? file.getPath() : (file.getPath().startsWith(File.separator) ? file.getAbsolutePath() : new File(new File(basedir, s).toURI().normalize()).getAbsolutePath());
        return s;
    }

    private String stripBasedirToken(String s) {
        if (s != null) {
            String basedirExpr = null;
            for (String expression : BASEDIR_EXPRESSIONS) {
                if (!s.startsWith(expression)) continue;
                basedirExpr = expression;
                break;
            }
            if (basedirExpr != null) {
                s = s.length() > basedirExpr.length() ? this.chopLeadingFileSeparator(s.substring(basedirExpr.length())) : ".";
            }
        }
        return s;
    }

    private String chopLeadingFileSeparator(String path) {
        if (path != null && (path.startsWith("/") || path.startsWith("\\"))) {
            path = path.substring(1);
        }
        return path;
    }

    @Override
    public void unalignFromBaseDirectory(Model model, File basedir) {
        Reporting reporting;
        if (basedir == null) {
            return;
        }
        Build build = model.getBuild();
        if (build != null) {
            build.setDirectory(this.unalignFromBaseDirectory(build.getDirectory(), basedir));
            build.setSourceDirectory(this.unalignFromBaseDirectory(build.getSourceDirectory(), basedir));
            build.setTestSourceDirectory(this.unalignFromBaseDirectory(build.getTestSourceDirectory(), basedir));
            for (Resource resource : build.getResources()) {
                resource.setDirectory(this.unalignFromBaseDirectory(resource.getDirectory(), basedir));
            }
            for (Resource resource : build.getTestResources()) {
                resource.setDirectory(this.unalignFromBaseDirectory(resource.getDirectory(), basedir));
            }
            if (build.getFilters() != null) {
                ArrayList<String> filters = new ArrayList<String>();
                for (String filter : build.getFilters()) {
                    filters.add(this.unalignFromBaseDirectory(filter, basedir));
                }
                build.setFilters(filters);
            }
            build.setOutputDirectory(this.unalignFromBaseDirectory(build.getOutputDirectory(), basedir));
            build.setTestOutputDirectory(this.unalignFromBaseDirectory(build.getTestOutputDirectory(), basedir));
        }
        if ((reporting = model.getReporting()) != null) {
            reporting.setOutputDirectory(this.unalignFromBaseDirectory(reporting.getOutputDirectory(), basedir));
        }
    }

    @Override
    public String unalignFromBaseDirectory(String path, File basedir) {
        String base;
        if (basedir == null) {
            return path;
        }
        if (path == null) {
            return null;
        }
        if ((path = path.trim()).startsWith(base = basedir.getAbsolutePath())) {
            path = this.chopLeadingFileSeparator(path.substring(base.length()));
        }
        if (path.isEmpty()) {
            path = ".";
        }
        if (!new File(path).isAbsolute()) {
            path = path.replace('\\', '/');
        }
        return path;
    }
}

