/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.mina;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.transport.socket.nio.NioSession;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.mina.MinaService;

public class MinaAcceptor
extends MinaService
implements IoAcceptor,
org.apache.mina.core.service.IoHandler {
    protected final AtomicReference<org.apache.mina.core.service.IoAcceptor> acceptorHolder = new AtomicReference<Object>(null);
    protected int backlog;
    protected boolean reuseAddress;

    public MinaAcceptor(FactoryManager manager, IoHandler handler, IoProcessor<NioSession> ioProcessor) {
        super(manager, handler, ioProcessor);
        this.backlog = (Integer)CoreModuleProperties.SOCKET_BACKLOG.getRequired((PropertyResolver)manager);
        this.reuseAddress = (Boolean)CoreModuleProperties.SOCKET_REUSEADDR.getRequired((PropertyResolver)manager);
    }

    protected org.apache.mina.core.service.IoAcceptor createAcceptor() {
        NioSocketAcceptor acceptor = new NioSocketAcceptor(this.ioProcessor);
        acceptor.setCloseOnDeactivation(false);
        acceptor.setReuseAddress(this.reuseAddress);
        acceptor.setBacklog(this.backlog);
        this.configure(acceptor.getSessionConfig());
        return acceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected org.apache.mina.core.service.IoAcceptor getAcceptor() {
        org.apache.mina.core.service.IoAcceptor acceptor;
        AtomicReference<org.apache.mina.core.service.IoAcceptor> atomicReference = this.acceptorHolder;
        synchronized (atomicReference) {
            acceptor = this.acceptorHolder.get();
            if (acceptor != null) {
                return acceptor;
            }
            acceptor = this.createAcceptor();
            acceptor.setHandler((org.apache.mina.core.service.IoHandler)this);
            this.acceptorHolder.set(acceptor);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Created IoAcceptor: {}", (Object)this);
        }
        return acceptor;
    }

    public void sessionCreated(IoSession session) throws Exception {
        IoServiceEventListener listener = this.getIoServiceEventListener();
        SocketAddress local = session.getLocalAddress();
        SocketAddress remote = session.getRemoteAddress();
        SocketAddress service = session.getServiceAddress();
        try {
            if (listener != null) {
                try {
                    listener.connectionAccepted((IoAcceptor)this, local, remote, service);
                }
                catch (Exception e) {
                    session.closeNow();
                    throw e;
                }
            }
            this.sessionCreated(session, service);
        }
        catch (Exception e) {
            if (listener != null) {
                try {
                    listener.abortAcceptedConnection((IoAcceptor)this, local, remote, service, (Throwable)e);
                }
                catch (Exception exc) {
                    this.debug("sessionCreated({})[{}] ignoring abort event failure={}: {}", session, listener, exc.getClass().getSimpleName(), exc.getMessage(), exc);
                }
            }
            throw e;
        }
    }

    @Override
    protected IoService getIoService() {
        return this.getAcceptor();
    }

    public void bind(Collection<? extends SocketAddress> addresses) throws IOException {
        org.apache.mina.core.service.IoAcceptor acceptor = this.getAcceptor();
        acceptor.bind(addresses);
    }

    public void bind(SocketAddress address) throws IOException {
        org.apache.mina.core.service.IoAcceptor acceptor = this.getAcceptor();
        acceptor.bind(address);
    }

    public void unbind() {
        org.apache.mina.core.service.IoAcceptor acceptor = this.getAcceptor();
        acceptor.unbind();
    }

    public void unbind(Collection<? extends SocketAddress> addresses) {
        org.apache.mina.core.service.IoAcceptor acceptor = this.getAcceptor();
        acceptor.unbind(addresses);
    }

    public void unbind(SocketAddress address) {
        org.apache.mina.core.service.IoAcceptor acceptor = this.getAcceptor();
        acceptor.unbind(address);
    }

    public Set<SocketAddress> getBoundAddresses() {
        org.apache.mina.core.service.IoAcceptor acceptor = this.getAcceptor();
        return acceptor.getLocalAddresses();
    }
}

