/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.scripting.impl;

import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Named;
import javax.script.ScriptEngine;
import org.apache.myfaces.extensions.cdi.scripting.api.LanguageManager;
import org.apache.myfaces.extensions.cdi.scripting.api.ScriptBuilder;
import org.apache.myfaces.extensions.cdi.scripting.api.ScriptExecutor;
import org.apache.myfaces.extensions.cdi.scripting.api.ScriptLanguage;
import org.apache.myfaces.extensions.cdi.scripting.api.language.Language;
import org.apache.myfaces.extensions.cdi.scripting.impl.DefaultScriptBuilder;
import org.apache.myfaces.extensions.cdi.scripting.impl.DefaultScriptExecutor;
import org.apache.myfaces.extensions.cdi.scripting.impl.InjectableScriptEngine;
import org.apache.myfaces.extensions.cdi.scripting.impl.util.ExceptionUtils;
import org.apache.myfaces.extensions.cdi.scripting.impl.util.ScriptingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class ScriptEngineManagerProducer {
    protected ScriptEngineManagerProducer() {
    }

    @Produces
    @Dependent
    @Named(value="sExec")
    public Map<String, Object> createScriptExecutorBeanForAlias() {
        return this.createScriptExecutorBean();
    }

    @Produces
    @Dependent
    @Named(value="scriptExecutor")
    public Map<String, Object> createScriptExecutorBean() {
        return ScriptingUtils.createExpressionLanguageHelper();
    }

    @Produces
    @ScriptLanguage(value=PlaceHolderLanguage.class)
    @Dependent
    public ScriptExecutor createScriptExecutor(InjectionPoint injectionPoint, LanguageManager languageManager) {
        InjectableScriptEngine scriptEngine = this.createScriptEngineByLanguageName(injectionPoint, languageManager);
        return this.createScriptExecutorForScriptEngine(scriptEngine, injectionPoint);
    }

    private ScriptExecutor createScriptExecutorForScriptEngine(ScriptEngine scriptEngine, InjectionPoint injectionPoint) {
        Class language = ((ScriptLanguage)injectionPoint.getAnnotated().getAnnotation(ScriptLanguage.class)).value();
        return new DefaultScriptExecutor(scriptEngine, language);
    }

    @Produces
    @ScriptLanguage(value=PlaceHolderLanguage.class)
    @Dependent
    public ScriptBuilder createScriptBuilder(InjectionPoint injectionPoint, LanguageManager languageManager) {
        InjectableScriptEngine scriptEngine = this.createScriptEngineByLanguageName(injectionPoint, languageManager);
        return this.createScriptBuilderForEngine(scriptEngine, injectionPoint);
    }

    private ScriptBuilder createScriptBuilderForEngine(ScriptEngine scriptEngine, InjectionPoint injectionPoint) {
        Class language = ((ScriptLanguage)injectionPoint.getAnnotated().getAnnotation(ScriptLanguage.class)).value();
        return new DefaultScriptBuilder(scriptEngine, language);
    }

    @Produces
    @ScriptLanguage(value=PlaceHolderLanguage.class)
    @Dependent
    public InjectableScriptEngine createScriptEngineByLanguageName(InjectionPoint injectionPoint, LanguageManager languageManager) {
        Class language = ((ScriptLanguage)injectionPoint.getAnnotated().getAnnotation(ScriptLanguage.class)).value();
        String languageName = languageManager.getLanguageName(language);
        ScriptEngine result = this.checkedScriptEngine(ScriptingUtils.getCurrentScriptEngineManager().getEngineByName(languageName), languageName);
        return new InjectableScriptEngine(result, language);
    }

    private ScriptEngine checkedScriptEngine(ScriptEngine scriptEngine, String type) {
        if (scriptEngine != null) {
            return scriptEngine;
        }
        throw ExceptionUtils.unknownScriptingLanguage(type);
    }

    private static interface PlaceHolderLanguage
    extends Language {
    }
}

