/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_orchestra.renderkit.html.util;

public abstract class HTMLEncoder {
    public static String encode(String string) {
        return HTMLEncoder.encode(string, false, true);
    }

    public static String encode(String string, boolean encodeNewline) {
        return HTMLEncoder.encode(string, encodeNewline, true);
    }

    public static String encode(String string, boolean encodeNewline, boolean encodeSubsequentBlanksToNbsp) {
        return HTMLEncoder.encode(string, encodeNewline, encodeSubsequentBlanksToNbsp, true);
    }

    public static String encode(String string, boolean encodeNewline, boolean encodeSubsequentBlanksToNbsp, boolean encodeNonLatin) {
        if (string == null) {
            return "";
        }
        StringBuffer sb = null;
        for (int i = 0; i < string.length(); ++i) {
            String app = null;
            char c = string.charAt(i);
            block0 : switch (c) {
                case '\"': {
                    app = "&quot;";
                    break;
                }
                case '&': {
                    app = "&amp;";
                    break;
                }
                case '<': {
                    app = "&lt;";
                    break;
                }
                case '>': {
                    app = "&gt;";
                    break;
                }
                case ' ': {
                    if (!encodeSubsequentBlanksToNbsp || i != 0 && (i - 1 < 0 || string.charAt(i - 1) != ' ')) break;
                    app = "&#160;";
                    break;
                }
                case '\n': {
                    if (!encodeNewline) break;
                    app = "<br/>";
                    break;
                }
                default: {
                    if (!encodeNonLatin) break;
                    switch (c) {
                        case '\u00e4': {
                            app = "&auml;";
                            break block0;
                        }
                        case '\u00c4': {
                            app = "&Auml;";
                            break block0;
                        }
                        case '\u00f6': {
                            app = "&ouml;";
                            break block0;
                        }
                        case '\u00d6': {
                            app = "&Ouml;";
                            break block0;
                        }
                        case '\u00fc': {
                            app = "&uuml;";
                            break block0;
                        }
                        case '\u00dc': {
                            app = "&Uuml;";
                            break block0;
                        }
                        case '\u00df': {
                            app = "&szlig;";
                            break block0;
                        }
                        case '\u20ac': {
                            app = "&euro;";
                            break block0;
                        }
                        case '\u00ab': {
                            app = "&laquo;";
                            break block0;
                        }
                        case '\u00bb': {
                            app = "&raquo;";
                            break block0;
                        }
                        case '\u00a0': {
                            app = "&#160;";
                            break block0;
                        }
                    }
                    if (c < '\u0080') break;
                    app = "&#" + c + ";";
                }
            }
            if (app != null) {
                if (sb == null) {
                    sb = new StringBuffer(string.substring(0, i));
                }
                sb.append(app);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }
}

