/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.config;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.myfaces.tobago.internal.config.TobagoConfigFragment;
import org.apache.myfaces.tobago.internal.config.TobagoConfigImpl;
import org.apache.myfaces.tobago.internal.config.TobagoConfigMerger;
import org.apache.myfaces.tobago.internal.config.TobagoConfigParser;
import org.apache.myfaces.tobago.internal.config.TobagoConfigSorter;
import org.apache.myfaces.tobago.internal.context.ResourceManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class TobagoConfigBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(TobagoConfigBuilder.class);
    private static final String WEB_INF_TOBAGO_CONFIG_XML = "WEB-INF/tobago-config.xml";
    private static final String META_INF_TOBAGO_CONFIG_XML = "META-INF/tobago-config.xml";
    private final List<TobagoConfigFragment> list = new ArrayList<TobagoConfigFragment>();

    private TobagoConfigBuilder(ServletContext servletContext) throws ServletException, IOException, SAXException, ParserConfigurationException, URISyntaxException {
        this.configFromClasspath();
        this.configFromWebInf(servletContext);
        TobagoConfigSorter sorter = new TobagoConfigSorter(this.list);
        List<TobagoConfigFragment> sorted = sorter.topologicalSort();
        TobagoConfigImpl tobagoConfig = new TobagoConfigMerger(sorted).merge();
        tobagoConfig.initProjectState(servletContext);
        ResourceManagerFactory.init(servletContext, tobagoConfig);
        tobagoConfig.resolveThemes();
        tobagoConfig.initDefaultValidatorInfo();
        tobagoConfig.lock();
        servletContext.setAttribute("org.apache.myfaces.tobago.config.TobagoConfig", (Object)tobagoConfig);
    }

    public static void init(ServletContext servletContext) {
        block2: {
            try {
                TobagoConfigBuilder tobagoConfigBuilder = new TobagoConfigBuilder(servletContext);
            }
            catch (Throwable e) {
                if (!LOG.isErrorEnabled()) break block2;
                String error = "Error while deploy process. Tobago can't be initialized! Application will not run!";
                LOG.error("Error while deploy process. Tobago can't be initialized! Application will not run!", e);
                throw new RuntimeException("Error while deploy process. Tobago can't be initialized! Application will not run!", e);
            }
        }
    }

    private void configFromWebInf(ServletContext servletContext) throws IOException, SAXException, ParserConfigurationException, URISyntaxException {
        URL url = servletContext.getResource("/WEB-INF/tobago-config.xml");
        if (url != null) {
            this.list.add(new TobagoConfigParser().parse(url));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configFromClasspath() throws ServletException {
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info("Searching for 'META-INF/tobago-config.xml'");
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            ArrayList urls = new ArrayList();
            CollectionUtils.addAll(urls, classLoader.getResources(META_INF_TOBAGO_CONFIG_XML));
            for (URL themeUrl : urls) {
                try {
                    TobagoConfigFragment fragment = new TobagoConfigParser().parse(themeUrl);
                    fragment.setUrl(themeUrl);
                    this.list.add(fragment);
                    String protocol = themeUrl.getProtocol();
                    if ("jar".equals(protocol) || "zip".equals(protocol) || "wsjar".equals(protocol)) continue;
                    LOG.warn("Unknown protocol '" + themeUrl + "'");
                }
                catch (Exception e) {
                    throw new Exception(e.getClass().getName() + " on themeUrl: " + themeUrl, e);
                    return;
                }
            }
        }
        catch (Exception e) {
            String msg = "while loading ";
            LOG.error("while loading ", (Throwable)e);
            throw new ServletException("while loading ", (Throwable)e);
        }
    }
}

