/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.facelets.extension;

import java.io.IOException;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.TagAttribute;
import org.apache.myfaces.tobago.component.InputSuggest;
import org.apache.myfaces.tobago.component.OnComponentCreated;
import org.apache.myfaces.tobago.component.OnComponentPopulated;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.UIGridLayout;
import org.apache.myfaces.tobago.component.UILabel;
import org.apache.myfaces.tobago.component.UIPanel;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.facelets.SelectManyBoxRule;
import org.apache.myfaces.tobago.facelets.SuggestMethodRule;
import org.apache.myfaces.tobago.facelets.SupportsMarkupRule;
import org.apache.myfaces.tobago.facelets.TobagoComponentHandler;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectManyBox;
import org.apache.myfaces.tobago.internal.layout.LayoutUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TobagoLabelExtensionHandler
extends ComponentHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TobagoLabelExtensionHandler.class);
    private static final String DEFAULT_COLUMNS = "auto;*";
    private TagAttribute labelWidthAttribute = this.getAttribute("labelWidth");
    private TagAttribute tipAttribute = this.getAttribute("tip");
    private TagAttribute labelAttribute = this.getAttribute("label");
    private TagAttribute accessKeyAttribute = this.getAttribute("accessKey");
    private TagAttribute markupAttribute = this.getAttribute("markup");
    private TagAttribute fieldIdAttribute = this.getAttribute("fieldId");
    private Class subComponentLastType = Object.class;
    private Metadata subComponentMapper;

    public TobagoLabelExtensionHandler(ComponentConfig config) {
        super(config);
    }

    protected abstract String getSubComponentType();

    protected abstract String getSubRendererType();

    protected String getRows() {
        return "auto";
    }

    protected String getColumns(String first) {
        return first + ";*";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyNextHandler(FaceletContext ctx, UIComponent panel) throws IOException, ELException {
        if (ComponentHandler.isNew((UIComponent)panel)) {
            UIComponent input = (UIComponent)panel.getChildren().remove(1);
            try {
                input.getAttributes().put("tobago.panel", panel);
                this.nextHandler.apply(ctx, input);
            }
            finally {
                input.getAttributes().remove("tobago.panel");
            }
            UIComponent date = null;
            if (panel.getChildCount() > 1) {
                date = (UIComponent)panel.getChildren().get(1);
            }
            panel.getChildren().add(input);
            if (date != null) {
                panel.getChildren().add(date);
            }
        } else {
            UIComponent input = (UIComponent)panel.getChildren().get(1);
            this.nextHandler.apply(ctx, input);
        }
    }

    public void onComponentCreated(FaceletContext faceletContext, UIComponent panel, UIComponent parent) {
        Application application = faceletContext.getFacesContext().getApplication();
        this.addGridLayout(faceletContext, panel, application);
        this.addLabel(faceletContext, (UIPanel)panel, application);
        String uid = this.fieldIdAttribute != null ? this.fieldIdAttribute.getValue(faceletContext) : panel.getId() + "_tx_field";
        if (this.checkForAlreadyCreated(panel, uid)) {
            return;
        }
        UIComponent input = application.createComponent(this.getSubComponentType());
        input.setRendererType(this.getSubRendererType());
        input.setId(uid);
        this.setSubComponentAttributes(faceletContext, input);
        this.enrichInput(faceletContext, input);
        panel.getChildren().add(input);
    }

    protected void enrichInput(FaceletContext faceletContext, UIComponent input) {
    }

    private void addLabel(FaceletContext faceletContext, UIPanel panel, Application application) {
        ValueExpression expression;
        String uid = panel.getId() + "_tx_label";
        if (this.checkForAlreadyCreated((UIComponent)panel, uid)) {
            return;
        }
        UILabel label = (UILabel)application.createComponent("org.apache.myfaces.tobago.Label");
        label.setRendererType("Label");
        label.setId(uid);
        label.getAttributes().put("for", "@auto");
        if (this.tipAttribute != null) {
            if (this.tipAttribute.isLiteral()) {
                panel.setTip(this.tipAttribute.getValue(faceletContext));
            } else {
                expression = this.tipAttribute.getValueExpression(faceletContext, String.class);
                panel.setValueExpression("tip", expression);
            }
        }
        if (this.labelAttribute != null) {
            if (this.labelAttribute.isLiteral()) {
                label.setValue(this.labelAttribute.getValue(faceletContext));
            } else {
                expression = this.labelAttribute.getValueExpression(faceletContext, String.class);
                label.setValueExpression("value", expression);
            }
        }
        if (this.accessKeyAttribute != null) {
            if (this.accessKeyAttribute.isLiteral()) {
                label.setAccessKey(Character.valueOf(this.accessKeyAttribute.getValue(faceletContext).charAt(0)));
            } else {
                expression = this.accessKeyAttribute.getValueExpression(faceletContext, String.class);
                label.setValueExpression("accessKey", expression);
            }
        }
        if (this.markupAttribute != null) {
            if (this.markupAttribute.isLiteral()) {
                label.setMarkup(Markup.valueOf(this.markupAttribute.getValue()));
            } else {
                expression = this.markupAttribute.getValueExpression(faceletContext, Object.class);
                label.setValueExpression("markup", expression);
            }
        }
        panel.getChildren().add(label);
    }

    private boolean checkForAlreadyCreated(UIComponent panel, String uid) {
        if (panel.getChildCount() > 0) {
            for (UIComponent child : panel.getChildren()) {
                if (!uid.equals(child.getId())) continue;
                return true;
            }
        }
        return false;
    }

    public void onComponentPopulated(FaceletContext faceletContext, UIComponent component, UIComponent parent) {
        super.onComponentPopulated(faceletContext, component, parent);
        if (component.getChildren().size() > 1) {
            UIComponent input = (UIComponent)component.getChildren().get(1);
            if (input instanceof EditableValueHolder) {
                TobagoComponentHandler.addDefaultValidators(faceletContext.getFacesContext(), (EditableValueHolder)input);
            }
            if (input instanceof OnComponentPopulated) {
                ((OnComponentPopulated)input).onComponentPopulated(faceletContext.getFacesContext(), component);
            }
        }
    }

    private void addGridLayout(FaceletContext faceletContext, UIComponent panel, Application application) {
        UIGridLayout gridLayout = (UIGridLayout)application.createComponent("org.apache.myfaces.tobago.GridLayout");
        gridLayout.setRendererType("GridLayout");
        if (this.labelWidthAttribute != null) {
            String columns = this.getColumns(this.labelWidthAttribute.getValue(faceletContext));
            if (!LayoutUtils.checkTokens(columns)) {
                LOG.warn("Illegal value for columns = \"" + columns + "\" replacing with default: \"" + DEFAULT_COLUMNS + "\"");
                columns = DEFAULT_COLUMNS;
            }
            gridLayout.setColumns(columns);
        } else {
            gridLayout.setColumns(this.getColumns("auto"));
        }
        gridLayout.setRows(this.getRows());
        gridLayout.setId(panel.getId() + "_tx_layout");
        if (gridLayout instanceof OnComponentCreated) {
            ((OnComponentCreated)((Object)gridLayout)).onComponentCreated(faceletContext.getFacesContext(), panel);
        }
        panel.getFacets().put("layout", gridLayout);
        if (gridLayout instanceof OnComponentPopulated) {
            ((OnComponentPopulated)((Object)gridLayout)).onComponentPopulated(faceletContext.getFacesContext(), panel);
        }
    }

    private void setSubComponentAttributes(FaceletContext ctx, Object instance) {
        if (instance != null) {
            Class<?> type = instance.getClass();
            if (this.subComponentMapper == null || !this.subComponentLastType.equals(type)) {
                this.subComponentLastType = type;
                this.subComponentMapper = this.createSubComponentMetaRuleset(type).finish();
            }
            this.subComponentMapper.applyMetadata(ctx, instance);
        }
    }

    protected MetaRuleset createSubComponentMetaRuleset(Class aClass) {
        MetaRuleset metaRuleset = super.createMetaRuleset(aClass);
        metaRuleset.ignore("tip");
        metaRuleset.ignore("labelWidth");
        if (SupportsMarkup.class.isAssignableFrom(aClass)) {
            metaRuleset.addRule((MetaRule)SupportsMarkupRule.INSTANCE);
        }
        if (InputSuggest.class.isAssignableFrom(aClass)) {
            metaRuleset.addRule((MetaRule)SuggestMethodRule.INSTANCE);
        }
        if (AbstractUISelectManyBox.class.isAssignableFrom(aClass)) {
            metaRuleset.addRule((MetaRule)SelectManyBoxRule.INSTANCE);
        }
        return metaRuleset;
    }

    protected MetaRuleset createMetaRuleset(Class aClass) {
        MetaRuleset metaRuleset = super.createMetaRuleset(aClass);
        TagAttribute[] attrs = this.tag.getAttributes().getAll();
        for (int i = 0; i < attrs.length; ++i) {
            TagAttribute attr = attrs[i];
            if (attr.getLocalName().equals("rendered")) continue;
            metaRuleset.ignore(attr.getLocalName());
        }
        return metaRuleset;
    }
}

