#!/bin/sh

if [ -z "${TCK_TEST_FILE}"]
then
  if [ -z "${TCK_CONFIG_HOME}" ]
  then
    echo "Test definition file not found.  Either set TCK_TEST_FILE to point to a test definition file or set TCK_CONFIG_HOME to point to a directory with a test definition file called test.xml in it."
    exit 1
  fi
  if [ ! -f "${TCK_CONFIG_HOME}"/test.xml ]
  then
    echo "Test definition file not found."
    exit 1
  fi
  TCK_TEST_FILE="${TCK_CONFIG_HOME}"/test.xml
fi
if [ -z "${TCK_LOGIN_FILE}" ]
then
  # Look for login.properties in TCK HOME dir
  if [ -n "${TCK_CONFIG_HOME}" ]
  then
    if [ -f "${TCK_CONFIG_HOME}/login.properties" ] 
    then
      TCK_LOGIN_FILE="${TCK_CONFIG_HOME}"/login.properties
    fi
  fi
fi

if [ -z "${TCK_CLIENT_HOST}" ]
then
  echo TCK_CLIENT_HOST environment variable must be set
  exit 1
fi

if [ -z "${TCK_CLIENT_PORT}" ]
then
  echo TCK_CLIENT_PORT environment variable must be set
  exit 1
fi

echo TCK properties
echo --------------
echo "Test definition file location: '${TCK_TEST_FILE}'"
if [ -z "${TCK_LOGIN_FILE}" ]
then
  echo "Login properties file not set"
else
  echo "Login properties file: '${TCK_LOGIN_FILE}'"
fi
echo "Client host: '${TCK_CLIENT_HOST}'"
echo "Client port: '${TCK_CLIENT_PORT}'"

mvn clean surefire-report:report -Dtck.external-server=run-test -Dbridge.tck.test.file=${TCK_TEST_FILE} -Dbridge.tck.test.host=${TCK_CLIENT_HOST} -Dbridge.tck.test.port=${TCK_CLIENT_PORT} -Dbridge.tck.login-file=${TCK_LOGIN_FILE}
  

