/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.MessageRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputLabelRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PanelFormLayoutRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableRenderingContext;

public abstract class LabelAndMessageRenderer
extends XhtmlRenderer {
    public static final String INLINE_MESSAGE_DEFAULT_GAP = "12";
    public static final String INLINE_MESSAGE_PDA_GAP = "2";
    private static final Object _LABEL_CELL_WIDTH_KEY = "_imLCWidth";
    private static final Object _FIELD_CELL_WIDTH_KEY = "_imFCWidth";
    private static final String _LABEL_PSEUDO_ELEMENT = "::label";
    private PropertyKey _labelKey;
    private PropertyKey _requiredKey;
    private PropertyKey _showRequiredKey;
    private XhtmlRenderer _message;
    private XhtmlRenderer _label;
    private XhtmlRenderer _labelInTable;

    public LabelAndMessageRenderer(FacesBean.Type type) {
        super(type);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._labelKey = type.findKey("label");
        this._requiredKey = type.findKey("required");
        this._showRequiredKey = type.findKey("showRequired");
        this._message = new Message(type);
        this._label = new Label(type, false);
        this._labelInTable = new Label(type, true);
    }

    private boolean _needsTableTag(UIComponent component) {
        String rendererType;
        UIComponent parent = XhtmlUtils.getStructuralParent(component);
        if (parent == null) {
            return true;
        }
        String family = parent.getFamily();
        return !("org.apache.myfaces.trinidad.Panel".equals(family) ? this._isFormRendererType(rendererType = parent.getRendererType()) : "org.apache.myfaces.trinidad.TableLayout".equals(family));
    }

    private boolean _isParentPanelForm(UIComponent component) {
        String rendererType;
        UIComponent parentComponent = component.getParent();
        String family = parentComponent.getFamily();
        while ("org.apache.myfaces.trinidad.Group".equals(family)) {
            if ((parentComponent = parentComponent.getParent()) == null) {
                return false;
            }
            family = parentComponent.getFamily();
        }
        return "org.apache.myfaces.trinidad.Panel".equals(family) && this._isFormRendererType(rendererType = parentComponent.getRendererType());
    }

    protected void renderRootDomElementStyles(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
    }

    protected boolean shouldRenderId(FacesContext context, UIComponent component) {
        return true;
    }

    private boolean _isInTable() {
        TableRenderingContext tContext = TableRenderingContext.getCurrentInstance();
        if (tContext != null) {
            return TableRenderingContext.isInsideContentOfTable();
        }
        return false;
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        RequestContext rc;
        boolean isInline;
        String clientId = component.getClientId(context);
        if (this.isLeafRenderer() && this.canSkipRendering(arc, clientId)) {
            UIComponent help = LabelAndMessageRenderer.getFacet((UIComponent)component, (String)"help");
            if (help != null) {
                this.encodeChild(context, help);
            }
            return;
        }
        String saved = arc.getCurrentClientId();
        arc.setCurrentClientId(clientId);
        boolean isInTable = this._isInTable();
        if (this.hasOwnLabel(bean) || isInTable) {
            String value = this.getLabel(bean);
            FormData fd = arc.getFormData();
            if (fd != null) {
                fd.addLabel(clientId, value);
            }
        }
        boolean bl = isInline = (rc = RequestContext.getCurrentInstance()).getClientValidation() == RequestContext.ClientValidation.INLINE;
        if (isInTable) {
            ResponseWriter rw = context.getResponseWriter();
            this.delegateRenderer(context, arc, component, bean, this._labelInTable);
            this.renderFieldCellContents(context, arc, component, bean);
            if (isInline || this.hasMessage(context, arc, component, bean)) {
                rw.startElement("div", null);
                rw.endElement("div");
                this._renderMessageCellContents(context, arc, component, bean);
            }
        } else {
            ResponseWriter rw = context.getResponseWriter();
            boolean needsPanelFormLayout = this._isParentPanelForm(component);
            boolean needsTableTag = false;
            if (!needsPanelFormLayout) {
                needsTableTag = this._needsTableTag(component);
                if (needsTableTag) {
                    rw.startElement("table", component);
                    rw.writeAttribute("title", (Object)this.getShortDesc(bean), "title");
                    if (!LabelAndMessageRenderer.isDesktop((RenderingContext)arc)) {
                        rw.writeAttribute("width", (Object)"100%", null);
                    }
                    this.renderId(context, component);
                    this.renderRootDomElementStyles(context, arc, component, bean);
                    OutputUtils.renderLayoutTableAttributes(context, arc, "0", null);
                }
                rw.startElement("tr", component);
                if (!needsTableTag) {
                    this.renderId(context, component);
                }
            } else {
                this.renderRootDomElementStyles(context, arc, component, bean);
            }
            boolean labelExists = this.getLabel(bean) != null;
            this._renderLabelCell(context, arc, component, bean, labelExists);
            if (needsPanelFormLayout && PanelFormLayoutRenderer.encodeBetweenLabelAndFieldCells(context, arc, rw)) {
                this.renderRootDomElementStyles(context, arc, component, bean);
            }
            Map requestMap = context.getExternalContext().getRequestMap();
            Integer hspaceObject = (Integer)requestMap.get("org.apache.myfaces.trinidadinternal.TableFormHspace");
            Boolean percentWidthObject = (Boolean)requestMap.get("org.apache.myfaces.trinidadinternal.TableFormPercentWidth");
            if (hspaceObject != null) {
                rw.startElement("td", null);
                if (percentWidthObject != null && percentWidthObject.booleanValue()) {
                    rw.writeAttribute("width", (Object)(hspaceObject + "%"), null);
                } else {
                    rw.writeAttribute("width", (Object)hspaceObject, null);
                }
                rw.endElement("td");
            }
            this._renderFieldCell(context, arc, component, bean, labelExists, needsPanelFormLayout, isInline);
            if (!needsPanelFormLayout) {
                rw.endElement("tr");
                if (isInline || this.hasMessage(context, arc, component, bean)) {
                    rw.startElement("tr", component);
                    rw.startElement("td", null);
                    rw.endElement("td");
                    rw.startElement("td", null);
                    LabelAndMessageRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"AFComponentMessageCell");
                    this._renderMessageCellContents(context, arc, component, bean);
                    rw.endElement("td");
                    rw.endElement("tr");
                }
                if (needsTableTag) {
                    rw.endElement("table");
                }
            }
        }
        arc.setCurrentClientId(saved);
    }

    protected String getRootStyleClass(FacesBean bean) {
        return null;
    }

    private void _renderLabelCell(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, boolean labelExists) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("td", null);
        LabelAndMessageRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)arc, (String[])new String[]{this.getLabelStyleClass(bean), this._getDefaultLabelStyleClass(arc, "AFLabelText")});
        String labelInlineStyle = this.getLabelInlineStyleKey(bean);
        rw.writeAttribute("style", (Object)labelInlineStyle, null);
        String valign = this.getDefaultLabelValign(bean);
        rw.writeAttribute("valign", (Object)valign, null);
        if (LabelAndMessageRenderer.isDesktop((RenderingContext)arc)) {
            rw.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
        }
        if (labelExists) {
            rw.writeAttribute("width", arc.getProperties().get(_LABEL_CELL_WIDTH_KEY), null);
        }
        this.delegateRenderer(context, arc, component, bean, this._label);
        rw.endElement("td");
    }

    private void _renderFieldCell(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, boolean labelExists, boolean needsPanelFormLayout, boolean isInline) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("td", null);
        rw.writeAttribute("valign", (Object)"top", null);
        if (LabelAndMessageRenderer.isDesktop((RenderingContext)arc)) {
            rw.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
        }
        LabelAndMessageRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"AFContentCell");
        if (labelExists) {
            rw.writeAttribute("width", arc.getProperties().get(_FIELD_CELL_WIDTH_KEY), null);
        }
        this.renderFieldCellContents(context, arc, component, bean);
        if (needsPanelFormLayout && (isInline || this.hasMessage(context, arc, component, bean))) {
            rw.startElement("div", null);
            LabelAndMessageRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"AFComponentMessageCell");
            this._renderMessageCellContents(context, arc, component, bean);
            rw.endElement("div");
        }
        if (LabelAndMessageRenderer.isPDA((RenderingContext)arc) && LabelAndMessageRenderer.isIE((RenderingContext)arc)) {
            rw.startElement("div", null);
            this.renderSpacer(context, arc, "1", "0");
            rw.endElement("div");
        }
        rw.endElement("td");
    }

    static String __getCachedClientId(RenderingContext arc) {
        String clientId = arc.getCurrentClientId();
        assert (clientId != null);
        return clientId;
    }

    protected boolean hasMessage(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) {
        UIComponent help = LabelAndMessageRenderer.getFacet((UIComponent)component, (String)"help");
        if (help != null) {
            return true;
        }
        String id = this.getLabelFor(context, arc, component, bean);
        return context.getMessages(id).hasNext();
    }

    private void _renderMessageCellContents(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        this.delegateRenderer(context, arc, component, bean, this._message);
    }

    protected String getClientId(FacesContext context, UIComponent component) {
        return super.getClientId(context, component) + "__xc_";
    }

    protected boolean isLeafRenderer() {
        return true;
    }

    protected String getDefaultLabelValign(FacesBean bean) {
        return null;
    }

    protected abstract void renderFieldCellContents(FacesContext var1, RenderingContext var2, UIComponent var3, FacesBean var4) throws IOException;

    protected boolean isContentEditable(FacesBean bean) {
        return true;
    }

    protected boolean isIndented() {
        return false;
    }

    protected boolean hasOwnLabel(FacesBean bean) {
        return false;
    }

    protected boolean showAccessKeyOnLabel(FacesBean bean) {
        return !this.hasOwnLabel(bean);
    }

    protected abstract String getLabelFor(FacesContext var1, RenderingContext var2, UIComponent var3, FacesBean var4);

    static void __setLabelWidth(RenderingContext arc, Object width) {
        arc.getProperties().put(_LABEL_CELL_WIDTH_KEY, width);
    }

    static void __setFieldWidth(RenderingContext arc, Object width) {
        arc.getProperties().put(_FIELD_CELL_WIDTH_KEY, width);
    }

    static void __clearProperties(RenderingContext arc) {
        arc.getProperties().remove(_LABEL_CELL_WIDTH_KEY);
        arc.getProperties().remove(_FIELD_CELL_WIDTH_KEY);
    }

    protected String getLabelInlineStyleKey(FacesBean bean) {
        return null;
    }

    protected boolean labelShowRequired(FacesBean bean) {
        if (this.getRequired(bean) || this.getShowRequired(bean)) {
            return this.isContentEditable(bean);
        }
        return false;
    }

    protected boolean getShowRequired(FacesBean bean) {
        if (this._showRequiredKey == null) {
            return false;
        }
        Object o = bean.getProperty(this._showRequiredKey);
        if (o == null) {
            o = this._showRequiredKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected boolean getRequired(FacesBean bean) {
        Object o = bean.getProperty(this._requiredKey);
        if (o == null) {
            o = this._requiredKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected String getLabel(FacesBean bean) {
        return LabelAndMessageRenderer.toString((Object)bean.getProperty(this._labelKey));
    }

    protected String getLabelStyleClass(FacesBean bean) {
        String styleClass = this.getRootStyleClass(bean);
        if (styleClass != null) {
            styleClass = styleClass + _LABEL_PSEUDO_ELEMENT;
        }
        return styleClass;
    }

    private String _getDefaultLabelStyleClass(RenderingContext arc, String styleClass) {
        Map keyMap = arc.getSkinResourceKeyMap();
        return keyMap != null ? (String)keyMap.get(styleClass) : null;
    }

    private boolean _isFormRendererType(String rendererType) {
        return "org.apache.myfaces.trinidad.Form".equals(rendererType) || "org.apache.myfaces.trinidad.FormLayout".equals(rendererType) || "org.apache.myfaces.trinidad.rich.Form".equals(rendererType) || "org.apache.myfaces.trinidad.TableLayout".equals(rendererType);
    }

    private class Message
    extends MessageRenderer {
        public Message(FacesBean.Type type) {
            super(type);
        }

        protected boolean shouldRenderId(FacesContext context, UIComponent component) {
            return false;
        }

        protected String getShortDesc(FacesBean bean) {
            return null;
        }

        protected boolean getIndented(FacesBean bean) {
            return LabelAndMessageRenderer.this.isIndented();
        }

        protected void renderAllAttributes(FacesContext context, RenderingContext arc, FacesBean bean) throws IOException {
        }

        protected String getForId(FacesContext context, UIComponent component, FacesBean bean) {
            return LabelAndMessageRenderer.this.getLabelFor(context, RenderingContext.getCurrentInstance(), component, bean);
        }
    }

    private class Label
    extends OutputLabelRenderer {
        private final boolean _inTable;

        public Label(FacesBean.Type type, boolean inTable) {
            super(type);
            this._inTable = inTable;
        }

        protected boolean shouldRenderId(FacesContext context, UIComponent component) {
            return false;
        }

        protected boolean needComponentInStartElement() {
            return false;
        }

        protected void renderAllAttributes(FacesContext context, RenderingContext arc, FacesBean bean) throws IOException {
        }

        protected String getDefaultValign(FacesBean bean) {
            return LabelAndMessageRenderer.this.getDefaultLabelValign(bean);
        }

        protected String getConvertedString(FacesContext context, UIComponent component, FacesBean bean) {
            if (this._inTable) {
                return null;
            }
            return LabelAndMessageRenderer.this.getLabel(bean);
        }

        protected boolean getShowRequired(FacesBean bean) {
            if (this._inTable) {
                return false;
            }
            return LabelAndMessageRenderer.this.labelShowRequired(bean);
        }

        protected char getAccessKey(FacesBean bean) {
            if (LabelAndMessageRenderer.this.showAccessKeyOnLabel(bean)) {
                return super.getAccessKey(bean);
            }
            return '\uffff';
        }

        protected String getShortDesc(FacesBean bean) {
            String shortDesc = super.getShortDesc(bean);
            if (shortDesc == null && this._inTable) {
                shortDesc = LabelAndMessageRenderer.this.getLabel(bean);
            }
            return shortDesc;
        }

        protected String getForId(FacesContext context, UIComponent component, FacesBean bean) {
            return LabelAndMessageRenderer.this.getLabelFor(context, RenderingContext.getCurrentInstance(), component, bean);
        }

        protected boolean isLabelTagNeeded(RenderingContext arc, FacesBean bean, String forId, int accessKeyIndex) {
            if (LabelAndMessageRenderer.this.hasOwnLabel(bean)) {
                return false;
            }
            return super.isLabelTagNeeded(arc, bean, forId, accessKeyIndex);
        }
    }
}

