/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.input.CoreSelectOneChoice;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SimpleSelectOneRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlConstants;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSelectOneChoiceRenderer
extends SimpleSelectOneRenderer {
    private PropertyKey _unselectedLabelKey;
    private static final String _SYNC_FUNC = "_syncChoiceIndex(this)";
    private static final String _IE_ACTION_HANDLER_PREFIX = "if(!_pprChoiceAction(event))return true;";
    private static final String _CHOICE_CHANGE_TRACKER = "return _pprChoiceChangeEvent(event);";

    public SimpleSelectOneChoiceRenderer() {
        this(CoreSelectOneChoice.TYPE);
    }

    public SimpleSelectOneChoiceRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._unselectedLabelKey = type.findKey("unselectedLabel");
    }

    @Override
    protected void encodeElementContent(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, List<SelectItem> selectItems, int selectedIndex, Converter converter, boolean valuePassThru) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("select", component);
        this.renderId(context, component);
        this.renderAllAttributes(context, arc, bean, false);
        this.encodeSelectItems(context, arc, component, bean, selectItems, selectedIndex, converter, valuePassThru);
        writer.endElement("select");
    }

    protected void encodeSelectItems(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, List<SelectItem> selectItems, int selectedIndex, Converter converter, boolean valuePassThru) throws IOException {
        int size = selectItems == null ? 0 : selectItems.size();
        String unselectedLabel = this.getUnselectedLabel(bean);
        boolean needsUnselectedLabel = false;
        if (size > 0 && selectedIndex < 0) {
            needsUnselectedLabel = true;
        } else if (unselectedLabel != null) {
            needsUnselectedLabel = true;
        }
        if (needsUnselectedLabel) {
            if (unselectedLabel == null) {
                unselectedLabel = "";
            }
            SelectItem item = new SelectItem((Object)"", unselectedLabel, "", false);
            SimpleSelectOneChoiceRenderer.encodeOption(context, arc, component, item, null, true, -1, false);
        }
        for (int i = 0; i < size; ++i) {
            SelectItem item = selectItems.get(i);
            SimpleSelectOneChoiceRenderer.encodeOption(context, arc, component, item, converter, valuePassThru, i, selectedIndex == i);
        }
    }

    @Override
    protected String getOnclick(FacesBean bean) {
        RenderingContext arc = RenderingContext.getCurrentInstance();
        String onclick = super.getOnclick(bean);
        if (SimpleSelectOneChoiceRenderer.isIE((RenderingContext)arc) && SimpleSelectOneChoiceRenderer.isDesktop((RenderingContext)arc) && this.isAutoSubmit(bean)) {
            String auto = this.getAutoSubmitScript(arc, bean);
            auto = _IE_ACTION_HANDLER_PREFIX + auto;
            onclick = XhtmlUtils.getChainedJS(onclick, auto, true);
        }
        return onclick;
    }

    @Override
    protected String getOnblur(FacesBean bean) {
        RenderingContext arc = RenderingContext.getCurrentInstance();
        String onblur = super.getOnblur(bean);
        if (SimpleSelectOneChoiceRenderer.isIE((RenderingContext)arc) && SimpleSelectOneChoiceRenderer.isDesktop((RenderingContext)arc) && this.isAutoSubmit(bean)) {
            String auto = this.getAutoSubmitScript(arc, bean);
            auto = _IE_ACTION_HANDLER_PREFIX + auto;
            onblur = XhtmlUtils.getChainedJS(onblur, auto, true);
        }
        return onblur;
    }

    @Override
    protected String getOnchange(FacesBean bean) {
        RenderingContext arc = RenderingContext.getCurrentInstance();
        String onchange = super.getOnchange(bean);
        String auto = null;
        if (this.isAutoSubmit(bean)) {
            auto = SimpleSelectOneChoiceRenderer.isIE((RenderingContext)arc) && SimpleSelectOneChoiceRenderer.isDesktop((RenderingContext)arc) ? _CHOICE_CHANGE_TRACKER : this.getAutoSubmitScript(arc, bean);
        }
        if (SimpleSelectOneChoiceRenderer._isRepeatingRegion(arc)) {
            auto = auto == null ? _SYNC_FUNC : "_syncChoiceIndex(this);" + auto;
        }
        return XhtmlUtils.getChainedJS(onchange, auto, true);
    }

    @Override
    protected String getUnselectedLabel(FacesBean bean) {
        return SimpleSelectOneChoiceRenderer.toString((Object)bean.getProperty(this._unselectedLabelKey));
    }

    @Override
    protected String getContentStyleClass(FacesBean bean) {
        return "af|selectOneChoice::content";
    }

    @Override
    protected String getRootStyleClass(FacesBean bean) {
        return "af|selectOneChoice";
    }

    private static boolean _isRepeatingRegion(RenderingContext arc) {
        return arc.getProperties().get(XhtmlConstants.REPEAT_PROPERTY) != null;
    }
}

