/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.el.ValueExpression;
import javax.faces.context.ExternalContext;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.context.AccessibilityProfile;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidad.webapp.ChainedUploadedFileProcessor;
import org.apache.myfaces.trinidad.webapp.UploadedFileProcessor;
import org.apache.myfaces.trinidadinternal.config.LazyValueExpression;
import org.apache.myfaces.trinidadinternal.config.upload.CompositeUploadedFileProcessorImpl;
import org.apache.myfaces.trinidadinternal.context.RequestContextBean;
import org.apache.myfaces.trinidadinternal.util.DateUtils;
import org.apache.myfaces.trinidadinternal.util.nls.LocaleUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigParser {
    private static final SAXParserFactory _SAX_PARSER_FACTORY = SAXParserFactory.newInstance();
    private static final String _CONFIG_FILE = "/WEB-INF/trinidad-config.xml";
    private static final TrinidadLogger _LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestContextBean parseConfigFile(ExternalContext externalContext) {
        Object debug;
        RequestContextBean bean;
        block32: {
            String classNameString;
            bean = new RequestContextBean();
            InputStream in = externalContext.getResourceAsStream(_CONFIG_FILE);
            if (in != null) {
                try {
                    InputSource input = new InputSource();
                    input.setByteStream(in);
                    input.setPublicId(_CONFIG_FILE);
                    XMLReader reader = _SAX_PARSER_FACTORY.newSAXParser().getXMLReader();
                    reader.setContentHandler(new Handler(bean, externalContext));
                    reader.parse(input);
                }
                catch (IOException ioe) {
                    _LOG.warning((Throwable)ioe);
                }
                catch (ParserConfigurationException pce) {
                    _LOG.warning((Throwable)pce);
                }
                catch (SAXException saxe) {
                    _LOG.warning((Throwable)saxe);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {}
                }
            }
            if ((classNameString = (String)bean.getProperty(RequestContextBean.UPLOADED_FILE_PROCESSOR_KEY)) != null) {
                String[] classNames = (classNameString = classNameString.trim()).split("[ ]+");
                if (classNames.length == 1) {
                    try {
                        Class clazz = ClassLoaderUtils.loadClass((String)classNames[0]);
                        if (ChainedUploadedFileProcessor.class.isAssignableFrom(clazz)) {
                            ChainedUploadedFileProcessor[] cufp = new ChainedUploadedFileProcessor[]{(ChainedUploadedFileProcessor)clazz.newInstance()};
                            bean.setProperty(RequestContextBean.UPLOADED_FILE_PROCESSOR_KEY, new CompositeUploadedFileProcessorImpl(Arrays.asList(cufp)));
                            break block32;
                        }
                        bean.setProperty(RequestContextBean.UPLOADED_FILE_PROCESSOR_KEY, clazz.newInstance());
                    }
                    catch (Exception e) {
                        _LOG.severe("CANNOT_INSTANTIATE_UPLOADEDFILEPROCESSOR", (Throwable)e);
                        bean.setProperty(RequestContextBean.UPLOADED_FILE_PROCESSOR_KEY, new CompositeUploadedFileProcessorImpl());
                    }
                } else {
                    try {
                        ArrayList processors = new ArrayList(classNames.length);
                        for (String className : classNames) {
                            Class clazz = ClassLoaderUtils.loadClass((String)className);
                            processors.add(clazz.newInstance());
                        }
                        bean.setProperty(RequestContextBean.UPLOADED_FILE_PROCESSOR_KEY, new CompositeUploadedFileProcessorImpl(processors));
                    }
                    catch (Exception e) {
                        _LOG.severe("CANNOT_INSTANTIATE_UPLOADEDFILEPROCESSOR", (Throwable)e);
                        bean.setProperty(RequestContextBean.UPLOADED_FILE_PROCESSOR_KEY, new CompositeUploadedFileProcessorImpl());
                    }
                }
            } else {
                bean.setProperty(RequestContextBean.UPLOADED_FILE_PROCESSOR_KEY, new CompositeUploadedFileProcessorImpl());
            }
        }
        UploadedFileProcessor ufp = (UploadedFileProcessor)bean.getProperty(RequestContextBean.UPLOADED_FILE_PROCESSOR_KEY);
        ufp.init(externalContext.getContext());
        if (_LOG.isInfo() && Boolean.TRUE.equals(debug = bean.getProperty(RequestContextBean.DEBUG_OUTPUT_KEY))) {
            _LOG.info("RUNNING_IN_DEBUG_MODE", (Object)_CONFIG_FILE);
        }
        return bean;
    }

    static {
        _SAX_PARSER_FACTORY.setNamespaceAware(true);
        _LOG = TrinidadLogger.createTrinidadLogger(ConfigParser.class);
    }

    private static class Handler
    extends DefaultHandler {
        private RequestContextBean _bean;
        private String _currentText;
        private Map<String, Object> _applicationMap;

        public Handler(RequestContextBean bean, ExternalContext context) {
            this._applicationMap = context.getApplicationMap();
            this._bean = bean;
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this._currentText = "";
        }

        public void characters(char[] ch, int start, int length) {
            if (this._currentText != null) {
                this._currentText = this._currentText + new String(ch, start, length);
            }
        }

        public void endElement(String uri, String localName, String qName) {
            String currentText = this._currentText;
            if (currentText == null) {
                return;
            }
            if (!"".equals(currentText = currentText.trim())) {
                PropertyKey key = this._bean.getType().findKey(localName);
                if (key == null) {
                    if (_LOG.isWarning()) {
                        _LOG.warning("ELEMENT_NOT_UNDERSTOOD", (Object)qName);
                    }
                } else if (currentText.startsWith("#{") && currentText.endsWith("}")) {
                    if (!key.getSupportsBinding()) {
                        if (_LOG.isWarning()) {
                            _LOG.warning("NOT_SUPPORT_EL_EXPRESSION", (Object)qName);
                        }
                    } else {
                        ValueExpression expression = LazyValueExpression.createValueExpression(this._currentText, key.getType());
                        this._bean.setValueExpression(key, expression);
                    }
                } else {
                    Object value;
                    if (key.getType() == Character.class) {
                        value = Character.valueOf(currentText.charAt(0));
                    } else if (key.getType() == Integer.class) {
                        value = Handler._getIntegerValue(currentText, qName);
                    } else if (key.getType() == Long.class) {
                        value = Handler._getLongValue(currentText, qName);
                    } else if (key.getType() == Boolean.class) {
                        value = "true".equalsIgnoreCase(currentText) ? Boolean.TRUE : Boolean.FALSE;
                    } else if (key.getType() == TimeZone.class) {
                        value = DateUtils.getSupportedTimeZone(currentText);
                        if (value == null) {
                            _LOG.warning("INVALID_TIMEZONE_IN_CONFIG", (Object)currentText);
                        }
                    } else if (key.getType() == Locale.class) {
                        currentText = currentText.replace('_', '-');
                        value = LocaleUtils.getLocaleForIANAString(currentText);
                    } else if (key.getType().isEnum()) {
                        try {
                            value = Enum.valueOf(key.getType(), currentText);
                        }
                        catch (IllegalArgumentException iae) {
                            _LOG.warning("INVALID_ENUM_IN_CONFIG", new Object[]{currentText, qName});
                            return;
                        }
                    } else {
                        value = key.getType() == AccessibilityProfile.class ? Handler._getAccessibilityProfile(currentText) : currentText;
                    }
                    if (key == RequestContextBean.REMOTE_DEVICE_REPOSITORY_URI) {
                        this._applicationMap.put("remote-device-repository-uri", value);
                    } else if (key == RequestContextBean.CLIENT_VALIDATION_DISABLED_KEY) {
                        if (Boolean.TRUE.equals(value)) {
                            this._bean.setProperty(RequestContextBean.CLIENT_VALIDATION_KEY, RequestContext.ClientValidation.DISABLED);
                        }
                    } else {
                        this._bean.setProperty(key, value);
                    }
                }
            }
            this._currentText = null;
        }

        private static Integer _getIntegerValue(String text, String qName) {
            Integer value;
            block2: {
                value = null;
                try {
                    value = Integer.valueOf(text);
                }
                catch (NumberFormatException nfe) {
                    if (!_LOG.isWarning()) break block2;
                    _LOG.warning("ELEMENT_ONLY_ACCEPT_INTEGER", (Object)qName);
                }
            }
            return value;
        }

        private static Long _getLongValue(String text, String qName) {
            Long value;
            block2: {
                value = null;
                try {
                    value = Long.valueOf(text);
                }
                catch (NumberFormatException nfe) {
                    if (!_LOG.isWarning()) break block2;
                    _LOG.warning("ELEMENT_ONLY_ACCEPT_INTEGER", (Object)qName);
                }
            }
            return value;
        }

        private static AccessibilityProfile _getAccessibilityProfile(String text) {
            AccessibilityProfile.ColorContrast colorContrast = null;
            AccessibilityProfile.FontSize fontSize = null;
            StringTokenizer tokens = new StringTokenizer(text);
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if ("high-contrast".equals(token)) {
                    colorContrast = AccessibilityProfile.ColorContrast.HIGH;
                    continue;
                }
                if ("large-fonts".equals(token)) {
                    fontSize = AccessibilityProfile.FontSize.LARGE;
                    continue;
                }
                _LOG.warning("INVALID_ACC_PROFILE", new Object[]{token});
            }
            return AccessibilityProfile.getInstance(colorContrast, fontSize);
        }
    }
}

