/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.data.bind;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.data.BoundValue;
import org.apache.myfaces.trinidadinternal.ui.data.bind.FixedBoundValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class ComparisonBoundValue
implements BoundValue {
    public static final int COMPARISON_EQUALS = 1;
    public static final int COMPARISON_NOT_EQUALS = -2;
    public static final int COMPARISON_GREATER_THAN = 2;
    public static final int COMPARISON_GREATER_THAN_OR_EQUALS = 3;
    public static final int COMPARISON_LESS_THAN = -4;
    public static final int COMPARISON_LESS_THAN_OR_EQUALS = -3;
    private BoundValue _leftSideValue;
    private BoundValue _rightSideValue;
    private int _comparison;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ComparisonBoundValue.class);

    public ComparisonBoundValue(int comparison, BoundValue leftSideValue, BoundValue rightSideValue) {
        if (leftSideValue == null) {
            throw new IllegalArgumentException(_LOG.getMessage("NULL_LEFTSIDEVALUE"));
        }
        if (rightSideValue == null) {
            throw new IllegalArgumentException(_LOG.getMessage("NULL_RIGHTSIDEVALUE"));
        }
        if (comparison < -4 || comparison > 3) {
            throw new IllegalArgumentException(_LOG.getMessage("UNKNOWN_COMPARISON"));
        }
        this._comparison = comparison;
        this._leftSideValue = leftSideValue;
        this._rightSideValue = rightSideValue;
    }

    public ComparisonBoundValue(int comparison, BoundValue leftSideValue, Object rightSide) {
        this(comparison, leftSideValue, new FixedBoundValue(rightSide));
    }

    public static ComparisonBoundValue createExistsValue(BoundValue existenceValue) {
        return new ComparisonBoundValue(-2, existenceValue, FixedBoundValue.NULL_VALUE);
    }

    @Override
    public Object getValue(UIXRenderingContext context) {
        boolean areBothNumbers;
        Object leftSide = this._leftSideValue.getValue(context);
        Object rightSide = this._rightSideValue.getValue(context);
        boolean isNot = false;
        int comparison = this._comparison;
        if ((comparison & 1) == 0) {
            comparison ^= 0xFFFFFFFF;
            isNot = true;
        }
        boolean bl = areBothNumbers = leftSide instanceof Number && rightSide instanceof Number;
        boolean newResult = leftSide == rightSide ? true : (leftSide != null ? (areBothNumbers ? ComparisonBoundValue._equalsForNumbers((Number)leftSide, (Number)rightSide) : leftSide.equals(rightSide)) : false);
        if (!newResult && comparison != 1) {
            if (leftSide == null || rightSide == null) {
                return Boolean.FALSE;
            }
            if (!areBothNumbers) {
                if (_LOG.isSevere()) {
                    _LOG.severe((Throwable)new IllegalArgumentException("Numeric comparisons only allowed on numbers"));
                }
                return Boolean.FALSE;
            }
            Number leftNumber = (Number)leftSide;
            Number rightNumber = (Number)rightSide;
            if (comparison == -3) {
                boolean bl2 = isNot = !isNot;
            }
            if (leftNumber instanceof Long) {
                newResult = leftNumber.longValue() > rightNumber.longValue();
            } else {
                boolean bl3 = newResult = leftNumber.doubleValue() > rightNumber.doubleValue();
            }
        }
        if (isNot) {
            newResult = !newResult;
        }
        return newResult ? Boolean.TRUE : Boolean.FALSE;
    }

    private static boolean _equalsForNumbers(Number a, Number b) {
        Class<?> bc;
        if (a == null || b == null) {
            return a == b;
        }
        Class<?> ac = a.getClass();
        if (ac == (bc = b.getClass())) {
            return a.equals(b);
        }
        if (ac == Long.class || ac == Integer.class || ac == Short.class || ac == Byte.class) {
            return ComparisonBoundValue._equalsForLong(a.longValue(), b, bc);
        }
        if (ac == Double.class || ac == Float.class) {
            return ComparisonBoundValue._equalsForDouble(a.doubleValue(), b, bc);
        }
        if (ac == BigInteger.class) {
            return ComparisonBoundValue._equalsForBigInteger((BigInteger)a, b, bc);
        }
        if (ac == BigDecimal.class) {
            return ComparisonBoundValue._equalsForBigDecimal((BigDecimal)a, b, bc);
        }
        return a.equals(b);
    }

    private static boolean _equalsForLong(long a, Number b, Class<?> bc) {
        if (bc == Double.class || bc == Float.class) {
            return b.doubleValue() == (double)a;
        }
        if (bc == BigDecimal.class) {
            return BigDecimal.valueOf(a).equals(b);
        }
        if (bc == BigInteger.class) {
            return BigInteger.valueOf(a).equals(b);
        }
        return a == b.longValue();
    }

    private static boolean _equalsForDouble(double a, Number b, Class<?> bc) {
        if (bc == BigDecimal.class) {
            return new BigDecimal(a).equals(b);
        }
        if (bc == BigInteger.class) {
            return new BigDecimal(a).equals(new BigDecimal((BigInteger)b));
        }
        return a == b.doubleValue();
    }

    private static boolean _equalsForBigInteger(BigInteger a, Number b, Class<?> bc) {
        if (bc == BigDecimal.class) {
            return new BigDecimal(a).equals(b);
        }
        if (bc == Double.class || bc == Float.class) {
            return new BigDecimal(a).equals(new BigDecimal(b.doubleValue()));
        }
        return BigInteger.valueOf(b.longValue()).equals(a);
    }

    private static boolean _equalsForBigDecimal(BigDecimal a, Number b, Class<?> bc) {
        if (bc == BigInteger.class) {
            return a.equals(new BigDecimal((BigInteger)b));
        }
        if (bc == Double.class || bc == Float.class) {
            return a.equals(new BigDecimal(b.doubleValue()));
        }
        return a.equals(BigDecimal.valueOf(b.longValue()));
    }
}

