/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ValueMap<K, V>
extends AbstractMap<K, V>
implements Externalizable {
    private Map<K, V> _cache;
    private transient Map<V, K> _valueMap;

    public ValueMap() {
        this(13);
    }

    public ValueMap(int initialCapacity) {
        this._cache = new HashMap(initialCapacity);
        this._valueMap = new HashMap<V, K>(initialCapacity);
    }

    @Override
    public V get(Object key) {
        return this._cache.get(key);
    }

    public K getKey(V value) {
        return this._valueMap.get(value);
    }

    @Override
    public V put(K key, V value) {
        K oldKey = this._valueMap.put(value, key);
        assert (oldKey == null) : "value:" + value + " is referenced by both key:" + key + " and key:" + oldKey;
        V old = this._cache.put(key, value);
        assert (old == null) : "can't put the same key twice";
        return old;
    }

    @Override
    public void clear() {
        this._cache.clear();
        this._valueMap.clear();
    }

    @Override
    public int size() {
        return this._cache.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this._cache.entrySet());
    }

    private static <K, V> Map<V, K> _invertMap(Map<K, V> cache) {
        HashMap<V, K> valueMap = new HashMap<V, K>(cache.size());
        for (Map.Entry<K, V> entry : cache.entrySet()) {
            K old = valueMap.put(entry.getValue(), entry.getKey());
            assert (old == null) : "the value:" + entry.getValue() + " was bound to both key:" + old + " and key:" + entry.getKey();
        }
        return valueMap;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this._cache.isEmpty()) {
            out.writeObject(null);
        } else {
            out.writeObject(this._cache);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Map cache = (Map)in.readObject();
        if (cache != null) {
            this._cache = cache;
            this._valueMap = ValueMap._invertMap(this._cache);
        }
    }
}

