/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.painter;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.myfaces.trinidadinternal.image.painter.ImageLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageUtils {
    private static final String _NOLOAD_DATA = "GIF89a\u000e\u0000\u0010\u0000\u00b3\u0000\u0000\u0000\u0000\u0000\u0080\u0000\u0000\u0000\u0080\u0000\u0080\u0080\u0000\u0000\u0000\u0080\u0080\u0000\u0080\u0000\u0080\u0080\u00c0\u00c0\u00c0\u0080\u0080\u0080\u00ff\u0000\u0000\u0000\u00ff\u0000\u00ff\u00ff\u0000\u0000\u0000\u00ff\u00ff\u0000\u00ff\u0000\u00ff\u00ff\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\u0000\u0000\u000f\u0000,\u0000\u0000\u0000\u0000\u000e\u0000\u0010\u0000\u0000\u0004I\u0010\u00c8I\u00d1\u00bb\u00e0\u00ea\u008d\u00ec\u00cbG(\u0086\u0096\u0005\u0086\u0082 z\u00c8)(\u0002\u0010Rn*\u008b\u00dfyH\u00e3\u0091?\u00bd\u0003c\u0098\u0091\u0000\u0013#\u0086\u0083Q\u00045\u0090\u00a1!\u00a1\tl<g\u0093\u00df\u00c1z\u001dii^c0\u009c\u00d9\u00981\u00b4\u00f4$\u0002\u0000;";
    private static Image _sNotLoadedImage;

    public static Image createFilteredImage(Image baseImage, ImageFilter imageFilter) {
        FilteredImageSource producer = new FilteredImageSource(baseImage.getSource(), imageFilter);
        return Toolkit.getDefaultToolkit().createImage(producer);
    }

    public static Image getImageResource(Class<?> cl, String name) {
        Image image = ImageUtils._getImageResource(cl, name);
        if (image == null) {
            image = ImageUtils.getNotLoadedImage();
        }
        return image;
    }

    public static Image getImageFromStream(InputStream in) {
        return ImageUtils._getImageFromStream(in);
    }

    public static Image getNotLoadedImage() {
        if (_sNotLoadedImage == null) {
            _sNotLoadedImage = ImageUtils._createImage(_NOLOAD_DATA);
        }
        return _sNotLoadedImage;
    }

    public static boolean isImageLoaded(Image image) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        int status = tk.checkImage(image, -1, -1, null);
        return (status & 0x30) != 0;
    }

    public static boolean loadImage(Image image) {
        if (!ImageUtils.isImageLoaded(image)) {
            ImageLoader load = new ImageLoader(image);
            load.start();
            return load.waitFor();
        }
        return true;
    }

    public static boolean loadImages(Image[] images) {
        int i;
        boolean value = true;
        ImageLoader[] loaders = new ImageLoader[images.length];
        for (i = 0; i < images.length; ++i) {
            loaders[i] = new ImageLoader(images[i]);
            loaders[i].start();
        }
        for (i = 0; i < images.length; ++i) {
            value = value && loaders[i].waitFor();
        }
        return value;
    }

    private static Image _getImageResource(Class<?> cl, String name) {
        Image outImage = null;
        InputStream inStream = cl.getResourceAsStream(name);
        if (inStream != null && (outImage = ImageUtils._getImageFromStream(inStream)) != null) {
            return outImage;
        }
        URL imageURL = cl.getResource(name);
        if (imageURL != null) {
            try {
                Object urlContent = imageURL.getContent();
                if (urlContent instanceof ImageProducer) {
                    ImageProducer producer = (ImageProducer)urlContent;
                    outImage = Toolkit.getDefaultToolkit().createImage(producer);
                } else if (urlContent instanceof Image) {
                    outImage = (Image)urlContent;
                }
                if (outImage != null) {
                    if (ImageUtils.loadImage(outImage)) {
                        return outImage;
                    }
                    return null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image _getImageFromStream(InputStream inStream) {
        Image outImage = null;
        byte[] imageBuffer = null;
        try {
            int n;
            BufferedInputStream inBuffer = new BufferedInputStream(inStream);
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            imageBuffer = new byte[1024];
            while ((n = inBuffer.read(imageBuffer)) > 0) {
                out.write(imageBuffer, 0, n);
            }
            out.flush();
            imageBuffer = out.toByteArray();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException iOException) {}
        }
        if (imageBuffer != null && !ImageUtils.loadImage(outImage = Toolkit.getDefaultToolkit().createImage(imageBuffer))) {
            outImage = null;
        }
        return outImage;
    }

    private ImageUtils() {
    }

    private static Image _createImage(String string) {
        int length = string.length();
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            data[i] = (byte)string.charAt(i);
        }
        return Toolkit.getDefaultToolkit().createImage(data);
    }
}

