/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.xml.parse;

import org.apache.myfaces.trinidadinternal.image.ImageConstants;
import org.apache.myfaces.trinidadinternal.image.xml.parse.BaseImageProviderRequestParser;
import org.apache.myfaces.trinidadinternal.share.xml.NodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public class CompositeButtonParser
extends BaseImageProviderRequestParser {
    private static final int _PROPERTY_COUNT = 14;

    public CompositeButtonParser() {
        super(14);
    }

    @Override
    public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        String text;
        Character accessKey;
        super.startElement(context, namespaceURI, localName, attrs);
        String lookAndFeelId = attrs.getValue("lookAndFeelId");
        if (lookAndFeelId != null) {
            this.setProperty(ImageConstants.LOOK_AND_FEEL_ID_KEY, lookAndFeelId);
        }
        if ((accessKey = this.getAccessKey(context, attrs)) != null) {
            this.setProperty(ImageConstants.ACCESS_KEY_KEY, accessKey);
        }
        if ((text = this.getText(context, attrs)) != null) {
            if (Boolean.TRUE.equals(context.getProperty("http://myfaces.apache.org/uix/image", BaseImageProviderRequestParser.__STRIP_MNEMONICS_PROPERTY))) {
                int index = CompositeButtonParser.__getMnemonicIndex(text);
                text = CompositeButtonParser.__stripMnemonic(text);
                if (index != -1) {
                    accessKey = Character.valueOf(text.charAt(index));
                    this.setProperty(ImageConstants.ACCESS_KEY_KEY, accessKey);
                }
            }
            this.setProperty(ImageConstants.TEXT_KEY, text);
        }
    }

    @Override
    public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) {
        if ("text".equals(localName) || "translatedText".equals(localName)) {
            return context.getParser(String.class, namespaceURI, localName);
        }
        return super.startChildElement(context, namespaceURI, localName, attrs);
    }

    @Override
    public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) {
        if (child instanceof String) {
            this.setProperty(ImageConstants.TEXT_KEY, child);
        } else {
            super.addCompletedChild(context, namespaceURI, localName, child);
        }
    }

    protected Character getAccessKey(ParseContext context, Attributes attrs) {
        String value = attrs.getValue("accessKey");
        if (value == null || value.length() == 0) {
            return null;
        }
        return Character.valueOf(value.charAt(0));
    }

    protected String getText(ParseContext context, Attributes attrs) {
        return attrs.getValue("text");
    }

    protected String getVersion(ParseContext context, Attributes attrs) {
        return attrs.getValue("version");
    }
}

