/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.UIXColumn;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.ColumnGroupRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.TableRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.BandingData;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.CellUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.ColumnData;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.RenderStage;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.RowData;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableRenderingContext;

public class ColumnRenderer
extends ColumnGroupRenderer {
    private ColumnGroupRenderer _columnGroupRenderer = new ColumnGroupRenderer();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ColumnRenderer.class);

    @Override
    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        TableRenderingContext tContext = TableRenderingContext.getCurrentInstance();
        if (tContext == null) {
            _LOG.warning("COMPONENT_COLUMN_OUTSIDE_TABLE", (Object)component);
            return;
        }
        if (this._isColumnGroup(component)) {
            this._columnGroupRenderer.encodeAll(context, rc, component, bean);
            return;
        }
        RenderStage rs = tContext.getRenderStage();
        int stage = rs.getStage();
        switch (stage) {
            case 0: {
                this._computeMode(rc, tContext, component, bean);
                break;
            }
            case 20: {
                this._renderHeaderMode(context, rc, tContext, component);
                break;
            }
            case 60: {
                this._renderFooterMode(context, rc, tContext, component);
                break;
            }
            case 50: {
                break;
            }
            case 30: {
                this._renderDataMode(context, rc, tContext, component);
                break;
            }
            case 35: {
                this._startRowMode(tContext, component);
                break;
            }
            case 100: {
                break;
            }
            default: {
                assert (false) : "Bad renderStage:" + stage;
                break;
            }
        }
        ColumnData colData = tContext.getColumnData();
        colData.incrementColumnIndex();
    }

    private boolean _isColumnGroup(UIComponent column) {
        Iterator kids = column.getChildren().iterator();
        if (!kids.hasNext()) {
            return false;
        }
        return kids.next() instanceof UIXColumn;
    }

    protected void renderKids(FacesContext context, RenderingContext rc, TableRenderingContext trc, UIComponent column) throws IOException {
        boolean renderedOne = false;
        for (UIComponent child : column.getChildren()) {
            if (!child.isRendered()) continue;
            if (renderedOne) {
                ResponseWriter rw = context.getResponseWriter();
                rw.startElement("div", null);
                rw.endElement("div");
            } else {
                renderedOne = true;
            }
            this.encodeChild(context, child);
        }
    }

    private void _renderKids(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent column, int kid) throws IOException {
        if (kid < 0) {
            this.renderKids(context, rc, tContext, column);
        } else {
            UIComponent child = (UIComponent)column.getChildren().get(kid);
            this.encodeChild(context, child);
        }
    }

    private void _startRowMode(TableRenderingContext tContext, UIComponent column) throws IOException {
        int physicalIndex;
        ColumnData colData = tContext.getColumnData();
        if (colData.useSeparateRows(physicalIndex = colData.getPhysicalColumnIndex())) {
            int kids = ColumnRenderer.getRenderedChildCount((UIComponent)column);
            RowData rowData = tContext.getRowData();
            rowData.setCurrentRowSpan(kids);
        }
    }

    private void _renderDataMode(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent column) throws IOException {
        int totalKids;
        ColumnData colData = tContext.getColumnData();
        RowData rowData = tContext.getRowData();
        int physicalIndex = colData.getPhysicalColumnIndex();
        int subRow = rowData.getCurrentSubRow();
        int currentRowSpan = rowData.getCurrentRowSpan();
        if (colData.useSeparateRows(physicalIndex) && (totalKids = ColumnRenderer.getRenderedChildCount((UIComponent)column)) != 0) {
            if (totalKids > subRow) {
                int span = subRow == totalKids - 1 ? currentRowSpan - subRow : 1;
                this._renderTD(context, rc, tContext, column, subRow, span);
            }
            return;
        }
        if (subRow == 0) {
            this._renderTD(context, rc, tContext, column, -1, currentRowSpan);
        }
    }

    public static void renderHeadersAttr(FacesContext context, TableRenderingContext tContext) throws IOException {
        if (tContext.isExplicitHeaderIDMode()) {
            RowData rowData = tContext.getRowData();
            String rowID = rowData.getCurrentRowHeaderID();
            ColumnData colData = tContext.getColumnData();
            int physicalIndex = colData.getPhysicalColumnIndex();
            String headers = colData.getHeaderIDs(physicalIndex);
            if (rowID != null) {
                headers = rowID + " " + headers;
            }
            context.getResponseWriter().writeAttribute("headers", (Object)headers, null);
        }
    }

    private void _renderTD(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent column, int kidIndex, int rowSpan) throws IOException {
        int row;
        String borderStyleClass;
        String cellClass;
        int physicalIndex;
        ResponseWriter writer = context.getResponseWriter();
        ColumnData colData = tContext.getColumnData();
        boolean isRowHeader = colData.isRowHeader(physicalIndex = colData.getPhysicalColumnIndex());
        if (isRowHeader) {
            writer.startElement("th", column);
            cellClass = TableRenderer.getRowHeaderFormatClass();
            if (tContext.isExplicitHeaderIDMode()) {
                String headerID = column.getClientId(context);
                RowData rowData = tContext.getRowData();
                rowData.setCurrentRowHeaderID(headerID);
                writer.writeAttribute("id", (Object)headerID, null);
            } else {
                writer.writeAttribute("scope", (Object)"row", null);
            }
            borderStyleClass = CellUtils.getHeaderBorderStyle(tContext, rc, false, false);
        } else {
            writer.startElement("td", column);
            cellClass = this.getTableDataStyleClass(tContext);
            ColumnRenderer.renderHeadersAttr(context, tContext);
            borderStyleClass = CellUtils.getDataBorderStyle(rc, tContext);
        }
        FacesBean bean = this.getFacesBean(column);
        String userStyleClass = this.getStyleClass(column, bean);
        String userInlineStyle = this.getInlineStyle(column, bean);
        Object width = tContext.getColumnWidth(physicalIndex);
        if (!tContext.hasColumnHeaders() && width != null && (row = tContext.getRowData().getRangeIndex()) == 0 && kidIndex < 1) {
            writer.writeAttribute("width", width, null);
        }
        ColumnRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)rc, (String[])new String[]{userStyleClass, cellClass, borderStyleClass});
        writer.writeAttribute("style", (Object)userInlineStyle, null);
        if (colData.getNoWrap(physicalIndex) && !this.getShouldWrap()) {
            writer.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
        }
        CellUtils.renderSpan(context, true, rowSpan);
        this._renderKids(context, rc, tContext, column, kidIndex);
        writer.endElement(isRowHeader ? "th" : "td");
    }

    protected Object getColumnWidthFromTable(TableRenderingContext tContext, int index) {
        return tContext.getColumnWidth(index);
    }

    protected String getTableDataStyleClass(TableRenderingContext tContext) {
        return ColumnRenderer.getDataStyleClass(tContext);
    }

    protected boolean isSpecialColumn() {
        return false;
    }

    private void _computeMode(RenderingContext rc, TableRenderingContext tContext, UIComponent component, FacesBean bean) {
        UIComponent footer;
        boolean shouldWrap = this.getShouldWrap();
        UIComponent header = ColumnRenderer.getFacet((UIComponent)component, (String)"header");
        String headerText = this.getHeaderText(component, bean);
        if (!(header == null && headerText == null || this.isSpecialColumn())) {
            tContext.columnHeadersPresent();
        }
        ColumnData colData = tContext.getColumnData();
        if (this.isSpecialColumn()) {
            colData.setSpecialColumnData(tContext, rc, this.getNoWrap(component, bean) && !shouldWrap, shouldWrap, this.getFormatType(component, bean));
        } else {
            colData.setColumnData(this.getWidth(component, bean), this.getFormatType(component, bean), this.getNoWrap(component, bean) && !shouldWrap, this.getHeaderNoWrap(component, bean) && !shouldWrap, this.getSeparateRows(component, bean), this.getRowHeader(component, bean));
        }
        ColumnGroupRenderer.NodeData parentNode = this.getParentNode(tContext);
        if (parentNode != null) {
            ColumnGroupRenderer.NodeData currentNode = new ColumnGroupRenderer.NodeData();
            if (parentNode.rows < 2) {
                parentNode.rows = 2;
            }
            ++parentNode.cols;
            parentNode.set(parentNode.currentChild, currentNode);
        }
        if ((footer = ColumnRenderer.getFacet((UIComponent)component, (String)"footer")) != null) {
            colData.setCurrentColumnHasFooter();
            tContext.setExplicitHeaderIDMode(true);
        }
    }

    private void _renderFooterMode(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent column) throws IOException {
        ColumnData colData = tContext.getColumnData();
        if (colData.getPhysicalColumnIndex() < colData.getPhysicalIndexOfFirstFooter()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        ColumnRenderer.renderHeadersAttr(context, tContext);
        String styleClass = ColumnData.selectFormat(tContext, "af|column::total-text", "af|column::total-number", "af|column::total-text");
        if (tContext.hasGrid(colData.getPhysicalColumnIndex(), true)) {
            String borderStyleClass = CellUtils.getBorderClass(false, true, false, false);
            ColumnRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)rc, (String[])new String[]{styleClass, borderStyleClass});
        } else {
            ColumnRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)styleClass);
        }
        UIComponent footer = ColumnRenderer.getFacet((UIComponent)column, (String)"footer");
        if (footer != null) {
            this.encodeChild(context, footer);
        }
        writer.endElement("td");
    }

    private void _renderHeaderMode(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent column) throws IOException {
        ColumnData colData = tContext.getColumnData();
        int rowSpan = colData.getHeaderRowSpan();
        ColumnGroupRenderer.NodeData parentNode = this.getParentNode(tContext);
        if (parentNode != null) {
            ColumnGroupRenderer.NodeData currentNode = parentNode.get(parentNode.currentChild);
            if (currentNode.waitUntilRow != 0) {
                return;
            }
            rowSpan -= colData.getRowIndex();
            currentNode.waitUntilRow = -1;
        } else if (colData.getRowIndex() > 0) {
            return;
        }
        String colID = this.renderHeaderAndSpan(context, rc, tContext, column, rowSpan, 1);
        if (colID != null) {
            colData.setHeaderID(colData.getPhysicalColumnIndex(), colID);
            if (parentNode != null) {
                colID = parentNode.headerIDs + " " + colID;
            }
            colData.setHeaderIDs(colData.getPhysicalColumnIndex(), colID);
        }
    }

    public static String getDataStyleClass(TableRenderingContext tContext) {
        ColumnData colData = tContext.getColumnData();
        RowData rowData = tContext.getRowData();
        int logicalColumn = colData.getLogicalColumnIndex();
        BandingData banding = tContext.getBanding();
        boolean band = banding.getBand(tContext, rowData.getRangeIndex(), colData.getPhysicalColumnIndex(), logicalColumn);
        String cellClass = band ? ColumnData.selectFormat(tContext, "af|column::cell-text-band", "af|column::cell-number-band", "af|column::cell-icon-format-band") : ColumnData.selectFormat(tContext, "af|column::cell-text", "af|column::cell-number", "af|column::cell-icon-format");
        return cellClass;
    }

    public static String renderDataStyleClass(FacesContext context, RenderingContext rc, TableRenderingContext tContext) throws IOException {
        String cellClass = ColumnRenderer.getDataStyleClass(tContext);
        ColumnRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)cellClass);
        return cellClass;
    }

    protected boolean getShouldWrap() {
        return false;
    }
}

