/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.UIXCollection;
import org.apache.myfaces.trinidad.component.UIXTable;
import org.apache.myfaces.trinidad.component.UIXTree;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.event.SelectionEvent;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.RowKeySet;
import org.apache.myfaces.trinidad.render.CoreRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SimpleSelectBooleanCheckboxRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.RenderStage;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableRenderingContext;

public class TableSelectOneRenderer
extends XhtmlRenderer {
    private CoreRenderer _renderer;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(TableSelectOneRenderer.class);

    public TableSelectOneRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._renderer = this.createCellRenderer(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(FacesContext facesContext, UIComponent component, FacesBean facesBean, String clientId) {
        UIXCollection table = (UIXCollection)component;
        Object oldKey = table.getRowKey();
        try {
            table.setRowKey(null);
            String selectionParam = TableSelectOneRenderer.__getSelectionParameterName(facesContext, (UIComponent)table);
            Map parameters = facesContext.getExternalContext().getRequestParameterMap();
            _LOG.finest("Params:{0}", (Object)parameters);
            String selection = (String)parameters.get(selectionParam);
            if (selection != null) {
                RowKeySet state = table instanceof UIXTable ? ((UIXTable)table).getSelectedRowKeys() : ((UIXTree)table).getSelectedRowKeys();
                table.setClientRowKey(selection);
                if (!state.isContained() || state.size() > 1) {
                    RowKeySet unselected = state.clone();
                    state.clear();
                    state.add();
                    RowKeySet selected = state.clone();
                    SelectionEvent event = new SelectionEvent((UIComponent)table, unselected, selected);
                    event.queue();
                }
            }
        }
        finally {
            table.setRowKey(oldKey);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        TableRenderingContext tContext = TableRenderingContext.getCurrentInstance();
        if (tContext == null) {
            _LOG.severe("TABLESELECT_COMPONENT_MAY_ONLY_INSIDE_TABLE_AND_TREETABLE");
            return;
        }
        RenderStage stage = tContext.getRenderStage();
        switch (stage.getStage()) {
            case 10: 
            case 12: 
            case 15: {
                break;
            }
            case 30: {
                this.renderCellContent(context, rc, tContext, component, bean);
                break;
            }
            default: {
                throw new AssertionError((Object)("bad renderStage:" + stage.getStage()));
            }
        }
    }

    protected boolean isSelectOne() {
        return true;
    }

    protected CoreRenderer createCellRenderer(FacesBean.Type type) {
        return new Radio(type);
    }

    protected void renderCellContent(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent component, FacesBean bean) throws IOException {
        rc.setCurrentClientId(tContext.getTableId());
        this.delegateRenderer(context, rc, component, bean, this._renderer);
        rc.setCurrentClientId(null);
    }

    static String __getSelectionParameterName(FacesContext context, UIComponent table) {
        return table.getClientId(context) + ':' + "selected";
    }

    public static class Radio
    extends SimpleSelectBooleanCheckboxRenderer {
        public Radio(FacesBean.Type type) {
            super(type);
        }

        @Override
        protected String getCompositeId(String clientId) {
            return null;
        }

        @Override
        protected boolean getRenderSimpleSpan(UIComponent component, FacesBean bean) {
            return false;
        }

        @Override
        protected String getContentStyleClass(UIComponent component, FacesBean bean) {
            return null;
        }

        @Override
        protected void renderId(FacesContext context, UIComponent component) throws IOException {
            TableRenderingContext tContext = TableRenderingContext.getCurrentInstance();
            String param = tContext.getTableId() + ':' + "selected";
            ResponseWriter writer = context.getResponseWriter();
            writer.writeAttribute("name", (Object)param, null);
            if (this.getShortDesc(component, this.getFacesBean(component)) != null) {
                writer.writeAttribute("id", (Object)this.getClientId(context, component), null);
            }
        }

        protected String getClientId(FacesContext context, UIComponent component) {
            return component.getContainerClientId(context);
        }

        @Override
        protected Object getSubmittedValue(UIComponent component, FacesBean bean) {
            TableRenderingContext tContext = TableRenderingContext.getCurrentInstance();
            return tContext.getSelectedRowKeys().isContained() ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        protected Object getType() {
            return "radio";
        }

        @Override
        protected Object getValueAttr(RenderingContext rc) {
            TableRenderingContext tContext = TableRenderingContext.getCurrentInstance();
            return ((UIXCollection)tContext.getCollectionComponent()).getClientRowKey();
        }

        @Override
        protected String getShortDesc(UIComponent component, FacesBean bean) {
            String key = this.getDefaultShortDescKey();
            RenderingContext arc = RenderingContext.getCurrentInstance();
            return arc.getTranslatedString(key);
        }

        protected String getDefaultShortDescKey() {
            return "af_tableSelectOne.SELECT_COLUMN_HEADER";
        }

        @Override
        protected char getAccessKey(UIComponent component, FacesBean bean) {
            return '\uffff';
        }

        @Override
        protected boolean isImmediate(UIComponent component, FacesBean bean) {
            TableRenderingContext tContext = TableRenderingContext.getCurrentInstance();
            return tContext.isImmediate();
        }

        @Override
        protected boolean getReadOnly(FacesContext context, UIComponent component, FacesBean bean) {
            return false;
        }

        @Override
        protected boolean getDisabled(UIComponent component, FacesBean bean) {
            return false;
        }

        @Override
        protected String getOnblur(UIComponent component, FacesBean bean) {
            return null;
        }

        @Override
        protected String getOnfocus(UIComponent component, FacesBean bean) {
            return null;
        }

        @Override
        protected String getOnchange(UIComponent component, FacesBean bean) {
            return null;
        }

        protected String getOnselect(UIComponent component, FacesBean bean) {
            return null;
        }

        @Override
        protected String getText(UIComponent component, FacesBean bean) {
            return null;
        }
    }
}

