/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin.pregen.context;

import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.context.AccessibilityProfile;
import org.apache.myfaces.trinidad.context.LocaleContext;
import org.apache.myfaces.trinidad.style.Styles;
import org.apache.myfaces.trinidadinternal.agent.AgentNameUtil;
import org.apache.myfaces.trinidadinternal.agent.DefaultAgent;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgentImpl;
import org.apache.myfaces.trinidadinternal.skin.pregen.config.PregenConfig;
import org.apache.myfaces.trinidadinternal.skin.pregen.variant.ApplicationAndVersion;
import org.apache.myfaces.trinidadinternal.skin.pregen.variant.SkinVariant;
import org.apache.myfaces.trinidadinternal.style.StyleContext;
import org.apache.myfaces.trinidadinternal.style.StyleProvider;
import org.apache.myfaces.trinidadinternal.style.StyleSheetNamingStrategy;

public final class PregenStyleContext
implements StyleContext {
    private final StyleProvider _styleProvider;
    private final String _generatedFilesPath;
    private final SkinVariant _variant;
    private final TrinidadAgent _agent;
    private final boolean _dirty;

    public static StyleContext documentContext(FacesContext context, StyleProvider provider, String path) {
        return new PregenStyleContext(context, provider, path, null, false);
    }

    public PregenStyleContext(FacesContext context, StyleProvider provider, String generatedFilesPath, SkinVariant variant, boolean dirty) {
        this._styleProvider = provider;
        this._generatedFilesPath = generatedFilesPath;
        this._variant = variant;
        this._agent = PregenStyleContext._createTrinidadAgent(context, variant);
        this._dirty = dirty;
    }

    @Override
    public LocaleContext getLocaleContext() {
        return this._variant.getLocaleContext();
    }

    @Override
    public TrinidadAgent getAgent() {
        return this._agent;
    }

    @Override
    public String getGeneratedFilesPath() {
        return this._generatedFilesPath;
    }

    @Override
    public StyleSheetNamingStrategy getNamingStrategy() {
        return StyleSheetNamingStrategy.STABLE;
    }

    @Override
    public boolean checkStylesModified() {
        return false;
    }

    @Override
    public boolean disableStandardsMode() {
        return false;
    }

    @Override
    public StyleProvider getStyleProvider() {
        return this.getStyleProvider(false);
    }

    @Override
    public StyleProvider getStyleProvider(boolean recompute) {
        return this._styleProvider;
    }

    @Override
    public Styles getStyles() {
        return null;
    }

    @Override
    public AccessibilityProfile getAccessibilityProfile() {
        return this._variant.getAccessibilityProfile();
    }

    @Override
    public boolean isPortletMode() {
        return this._variant.getContainerType() == PregenConfig.ContainerType.PORTLET;
    }

    @Override
    public boolean isDisableStyleCompression() {
        return this._variant.getStyleClassType() == PregenConfig.StyleClassType.UNCOMPRESSED;
    }

    @Override
    public boolean isDirty() {
        return this._dirty;
    }

    @Override
    public boolean isRequestSecure() {
        return this._variant.getRequestType() == PregenConfig.RequestType.SECURE;
    }

    private static TrinidadAgent _createTrinidadAgent(FacesContext context, SkinVariant variant) {
        if (variant == null) {
            return null;
        }
        PregenAgent agent = new PregenAgent(variant.getPlatform(), variant.getApplicationAndVersion());
        return new TrinidadAgentImpl(context, agent);
    }

    private static class PregenAgent
    extends DefaultAgent {
        private final String _agentName;
        private final String _agentVersion;
        private final String _platformName;

        public PregenAgent(int platform, ApplicationAndVersion appAndVersion) {
            assert (appAndVersion != null);
            this._platformName = AgentNameUtil.getPlatformName(platform);
            this._agentName = appAndVersion.application.getAgentName();
            this._agentVersion = appAndVersion.version.toString();
        }

        @Override
        public String getAgentName() {
            return this._agentName;
        }

        @Override
        public String getAgentVersion() {
            return this._agentVersion;
        }

        @Override
        public String getPlatformName() {
            return this._platformName;
        }
    }
}

