/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin.parse;

import javax.el.ValueExpression;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.CustomMetadata;
import org.apache.myfaces.trinidad.skin.SkinAddition;
import org.apache.myfaces.trinidad.skin.SkinFeatures;
import org.apache.myfaces.trinidadinternal.config.LazyValueExpression;
import org.apache.myfaces.trinidadinternal.share.xml.BaseNodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.NodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.apache.myfaces.trinidadinternal.share.xml.StringParser;
import org.apache.myfaces.trinidadinternal.skin.parse.XMLConstants;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public class SkinAdditionParser
extends BaseNodeParser
implements XMLConstants {
    private String _skinId;
    private String _styleSheetName;
    private String _resourceBundleName;
    private String _translationSourceExpression;
    private SkinFeatures _skinFeatures;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SkinAdditionParser.class);

    @Override
    public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
    }

    @Override
    public Object endElement(ParseContext context, String namespaceURI, String localName) throws SAXParseException {
        Object isMetaInf;
        if (this._skinId == null) {
            _LOG.severe("REQUIRED_ELEMENT_SKINID_NOT_FOUND");
        }
        if (this._resourceBundleName != null && this._translationSourceExpression != null) {
            _LOG.severe("BOTH_BUNDLENAME_TRANSLATIONSOURCE_SET");
            this._translationSourceExpression = null;
        }
        if (!(this._translationSourceExpression == null || this._translationSourceExpression.startsWith("#{") && this._translationSourceExpression.endsWith("}"))) {
            _LOG.severe("TRANSLATION_SOURCE_NOT_EL");
            this._translationSourceExpression = null;
        }
        if ((isMetaInf = context.getProperty("http://myfaces.apache.org/trinidad/skin", "meta-inf")) != null && this._styleSheetName != null && Boolean.parseBoolean(isMetaInf.toString()) && !this._styleSheetName.startsWith("/")) {
            this._styleSheetName = "META-INF/".concat(this._styleSheetName);
        }
        SkinFeatures features = this._skinFeatures;
        SkinAddition addition = null;
        if (this._styleSheetName != null || this._resourceBundleName != null || this._translationSourceExpression != null) {
            if (this._resourceBundleName != null) {
                addition = new SkinAddition.Builder().skinId(this._skinId).styleSheetName(this._styleSheetName).resourceBundleName(this._resourceBundleName).features(features).build();
            } else {
                ValueExpression translationSourceVE = null;
                if (this._translationSourceExpression != null) {
                    translationSourceVE = LazyValueExpression.createValueExpression(this._translationSourceExpression.trim(), Object.class);
                }
                addition = translationSourceVE != null ? new SkinAddition.Builder().skinId(this._skinId).styleSheetName(this._styleSheetName).translationSource(translationSourceVE).features(features).build() : new SkinAddition.Builder().skinId(this._skinId).styleSheetName(this._styleSheetName).features(features).build();
            }
        } else if (features != null) {
            addition = new SkinAddition.Builder().skinId(this._skinId).features(features).build();
        }
        return addition;
    }

    @Override
    public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        if ("skin-id".equals(localName) || "style-sheet-name".equals(localName) || "bundle-name".equals(localName) || "translation-source".equals(localName)) {
            return new StringParser();
        }
        if ("features".equals(localName)) {
            return context.getParser(SkinFeatures.class, namespaceURI, localName);
        }
        if ("metadata".equals(localName)) {
            return context.getParser(CustomMetadata.class, namespaceURI, localName);
        }
        return null;
    }

    @Override
    public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) throws SAXParseException {
        if ("skin-id".equals(localName)) {
            this._skinId = (String)child;
        } else if ("style-sheet-name".equals(localName)) {
            this._styleSheetName = (String)child;
        } else if ("bundle-name".equals(localName)) {
            this._resourceBundleName = (String)child;
        } else if ("translation-source".equals(localName)) {
            this._translationSourceExpression = (String)child;
        } else if ("features".equals(localName)) {
            this._skinFeatures = (SkinFeatures)child;
        }
    }
}

