/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin.parse;

import javax.el.ValueExpression;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.CustomMetadata;
import org.apache.myfaces.trinidad.skin.SkinFeatures;
import org.apache.myfaces.trinidad.skin.SkinMetadata;
import org.apache.myfaces.trinidad.skin.SkinVersion;
import org.apache.myfaces.trinidadinternal.config.LazyValueExpression;
import org.apache.myfaces.trinidadinternal.share.xml.BaseNodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.NodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.apache.myfaces.trinidadinternal.share.xml.StringParser;
import org.apache.myfaces.trinidadinternal.skin.parse.XMLConstants;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public class SkinMetadataParser
extends BaseNodeParser
implements XMLConstants {
    private String _namespace;
    private String _id;
    private String _family;
    private String _styleSheetName;
    private String _renderKitId;
    private String _bundleName;
    private String _translationSourceExpression;
    private String _extends;
    private SkinVersion _skinVersionNode;
    private SkinFeatures _skinFeaturesNode;
    private CustomMetadata _skinMetadataNode;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SkinMetadataParser.class);

    @Override
    public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        this._namespace = namespaceURI;
    }

    @Override
    public Object endElement(ParseContext context, String namespaceURI, String localName) throws SAXParseException {
        Object isMetaInf;
        if (this._id == null) {
            _LOG.severe("REQUIRED_ELEMENT_ID_NOT_FOUND");
            throw new NullPointerException(_LOG.getMessage("NULL_ID"));
        }
        if (this._family == null) {
            _LOG.severe("REQURIED_ELEMENT_FAMILY_NOT_FOUND");
            throw new NullPointerException(_LOG.getMessage("NULL_FAMILY"));
        }
        if (this._bundleName != null && this._translationSourceExpression != null) {
            _LOG.severe("BOTH_BUNDLENAME_TRANSLATIONSOURCE_SET");
            this._translationSourceExpression = null;
        }
        if (!(this._translationSourceExpression == null || this._translationSourceExpression.startsWith("#{") && this._translationSourceExpression.endsWith("}"))) {
            _LOG.severe("TRANSLATION_SOURCE_NOT_EL");
            this._translationSourceExpression = null;
        }
        if ((isMetaInf = context.getProperty("http://myfaces.apache.org/trinidad/skin", "meta-inf")) != null && this._styleSheetName != null && Boolean.parseBoolean(isMetaInf.toString()) && !this._styleSheetName.startsWith("/")) {
            this._styleSheetName = "META-INF/".concat(this._styleSheetName);
        }
        ValueExpression translationSource = null;
        if (this._translationSourceExpression != null) {
            translationSource = LazyValueExpression.createValueExpression(this._translationSourceExpression, Object.class);
        }
        return new SkinMetadata.Builder().id(this._id).family(this._family).renderKitId(SkinMetadata.RenderKitId.fromId((String)this._renderKitId)).baseSkinId(this._extends).styleSheetName(this._styleSheetName).resourceBundleName(this._bundleName).translationSource(translationSource).version(this._skinVersionNode).features(this._skinFeaturesNode).metadata(this._skinMetadataNode).build();
    }

    @Override
    public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        if (!namespaceURI.equals(this._namespace)) {
            return null;
        }
        if ("id".equals(localName) || "family".equals(localName) || "render-kit-id".equals(localName) || "style-sheet-name".equals(localName) || "bundle-name".equals(localName) || "translation-source".equals(localName) || "extends".equals(localName)) {
            return new StringParser();
        }
        if ("version".equals(localName)) {
            return context.getParser(SkinVersion.class, namespaceURI, localName);
        }
        if ("features".equals(localName)) {
            return context.getParser(SkinFeatures.class, namespaceURI, localName);
        }
        if ("metadata".equals(localName)) {
            return context.getParser(CustomMetadata.class, namespaceURI, localName);
        }
        return null;
    }

    @Override
    public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) throws SAXParseException {
        if ("id".equals(localName)) {
            this._id = (String)child;
        } else if ("family".equals(localName)) {
            this._family = (String)child;
        } else if ("render-kit-id".equals(localName)) {
            this._renderKitId = (String)child;
        } else if ("style-sheet-name".equals(localName)) {
            this._styleSheetName = (String)child;
        } else if ("bundle-name".equals(localName)) {
            this._bundleName = (String)child;
        } else if ("translation-source".equals(localName)) {
            this._translationSourceExpression = (String)child;
        } else if ("extends".equals(localName)) {
            this._extends = (String)child;
        } else if (child instanceof SkinVersion) {
            this._skinVersionNode = (SkinVersion)child;
        } else if (child instanceof SkinFeatures) {
            this._skinFeaturesNode = (SkinFeatures)child;
        } else if (child instanceof CustomMetadata) {
            this._skinMetadataNode = (CustomMetadata)child;
        }
    }
}

