/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

public class Base64OutputStream
extends OutputStream {
    private final byte[] _leftoverBytes;
    private int _numLeftoverBytes;
    private final char[] _fourChars = new char[4];
    private final byte[] _single = new byte[1];
    private final Writer _out;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(Base64OutputStream.class);

    public Base64OutputStream(Writer out) {
        this._out = out;
        this._numLeftoverBytes = 0;
        this._leftoverBytes = new byte[2];
    }

    @Override
    public void write(int b) throws IOException {
        this._single[0] = (byte)b;
        this.write(this._single, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException, NullPointerException {
        if (b == null) {
            throw new NullPointerException(_LOG.getMessage("BYTE_ARRAY_CANNOT_BE_NULL"));
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException(_LOG.getMessage("ACTUAL_LENGTH_OFFSET", new Object[]{b.length, off, len}));
        }
        int lengthToProcess = len;
        int index = off;
        if (lengthToProcess == 1) {
            if (this._numLeftoverBytes == 0) {
                this._numLeftoverBytes = 1;
                this._leftoverBytes[0] = b[index];
            } else if (this._numLeftoverBytes == 1) {
                this._numLeftoverBytes = 2;
                this._leftoverBytes[1] = b[index];
            } else if (this._numLeftoverBytes == 2) {
                this._writeBase64(this._leftoverBytes[0], this._leftoverBytes[1], b[index]);
                this._numLeftoverBytes = 0;
            }
            return;
        }
        if (lengthToProcess == 2) {
            if (this._numLeftoverBytes == 0) {
                this._numLeftoverBytes = 2;
                this._leftoverBytes[0] = b[index];
                this._leftoverBytes[1] = b[index + 1];
            } else if (this._numLeftoverBytes == 1) {
                this._writeBase64(this._leftoverBytes[0], b[index], b[index + 1]);
                this._numLeftoverBytes = 0;
            } else if (this._numLeftoverBytes == 2) {
                this._writeBase64(this._leftoverBytes[0], this._leftoverBytes[1], b[index]);
                this._leftoverBytes[0] = b[index + 1];
                this._numLeftoverBytes = 1;
            }
            return;
        }
        if (lengthToProcess > 2) {
            if (this._numLeftoverBytes == 1) {
                this._writeBase64(this._leftoverBytes[0], b[index], b[index + 1]);
                this._numLeftoverBytes = 0;
                lengthToProcess -= 2;
                index += 2;
            } else if (this._numLeftoverBytes == 2) {
                this._writeBase64(this._leftoverBytes[0], this._leftoverBytes[1], b[index]);
                this._numLeftoverBytes = 0;
                --lengthToProcess;
                ++index;
            }
            this._processArray(b, index, lengthToProcess);
        }
    }

    @Override
    public void flush() throws IOException {
        this._out.flush();
    }

    @Deprecated
    public void finish() throws IOException {
        this.close();
    }

    @Override
    public void close() throws IOException {
        if (this._numLeftoverBytes == 1) {
            byte b1 = this._leftoverBytes[0];
            int c1 = b1 >> 2 & 0x3F;
            int c2 = b1 << 4 & 0x3F;
            char[] encodedChars = this._fourChars;
            encodedChars[0] = Base64OutputStream._encode(c1);
            encodedChars[1] = Base64OutputStream._encode(c2);
            encodedChars[2] = 61;
            encodedChars[3] = 61;
            this._out.write(encodedChars);
        } else if (this._numLeftoverBytes == 2) {
            byte b1 = this._leftoverBytes[0];
            byte b2 = this._leftoverBytes[1];
            int c1 = b1 >> 2 & 0x3F;
            int c2 = (b1 << 4 | b2 >> 4 & 0xF) & 0x3F;
            int c3 = b2 << 2 & 0x3F;
            char[] encodedChars = this._fourChars;
            encodedChars[0] = Base64OutputStream._encode(c1);
            encodedChars[1] = Base64OutputStream._encode(c2);
            encodedChars[2] = Base64OutputStream._encode(c3);
            encodedChars[3] = 61;
            this._out.write(encodedChars);
        }
        this._out.close();
    }

    private void _writeBase64(byte b1, byte b2, byte b3) throws IOException {
        char[] encodedChars = this._fourChars;
        int c1 = b1 >> 2 & 0x3F;
        int c2 = (b1 << 4 | b2 >> 4 & 0xF) & 0x3F;
        int c3 = (b2 << 2 | b3 >> 6 & 3) & 0x3F;
        int c4 = b3 & 0x3F;
        encodedChars[0] = Base64OutputStream._encode(c1);
        encodedChars[1] = Base64OutputStream._encode(c2);
        encodedChars[2] = Base64OutputStream._encode(c3);
        encodedChars[3] = Base64OutputStream._encode(c4);
        this._out.write(encodedChars);
    }

    private void _processArray(byte[] b, int startIndex, int lengthToProcess) throws IOException {
        int index = startIndex;
        while (lengthToProcess > 0) {
            if (lengthToProcess == 1) {
                this._numLeftoverBytes = 1;
                this._leftoverBytes[0] = b[index];
                return;
            }
            if (lengthToProcess == 2) {
                this._numLeftoverBytes = 2;
                this._leftoverBytes[0] = b[index];
                this._leftoverBytes[1] = b[index + 1];
                return;
            }
            this._writeBase64(b[index], b[index + 1], b[index + 2]);
            lengthToProcess -= 3;
            index += 3;
        }
    }

    private static char _encode(int c) {
        if (c < 26) {
            return (char)(65 + c);
        }
        if (c < 52) {
            return (char)(97 + (c - 26));
        }
        if (c < 62) {
            return (char)(48 + (c - 52));
        }
        if (c == 62) {
            return '+';
        }
        if (c == 63) {
            return '/';
        }
        throw new AssertionError((Object)("Invalid B64 character code:" + c));
    }
}

