/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table;

import java.util.Map;
import javax.faces.component.UIComponent;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.data.CoreTable;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableRenderingContext;

public final class BandingData {
    private final int _rowBanding;
    private final int _colBanding;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(BandingData.class);

    public static BandingData create(TableRenderingContext context) {
        UIComponent hgrid = context.getTable();
        Map attrs = hgrid.getAttributes();
        int row = BandingData._getInterval(attrs, CoreTable.ROW_BANDING_INTERVAL_KEY);
        int col = BandingData._getInterval(attrs, CoreTable.COLUMN_BANDING_INTERVAL_KEY);
        return new BandingData(col, row);
    }

    private static int _getInterval(Map<String, Object> attrs, PropertyKey key) {
        int interval;
        Number num = (Number)attrs.get(key.getName());
        int n = interval = num != null ? num.intValue() : 0;
        if (interval < 0) {
            _LOG.warning("ILLEGAL_VALUE", new Object[]{interval, key});
            interval = 0;
        }
        return interval;
    }

    public boolean getBand(TableRenderingContext context, int row, int physicalColumn, int logicalColumn) {
        boolean band = false;
        if (this._rowBanding > 0) {
            boolean bl = band = row / this._rowBanding % 2 != 0;
        }
        if (this._colBanding > 0) {
            band |= physicalColumn / this._colBanding % 2 != 0;
        }
        return band;
    }

    private BandingData(int colBanding, int rowBanding) {
        this._rowBanding = rowBanding;
        this._colBanding = colBanding;
    }
}

