/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style.util;

import java.beans.Beans;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.style.StyleContext;
import org.apache.myfaces.trinidadinternal.style.util.CSSUtils;
import org.apache.myfaces.trinidadinternal.style.util.StyleUtils;
import org.apache.myfaces.trinidadinternal.style.util.StyleWriterFactory;
import org.apache.myfaces.trinidadinternal.style.xml.parse.PropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleNode;

public class CSSGenerationUtils {
    private static final Set<String> _BUILT_IN_PSEUDO_CLASSES = new HashSet<String>();
    private static final Set<String> _BACKWARD_COMPATIBLE_CSS3_PSEUDO_CLASSES = new HashSet<String>();
    private static final Set<String> _BUILT_IN_PSEUDO_ELEMENTS = new HashSet<String>();
    private static final Set<String> _AT_PAGE_PSEUDO_CLASSES = new HashSet<String>();
    private static final Pattern _DASH_PATTERN;
    private static final int _MSIE_SELECTOR_LIMIT = 4095;
    private static final String _DEFAULT_NAMESPACE = "af|";
    private static final String _DEFAULT_AF_SELECTOR = ".AF";
    private static final String _AT_PAGE_SELECTOR = "@page";
    private static final TrinidadLogger _LOG;

    private static MatchingStyles _buildMatchingStylesMap(List<StyleNode> styleNodes) {
        int styleCount = styleNodes.size();
        MatchingStyles matchingStyles = new MatchingStyles(styleCount);
        for (StyleNode styleNode : styleNodes) {
            String propertyString;
            if (styleNode.getSelector() == null || "".equals(propertyString = CSSGenerationUtils._getSortedPropertyString(styleNode))) continue;
            if (styleNode.hasClientRule()) {
                matchingStyles.addStyle(styleNode.getClientRule(), propertyString, styleNode);
                continue;
            }
            matchingStyles.addStyle(propertyString, styleNode);
        }
        return matchingStyles;
    }

    private static void _writeMergedProperties(PrintWriter out, Iterable<PropertyNode> properties, String styleSheetName, boolean compressStyles, String baseURI) {
        out.print(" {");
        boolean first = true;
        for (PropertyNode property : properties) {
            String propName = property.getName();
            String propValue = property.getValue();
            if (propName == null || propValue == null || propValue.length() <= 0) continue;
            if (first) {
                first = false;
            } else {
                out.print(';');
            }
            out.print(propName);
            out.print(':');
            String resolvedPropValue = CSSUtils.resolvePropertyValue(styleSheetName, baseURI, propName, propValue);
            out.print(resolvedPropValue);
        }
        out.print('}');
        if (!compressStyles) {
            out.println();
        }
    }

    private static void _writeValidSelectors(PrintWriter out, List<String> validSelectors) {
        boolean first = true;
        for (String validSelector : validSelectors) {
            if (first) {
                first = false;
            } else {
                out.print(',');
            }
            out.print(validSelector);
        }
    }

    private static List<String> _calculateValidSelectors(boolean compressStyles, Map<String, String> shortStyleClassMap, String[] namespacePrefixArray, List<String> mappedSelectors) {
        ArrayList<String> validSelectors = new ArrayList<String>(mappedSelectors.size() * 2);
        for (String mappedSelector : mappedSelectors) {
            String shortSelector;
            String validFullNameSelector = null;
            if (!(compressStyles && mappedSelector.indexOf(124) != -1 || (validFullNameSelector = CSSGenerationUtils.getValidFullNameSelector(mappedSelector, namespacePrefixArray)) == null)) {
                validSelectors.add(validFullNameSelector);
            }
            if (!compressStyles || (shortSelector = CSSGenerationUtils.getShortSelector(shortStyleClassMap, namespacePrefixArray, mappedSelector)) == null) continue;
            String validShortSelector = CSSGenerationUtils.getValidFullNameSelector(shortSelector, namespacePrefixArray);
            if (validFullNameSelector != null) {
                if (validFullNameSelector.equals(validShortSelector)) continue;
                validSelectors.add(validShortSelector);
                continue;
            }
            validSelectors.add(validShortSelector);
        }
        return validSelectors;
    }

    private static int _writeMergedSelectors(PrintWriter out, boolean compressStyles, Map<String, String> shortStyleClassMap, String[] namespacePrefixArray, int maxSelectors, List<String> mappedSelectors) {
        List<String> validSelectors = CSSGenerationUtils._calculateValidSelectors(compressStyles, shortStyleClassMap, namespacePrefixArray, mappedSelectors);
        int selectorsToWrite = validSelectors.size();
        if (selectorsToWrite >= maxSelectors) {
            return 0;
        }
        CSSGenerationUtils._writeValidSelectors(out, validSelectors);
        return selectorsToWrite;
    }

    private static List<String> _calculateMappedSelectors(String[] namespacePrefixArray, Map<String, String> afSelectorMap, List<StyleNode> matchingStyleNodes) {
        ArrayList<String> mappedSelectors = new ArrayList<String>(matchingStyleNodes.size());
        for (StyleNode matchingNode : matchingStyleNodes) {
            String matchingSelector = matchingNode.getSelector();
            assert (matchingSelector != null);
            String mappedSelector = CSSGenerationUtils.getMappedSelector(afSelectorMap, namespacePrefixArray, matchingSelector);
            mappedSelectors.add(mappedSelector);
        }
        return mappedSelectors;
    }

    private static int _writeMergedEntry(String styleSheetName, String baseURI, boolean compressStyles, Map<String, String> shortStyleClassMap, String[] namespacePrefixArray, Map<String, String> afSelectorMap, PrintWriter out, int maxSelectors, Map.Entry<String, List<StyleNode>> mergedEntry) {
        String propertyString = mergedEntry.getKey();
        assert (propertyString != null);
        assert (!"".equals(propertyString));
        List<StyleNode> matchingStyleNodes = mergedEntry.getValue();
        assert (!matchingStyleNodes.isEmpty());
        List<String> mappedSelectors = CSSGenerationUtils._calculateMappedSelectors(namespacePrefixArray, afSelectorMap, matchingStyleNodes);
        int numberSelectorsWritten = CSSGenerationUtils._writeMergedSelectors(out, compressStyles, shortStyleClassMap, namespacePrefixArray, maxSelectors, mappedSelectors);
        if (numberSelectorsWritten > 0) {
            Collection<PropertyNode> properties = matchingStyleNodes.get(0).getProperties();
            CSSGenerationUtils._writeMergedProperties(out, properties, styleSheetName, compressStyles, baseURI);
        }
        return numberSelectorsWritten;
    }

    private static int _getMaxSelectorsPerFile(StyleContext context) {
        if (TrinidadAgent.Application.IEXPLORER == context.getAgent().getAgentApplication()) {
            return 4095;
        }
        return Integer.MAX_VALUE;
    }

    public static void writeCSS(StyleContext context, String styleSheetName, List<StyleNode> styleNodes, StyleWriterFactory writerFactory, boolean compressStyles, Map<String, String> shortStyleClassMap, String[] namespacePrefixArray, Map<String, String> afSelectorMap) {
        MatchingStyles matchingStyles = CSSGenerationUtils._buildMatchingStylesMap(styleNodes);
        String baseURI = CSSUtils.getBaseSkinStyleSheetURI(styleSheetName);
        int maxSelectorsPerFile = CSSGenerationUtils._getMaxSelectorsPerFile(context);
        int fileSelectorsWritten = 0;
        LinkedHashMap<String, List<StyleNode>> noClientRuleMap = matchingStyles.getNonClientRuleMap();
        Iterator<Map.Entry<String, List<StyleNode>>> noClientRuleEntries = noClientRuleMap.entrySet().iterator();
        PrintWriter out = writerFactory.createWriter();
        if (out == null) {
            return;
        }
        CSSGenerationUtils._beginCssFile(out, compressStyles);
        while (noClientRuleEntries.hasNext()) {
            Map.Entry<String, List<StyleNode>> abortedEntry = null;
            while (abortedEntry == null && noClientRuleEntries.hasNext()) {
                Map.Entry<String, List<StyleNode>> currEntry;
                if (abortedEntry != null) {
                    currEntry = abortedEntry;
                    abortedEntry = null;
                } else {
                    currEntry = noClientRuleEntries.next();
                }
                int selectorsLeft = maxSelectorsPerFile - fileSelectorsWritten;
                int entrySelectorsWritten = CSSGenerationUtils._writeMergedEntry(styleSheetName, baseURI, compressStyles, shortStyleClassMap, namespacePrefixArray, afSelectorMap, out, selectorsLeft, currEntry);
                if (entrySelectorsWritten == 0) {
                    abortedEntry = currEntry;
                    continue;
                }
                fileSelectorsWritten += entrySelectorsWritten;
            }
            if (abortedEntry == null) continue;
            CSSGenerationUtils._endCssFile(out, styleSheetName, compressStyles, fileSelectorsWritten);
            fileSelectorsWritten = 0;
            out = writerFactory.createWriter();
            if (out == null) {
                return;
            }
            CSSGenerationUtils._beginCssFile(out, compressStyles);
        }
        Set<String> clientRules = matchingStyles.getClientRules();
        Iterator<String> i$ = clientRules.iterator();
        while (i$.hasNext()) {
            StringWriter tempStringWriter = new StringWriter();
            PrintWriter tempWriter = new PrintWriter(tempStringWriter);
            String clientRule = i$.next();
            int clientRuleSelectorsWritten = CSSGenerationUtils._writeClientRuleStyles(tempWriter, clientRule, matchingStyles, maxSelectorsPerFile, fileSelectorsWritten, styleSheetName, baseURI, compressStyles, shortStyleClassMap, namespacePrefixArray, afSelectorMap);
            if (clientRuleSelectorsWritten == 0) {
                CSSGenerationUtils._endCssFile(out, styleSheetName, compressStyles, fileSelectorsWritten);
                fileSelectorsWritten = 0;
                out = writerFactory.createWriter();
                if (out == null) {
                    return;
                }
                CSSGenerationUtils._beginCssFile(out, compressStyles);
                tempWriter.close();
                tempStringWriter = new StringWriter();
                tempWriter = new PrintWriter(tempStringWriter);
                clientRuleSelectorsWritten = CSSGenerationUtils._writeClientRuleStyles(tempWriter, clientRule, matchingStyles, maxSelectorsPerFile, fileSelectorsWritten, styleSheetName, baseURI, compressStyles, shortStyleClassMap, namespacePrefixArray, afSelectorMap);
            }
            assert (clientRuleSelectorsWritten != 0);
            if (tempWriter.checkError()) {
                _LOG.severe("Error writing stylesheet:" + styleSheetName);
                return;
            }
            out.print(clientRule);
            CSSGenerationUtils._writeString(out, " {", compressStyles);
            out.print(tempStringWriter.toString());
            CSSGenerationUtils._writeString(out, "}", compressStyles);
            fileSelectorsWritten += clientRuleSelectorsWritten;
            tempWriter.close();
        }
        CSSGenerationUtils._endCssFile(out, styleSheetName, compressStyles, fileSelectorsWritten);
    }

    private static int _writeClientRuleStyles(PrintWriter out, String clientRule, MatchingStyles matchingStyles, int maxSelectorsPerFile, int fileSelectorsWritten, String styleSheetName, String baseURI, boolean compressStyles, Map<String, String> shortStyleClassMap, String[] namespacePrefixArray, Map<String, String> afSelectorMap) {
        int selectorsWritten = 0;
        int entrySelectorsWritten = 0;
        LinkedHashMap<String, List<StyleNode>> clientRuleMap = matchingStyles.getClientRuleMap(clientRule);
        Iterator<Map.Entry<String, List<StyleNode>>> clientRuleEntries = clientRuleMap.entrySet().iterator();
        while (clientRuleEntries.hasNext()) {
            int selectorsLeft = maxSelectorsPerFile - (fileSelectorsWritten + selectorsWritten);
            Map.Entry<String, List<StyleNode>> currEntry = clientRuleEntries.next();
            entrySelectorsWritten = CSSGenerationUtils._writeMergedEntry(styleSheetName, baseURI, compressStyles, shortStyleClassMap, namespacePrefixArray, afSelectorMap, out, selectorsLeft, currEntry);
            if (entrySelectorsWritten == 0) {
                return 0;
            }
            selectorsWritten += entrySelectorsWritten;
        }
        return selectorsWritten;
    }

    private static void _beginCssFile(PrintWriter out, boolean compressStyles) {
        if (!compressStyles) {
            Date date = new Date();
            out.println("/* This CSS file generated on " + date + " */");
        }
    }

    private static void _endCssFile(PrintWriter out, String styleSheetName, boolean compressStyles, int fileSelectorsWritten) {
        if (!compressStyles) {
            out.print("/* The number of CSS selectors in this file is ");
            out.print(fileSelectorsWritten);
            out.println(" */");
        }
        if (out.checkError()) {
            _LOG.severe("Error writing stylesheet:" + styleSheetName);
        }
        out.close();
    }

    private static void _writeString(PrintWriter out, String outStr, boolean compressStyles) {
        if (compressStyles) {
            out.print(outStr);
        } else {
            out.println(outStr);
        }
    }

    public static String getShortSelector(Map<String, String> shortStyleClassMap, String[] namespacePrefixArray, String selector) {
        String shortSelector = CSSGenerationUtils._getShortNonNamespacedSelector(selector, shortStyleClassMap);
        if (shortSelector == null) {
            shortSelector = selector;
        }
        if (CSSGenerationUtils._hasNamespacePrefix(shortSelector, namespacePrefixArray)) {
            String[] shortSelectorArray = StyleUtils.splitStringByWhitespace(shortSelector);
            shortSelector = CSSGenerationUtils._getMappedNSSelector(shortStyleClassMap, namespacePrefixArray, shortSelectorArray, true);
        }
        return shortSelector;
    }

    public static boolean isSingleStyleClassSelector(String selector) {
        if (selector == null || selector.length() < 2 || selector.charAt(0) != '.') {
            return false;
        }
        for (int i = 1; i < selector.length(); ++i) {
            if (!CSSGenerationUtils._isStyleClassTerminator(selector.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Iterator<String> getNonNamespacedStyleClasses(String selector) {
        ArrayList<String> styleClasses = null;
        boolean inAttributeSet = false;
        int styleClassStartIndex = -1;
        int length = selector.length();
        for (int i = 0; i < length; ++i) {
            char c = selector.charAt(i);
            if (inAttributeSet) {
                if (c != ']') continue;
                inAttributeSet = false;
                continue;
            }
            if (styleClassStartIndex == -1) {
                if (c == '.') {
                    styleClassStartIndex = i;
                    continue;
                }
                if (c != '[') continue;
                inAttributeSet = true;
                continue;
            }
            boolean end = CSSGenerationUtils._isStyleClassTerminator(c);
            if (!end && i == length - 1) {
                ++i;
                end = true;
            }
            if (!end) continue;
            if (c == '[') {
                inAttributeSet = true;
            }
            String styleClass = selector.substring(styleClassStartIndex + 1, i);
            if (styleClasses == null) {
                styleClasses = new ArrayList<String>(3);
            }
            styleClasses.add(styleClass);
            styleClassStartIndex = c == '.' ? i : -1;
        }
        if (styleClasses == null) {
            return null;
        }
        return styleClasses.iterator();
    }

    public static Iterator<String> getNamespacedSelectors(String selector, String namespace, Map<String, String> afSelectorMap) {
        if (selector == null) {
            return null;
        }
        int afIndex = selector.indexOf(namespace);
        if (afIndex == -1) {
            return null;
        }
        ArrayList<String> afUnmappedSelectorList = new ArrayList<String>();
        String base = selector.substring(afIndex);
        String[] afSelectors = CSSGenerationUtils._orderPseudoElementsAndClasses(base);
        for (int i = 0; i < afSelectors.length; ++i) {
            if (!afSelectors[i].startsWith(namespace)) continue;
            String afComponentSelector = CSSGenerationUtils._getNSComponentSelector(afSelectors[i], false);
            afUnmappedSelectorList.add(afComponentSelector);
        }
        ArrayList<String> afSelectorList = new ArrayList<String>();
        int size = afUnmappedSelectorList.size();
        for (int i = 0; i < size; ++i) {
            String afComponentSelector = (String)afUnmappedSelectorList.get(i);
            String mappedSelector = null;
            if (afSelectorMap != null) {
                mappedSelector = afSelectorMap.get(afComponentSelector);
            }
            if (mappedSelector != null) {
                int namespaceIndex = mappedSelector.indexOf(namespace);
                if (namespaceIndex <= -1) continue;
                String[] baseSelector = StyleUtils.splitStringByWhitespace(mappedSelector.substring(namespaceIndex));
                afComponentSelector = baseSelector[0];
                afSelectorList.add(afComponentSelector);
                continue;
            }
            afSelectorList.add(afComponentSelector);
        }
        return afSelectorList.iterator();
    }

    public static void getNamespacePrefixes(Set<String> namespacePrefixes, String selector) {
        int length = selector.length();
        int startSubstringIndex = 0;
        for (int i = 0; i < length; ++i) {
            char c = selector.charAt(i);
            if (c == '|') {
                String prefix = selector.substring(startSubstringIndex, i + 1);
                startSubstringIndex = i + 1;
                if (prefix.length() <= 1) continue;
                namespacePrefixes.add(prefix);
                continue;
            }
            if (!CSSGenerationUtils._isStyleClassTerminator(c)) continue;
            startSubstringIndex = i + 1;
        }
    }

    private static String _getNSComponentSelector(String singleAfSelector, boolean allowPseudoClass) {
        int endIndex;
        int colonIndex = singleAfSelector.indexOf("::");
        colonIndex = colonIndex != -1 ? (colonIndex += 2) : 0;
        String afterDoubleColon = singleAfSelector.substring(colonIndex);
        boolean end = false;
        int afterLength = afterDoubleColon.length();
        for (endIndex = 0; endIndex < afterLength && !end; ++endIndex) {
            char c = afterDoubleColon.charAt(endIndex);
            end = allowPseudoClass ? Character.isWhitespace(c) : CSSGenerationUtils._isStyleClassTerminator(c);
        }
        String afComponentSelector = null;
        afComponentSelector = end ? singleAfSelector.substring(0, colonIndex + endIndex - 1) : singleAfSelector;
        return afComponentSelector;
    }

    private static String _getShortNonNamespacedSelector(String selector, Map<String, String> shortStyleClassMap) {
        if (shortStyleClassMap == null) {
            return null;
        }
        if (CSSGenerationUtils.isSingleStyleClassSelector(selector)) {
            String shortStyleClass = shortStyleClassMap.get(selector.substring(1));
            return shortStyleClass == null ? null : "." + shortStyleClass;
        }
        boolean isShorter = false;
        int length = selector.length();
        StringBuffer buffer = new StringBuffer(length);
        int styleClassStartIndex = -1;
        for (int i = 0; i < length; ++i) {
            char c = selector.charAt(i);
            if (styleClassStartIndex == -1) {
                if (c == '.') {
                    styleClassStartIndex = i;
                }
                buffer.append(c);
                continue;
            }
            boolean end = CSSGenerationUtils._isStyleClassTerminator(c);
            if (!end && i == length - 1) {
                ++i;
                end = true;
            }
            if (!end) continue;
            String styleClass = selector.substring(styleClassStartIndex + 1, i);
            String shortStyleClass = null;
            if (styleClass.indexOf(124) == -1) {
                shortStyleClass = shortStyleClassMap.get(styleClass);
            }
            if (shortStyleClass == null) {
                buffer.append(styleClass);
            } else {
                buffer.append(shortStyleClass);
                isShorter = true;
            }
            if (i < length - 1) {
                buffer.append(c);
            }
            styleClassStartIndex = c == '.' ? i : -1;
        }
        return isShorter ? buffer.toString() : selector;
    }

    public static String getMappedSelector(Map<String, String> afSelectorMap, String[] namespacePrefixArray, String selector) {
        String mappedSelector;
        if (CSSGenerationUtils._hasNamespacePrefix(selector, namespacePrefixArray)) {
            String[] selectorArray = CSSGenerationUtils._orderPseudoElementsAndClasses(selector);
            mappedSelector = CSSGenerationUtils._getMappedNSSelector(afSelectorMap, namespacePrefixArray, selectorArray, false);
        } else {
            int start = 0;
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < selector.length(); ++i) {
                char c = selector.charAt(i);
                if (c != ' ') continue;
                if (start == i) {
                    start = i + 1;
                    continue;
                }
                String subSelector = selector.substring(start, i);
                subSelector = CSSGenerationUtils._convertPseudoClassesInSelector(subSelector, selector);
                start = i + 1;
                b.append(subSelector);
                b.append(' ');
            }
            if (start == 0) {
                mappedSelector = CSSGenerationUtils._convertPseudoClassesInSelector(selector, selector);
            } else {
                String subSelector = selector.substring(start);
                subSelector = CSSGenerationUtils._convertPseudoClassesInSelector(subSelector, selector);
                b.append(subSelector);
                mappedSelector = b.toString();
            }
        }
        return mappedSelector;
    }

    private static String _getMappedNSSelector(Map<String, String> map, String[] nsPrefixArray, String[] selectorArray, boolean shorten) {
        for (int i = 0; i < selectorArray.length; ++i) {
            int nsIndex = -1;
            int numNsPrefixes = nsPrefixArray.length;
            for (int j = 0; j < numNsPrefixes && nsIndex == -1; ++j) {
                nsIndex = selectorArray[i].indexOf(nsPrefixArray[j]);
            }
            if (nsIndex <= -1) continue;
            selectorArray[i] = CSSGenerationUtils._getEachMappedSelector(map, nsIndex, selectorArray[i], shorten);
        }
        return StyleUtils.arrayToStringWithSpaces(selectorArray);
    }

    private static String _getEachMappedSelector(Map<String, String> map, int indexOfNSPrefix, String selector, boolean shorten) {
        int endIndex;
        if (indexOfNSPrefix == -1) {
            return selector;
        }
        if (map == null) {
            return selector;
        }
        String wholeAfSelector = selector.substring(indexOfNSPrefix);
        int firstDoubleColonIndex = wholeAfSelector.indexOf("::");
        if (firstDoubleColonIndex != -1) {
            int lastDoubleColonIndex = wholeAfSelector.lastIndexOf("::");
            if (lastDoubleColonIndex != firstDoubleColonIndex && !_BUILT_IN_PSEUDO_ELEMENTS.contains(wholeAfSelector.substring(lastDoubleColonIndex))) {
                _LOG.warning("UNSUPPORTED_CONSECUTIVE_SUB_ELEMENT_SYNTAX", (Object)selector);
            }
            firstDoubleColonIndex += 2;
        } else {
            firstDoubleColonIndex = 0;
        }
        String afterDoubleColon = wholeAfSelector.substring(firstDoubleColonIndex);
        boolean end = false;
        int afterLength = afterDoubleColon.length();
        for (endIndex = 0; endIndex < afterLength && !end; ++endIndex) {
            char c = afterDoubleColon.charAt(endIndex);
            end = Character.isWhitespace(c) || c == '.' || c == ':' || c == '[';
        }
        String mainSelector = endIndex == afterLength ? wholeAfSelector.substring(0, firstDoubleColonIndex + endIndex) : wholeAfSelector.substring(0, firstDoubleColonIndex + endIndex - 1);
        String afterMain = null;
        if (endIndex != afterLength) {
            afterMain = wholeAfSelector.substring(firstDoubleColonIndex + endIndex - 1);
            if (!shorten && !_BUILT_IN_PSEUDO_ELEMENTS.contains(afterMain)) {
                afterMain = CSSGenerationUtils._convertPseudoClassesInSelector(afterMain, wholeAfSelector);
            }
        }
        StringBuffer buffer = new StringBuffer();
        if (indexOfNSPrefix > 0) {
            buffer.append(selector.substring(0, indexOfNSPrefix));
            if (shorten && selector.charAt(indexOfNSPrefix - 1) != '.') {
                buffer.append('.');
            }
        } else if (shorten) {
            buffer.append('.');
        }
        buffer.append(CSSGenerationUtils._runThroughMap(map, mainSelector));
        if (afterMain != null) {
            buffer.append(afterMain);
        }
        return buffer.toString();
    }

    private static boolean _hasNamespacePrefix(String selector, String[] nsPrefixArray) {
        if (selector == null) {
            return false;
        }
        boolean hasNamespacePrefix = false;
        int numNamespaces = nsPrefixArray.length;
        for (int i = 0; i < numNamespaces && !hasNamespacePrefix; ++i) {
            if (selector.indexOf(nsPrefixArray[i]) <= -1) continue;
            hasNamespacePrefix = true;
        }
        return hasNamespacePrefix;
    }

    private static String[] _orderPseudoElementsAndClasses(String selector) {
        String[] input = StyleUtils.splitStringByWhitespace(selector);
        ArrayList<String> output = new ArrayList<String>();
        for (int i = 0; i < input.length; ++i) {
            int indexOfClass;
            boolean styleClassBeforePseudoElement;
            int indexOfDoubleColon = input[i].indexOf("::");
            if (indexOfDoubleColon == -1) {
                output.add(input[i]);
                continue;
            }
            int indexOfFirstColon = input[i].indexOf(58);
            int indexOfDot = input[i].indexOf(46);
            boolean pseudoClassBeforePseudoElement = indexOfFirstColon < indexOfDoubleColon;
            boolean bl = styleClassBeforePseudoElement = indexOfDot != -1 && indexOfDot < indexOfDoubleColon;
            if (!pseudoClassBeforePseudoElement && !styleClassBeforePseudoElement) {
                output.add(input[i]);
                continue;
            }
            if (indexOfFirstColon == indexOfDoubleColon) {
                indexOfFirstColon = -1;
            }
            if ((indexOfClass = Math.min(indexOfFirstColon, indexOfDot)) == -1) {
                indexOfClass = Math.max(indexOfFirstColon, indexOfDot);
            }
            String main = input[i].substring(0, indexOfClass);
            String mainPlusClasses = input[i].substring(0, indexOfDoubleColon);
            String end = input[i].substring(indexOfDoubleColon);
            output.add(mainPlusClasses);
            output.add(main + end);
        }
        return output.toArray(new String[output.size()]);
    }

    public static String getValidFullNameSelector(String selector, String[] namespacePrefixArray) {
        if (selector.indexOf(124) == -1) {
            return selector;
        }
        String[] spacerArray = StyleUtils.splitStringByWhitespace(selector);
        block0: for (int i = 0; i < spacerArray.length; ++i) {
            if (spacerArray[i].indexOf(124) <= -1) continue;
            for (int j = 0; j < namespacePrefixArray.length; ++j) {
                String nsPrefix = namespacePrefixArray[j];
                if (!spacerArray[i].startsWith(nsPrefix)) continue;
                spacerArray[i] = ".".concat(spacerArray[i]);
                continue block0;
            }
        }
        return StyleUtils.convertToValidSelector(StyleUtils.arrayToStringWithSpaces(spacerArray));
    }

    private static boolean _isStyleClassTerminator(char c) {
        return Character.isWhitespace(c) || c == ':' || c == '.' || c == '[';
    }

    private static int _computeBuilderSize(PropertyNode[] properties) {
        int builderSize = 0;
        for (int i = 0; i < properties.length; ++i) {
            PropertyNode property = properties[i];
            String name = property.getName();
            String value = property.getValue();
            if (name == null || value == null) continue;
            builderSize += property.getName().length();
            builderSize += property.getValue().length();
            ++builderSize;
        }
        return builderSize;
    }

    private static String _getSortedPropertyString(PropertyNode[] sortedProperties) {
        int builderSize = CSSGenerationUtils._computeBuilderSize(sortedProperties);
        StringBuilder builder = new StringBuilder(builderSize);
        boolean first = true;
        for (int i = 0; i < sortedProperties.length; ++i) {
            PropertyNode property = sortedProperties[i];
            String name = property.getName();
            String value = property.getValue();
            if (name == null || value == null) continue;
            if (!first) {
                builder.append(';');
            } else {
                first = false;
            }
            builder.append(name);
            builder.append(':');
            builder.append(value);
        }
        return builder.toString();
    }

    private static String _getSortedPropertyString(StyleNode styleNode) {
        Collection<PropertyNode> nodeProperties = styleNode.getProperties();
        int propertyCount = nodeProperties.size();
        if (propertyCount == 0) {
            return "";
        }
        ArrayList<PropertyNode> properties = new ArrayList<PropertyNode>(nodeProperties);
        PropertyNode[] sortedProperties = properties.toArray(new PropertyNode[propertyCount]);
        Arrays.sort(sortedProperties, PropertyNodeNameComparator.sharedInstance());
        return CSSGenerationUtils._getSortedPropertyString(sortedProperties);
    }

    private static String _convertPseudoClassesInSelector(String selector, String completeSelector) {
        if (selector == null || completeSelector == null) {
            return selector;
        }
        boolean afNamespacedSelector = CSSGenerationUtils._isAFNamespacedSelector(completeSelector);
        StringBuffer completeBuffer = new StringBuffer();
        StringBuffer pseudoClassBuffer = new StringBuffer();
        boolean inPseudoClass = false;
        for (int i = 0; i < selector.length(); ++i) {
            char x = selector.charAt(i);
            if (x == ':' || x == '.' || x == '[') {
                if (inPseudoClass) {
                    String convertedPseudoClass = CSSGenerationUtils._convertPseudoClass(completeSelector, pseudoClassBuffer.toString(), afNamespacedSelector);
                    completeBuffer.append(convertedPseudoClass);
                    pseudoClassBuffer = new StringBuffer();
                    inPseudoClass = false;
                }
                if (x == ':') {
                    inPseudoClass = true;
                    pseudoClassBuffer.append(x);
                    continue;
                }
                if (x != '.' && x != '[') continue;
                completeBuffer.append(x);
                continue;
            }
            if (!inPseudoClass) {
                completeBuffer.append(x);
                continue;
            }
            pseudoClassBuffer.append(x);
        }
        if (inPseudoClass) {
            String mappedPseudoClass = CSSGenerationUtils._convertPseudoClass(completeSelector, pseudoClassBuffer.toString(), afNamespacedSelector);
            completeBuffer.append(mappedPseudoClass);
        }
        return completeBuffer.toString();
    }

    private static boolean _isAFNamespacedSelector(String completeSelector) {
        HashSet<String> namespaces = new HashSet<String>();
        CSSGenerationUtils.getNamespacePrefixes(namespaces, completeSelector);
        if (namespaces.isEmpty() && completeSelector.startsWith(_DEFAULT_AF_SELECTOR)) {
            return true;
        }
        return namespaces.contains(_DEFAULT_NAMESPACE);
    }

    private static String _runThroughMap(Map<String, String> map, String selector) {
        String mappedSelector = map.get(selector);
        return mappedSelector != null ? mappedSelector : selector;
    }

    private static String _convertPseudoClass(String completeSelector, String pseudoClass, boolean afNamespacedSelector) {
        String builtInPseudoClass = pseudoClass;
        int parenthesesIndex = pseudoClass.indexOf("(");
        if (parenthesesIndex == -1) {
            parenthesesIndex = pseudoClass.indexOf(")");
        }
        if (parenthesesIndex != -1) {
            builtInPseudoClass = pseudoClass.substring(0, parenthesesIndex);
        }
        if (_BUILT_IN_PSEUDO_CLASSES.contains(builtInPseudoClass) && !Beans.isDesignTime()) {
            return pseudoClass;
        }
        if (completeSelector.contains(_AT_PAGE_SELECTOR) && _AT_PAGE_PSEUDO_CLASSES.contains(builtInPseudoClass)) {
            return pseudoClass;
        }
        if (!afNamespacedSelector && _BACKWARD_COMPATIBLE_CSS3_PSEUDO_CLASSES.contains(builtInPseudoClass)) {
            return pseudoClass;
        }
        StringBuilder builder = new StringBuilder(pseudoClass.length() + 3);
        builder.append(".");
        builder.append("p_AF");
        for (String content : _DASH_PATTERN.split(pseudoClass.substring(1))) {
            if (content.length() <= 0) continue;
            builder.append(Character.toUpperCase(content.charAt(0)));
            builder.append(content.substring(1));
        }
        return builder.toString();
    }

    static {
        _BUILT_IN_PSEUDO_CLASSES.add(":first-child");
        _BUILT_IN_PSEUDO_CLASSES.add(":link");
        _BUILT_IN_PSEUDO_CLASSES.add(":visited");
        _BUILT_IN_PSEUDO_CLASSES.add(":hover");
        _BUILT_IN_PSEUDO_CLASSES.add(":active");
        _BUILT_IN_PSEUDO_CLASSES.add(":focus");
        _BUILT_IN_PSEUDO_CLASSES.add(":-moz-placeholder");
        _BUILT_IN_PSEUDO_CLASSES.add(":-ms-input-placeholder");
        _BUILT_IN_PSEUDO_CLASSES.add(":after");
        _BUILT_IN_PSEUDO_CLASSES.add(":before");
        _BUILT_IN_PSEUDO_CLASSES.add(":first-line");
        _BUILT_IN_PSEUDO_CLASSES.add(":first-letter");
        _BUILT_IN_PSEUDO_CLASSES.add(":nth-child");
        _BUILT_IN_PSEUDO_CLASSES.add(":nth-last-child");
        _BUILT_IN_PSEUDO_CLASSES.add(":nth-of-type");
        _BUILT_IN_PSEUDO_CLASSES.add(":nth-last-of-type");
        _BUILT_IN_PSEUDO_CLASSES.add(":last-child");
        _BUILT_IN_PSEUDO_CLASSES.add(":first-of-type");
        _BUILT_IN_PSEUDO_CLASSES.add(":last-of-type");
        _BUILT_IN_PSEUDO_CLASSES.add(":only-child");
        _BUILT_IN_PSEUDO_CLASSES.add(":only-of-type");
        _BUILT_IN_PSEUDO_CLASSES.add(":root");
        _BUILT_IN_PSEUDO_CLASSES.add(":target");
        _BUILT_IN_PSEUDO_CLASSES.add(":enabled");
        _BUILT_IN_PSEUDO_CLASSES.add(":checked");
        _BUILT_IN_PSEUDO_CLASSES.add(":not");
        _BUILT_IN_PSEUDO_CLASSES.add(":lang");
        _BUILT_IN_PSEUDO_CLASSES.add(":indeterminate");
        _BACKWARD_COMPATIBLE_CSS3_PSEUDO_CLASSES.add(":disabled");
        _BACKWARD_COMPATIBLE_CSS3_PSEUDO_CLASSES.add(":empty");
        _BUILT_IN_PSEUDO_ELEMENTS.add("::outside");
        _BUILT_IN_PSEUDO_ELEMENTS.add("::before");
        _BUILT_IN_PSEUDO_ELEMENTS.add("::after");
        _BUILT_IN_PSEUDO_ELEMENTS.add("::alternate");
        _BUILT_IN_PSEUDO_ELEMENTS.add("::first-line");
        _BUILT_IN_PSEUDO_ELEMENTS.add("::first-letter");
        _BUILT_IN_PSEUDO_ELEMENTS.add("::marker");
        _BUILT_IN_PSEUDO_ELEMENTS.add("::line-marker");
        _BUILT_IN_PSEUDO_ELEMENTS.add("::selection");
        _BUILT_IN_PSEUDO_ELEMENTS.add("::-webkit-input-placeholder");
        _BUILT_IN_PSEUDO_ELEMENTS.add("::-moz-placeholder");
        _AT_PAGE_PSEUDO_CLASSES.add(":first");
        _AT_PAGE_PSEUDO_CLASSES.add(":left");
        _AT_PAGE_PSEUDO_CLASSES.add(":right");
        _DASH_PATTERN = Pattern.compile("-");
        _LOG = TrinidadLogger.createTrinidadLogger(CSSGenerationUtils.class);
    }

    private static final class MatchingEntry {
        private LinkedHashMap<String, List<StyleNode>> _matchingStyles;

        public MatchingEntry(int initialSize) {
            this._matchingStyles = new LinkedHashMap(initialSize);
        }

        public void addMatchingStyle(String propertyString, StyleNode styleNode) {
            if (propertyString == null || propertyString.equals("")) {
                return;
            }
            List<StyleNode> matchingStyles = this._matchingStyles.get(propertyString);
            if (matchingStyles == null) {
                matchingStyles = new ArrayList<StyleNode>(1);
                this._matchingStyles.put(propertyString, matchingStyles);
            }
            matchingStyles.add(styleNode);
        }

        public LinkedHashMap<String, List<StyleNode>> getMatchingStyles() {
            return this._matchingStyles;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MatchingEntry that = (MatchingEntry)o;
            return !(this._matchingStyles != null ? !this._matchingStyles.equals(that._matchingStyles) : that._matchingStyles != null);
        }

        public int hashCode() {
            return this._matchingStyles != null ? this._matchingStyles.hashCode() : 0;
        }
    }

    private static final class MatchingStyles {
        private final MatchingEntry _nonClientRuleEntry;
        private final LinkedHashMap<String, MatchingEntry> _clientRuleEntries;

        private MatchingStyles(int styleCount) {
            this._nonClientRuleEntry = new MatchingEntry(styleCount);
            this._clientRuleEntries = new LinkedHashMap();
        }

        public LinkedHashMap<String, List<StyleNode>> getNonClientRuleMap() {
            return this._nonClientRuleEntry.getMatchingStyles();
        }

        public LinkedHashMap<String, List<StyleNode>> getClientRuleMap(String clientRule) {
            return this._clientRuleEntries.get(clientRule).getMatchingStyles();
        }

        public Set<String> getClientRules() {
            return this._clientRuleEntries.keySet();
        }

        public void addStyle(String propertyString, StyleNode styleNode) {
            this._nonClientRuleEntry.addMatchingStyle(propertyString, styleNode);
        }

        public void addStyle(String clientRule, String propertyString, StyleNode styleNode) {
            MatchingEntry matchingStylesForClientRule = this._clientRuleEntries.get(clientRule);
            if (matchingStylesForClientRule == null) {
                matchingStylesForClientRule = new MatchingEntry(1);
                this._clientRuleEntries.put(clientRule, matchingStylesForClientRule);
            }
            matchingStylesForClientRule.addMatchingStyle(propertyString, styleNode);
        }
    }

    private static class PropertyNodeNameComparator
    implements Comparator<PropertyNode> {
        private static final Comparator<PropertyNode> _INSTANCE = new PropertyNodeNameComparator();

        public static Comparator<PropertyNode> sharedInstance() {
            return _INSTANCE;
        }

        @Override
        public int compare(PropertyNode o1, PropertyNode o2) {
            String name2;
            String name1 = o1 == null ? null : o1.getName();
            String string = name2 = o2 == null ? null : o2.getName();
            if (name1 == null || name2 == null) {
                if (name1 == name2) {
                    return 0;
                }
                if (name1 != null) {
                    return 1;
                }
                return -1;
            }
            return name1.compareTo(name2);
        }

        @Override
        public boolean equals(Object o) {
            return this == o;
        }

        private PropertyNodeNameComparator() {
        }
    }
}

