/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.taglib;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.webapp.UIComponentClassicTagBase;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.JspIdConsumer;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.util.ComponentUtils;
import org.apache.myfaces.trinidad.webapp.TrinidadTagSupport;

public class ForEachTag
extends TrinidadTagSupport
implements JspIdConsumer {
    private String _jspId;
    private ValueExpression _items;
    private ValueExpression _beginVE;
    private ValueExpression _endVE;
    private ValueExpression _stepVE;
    private Integer _begin;
    private Integer _end;
    private Integer _step;
    private IterationUtils _iterationUtils;
    private IterationStatus _currentIterationStatus;
    private ItemsWrapper _itemsWrapper;
    private String _var;
    private String _varStatus;
    private Object _previousPageContextVarValue;
    private Object _previousPageContextVarStatusValue;
    private ValueExpression _previousVarExpression;
    private ValueExpression _previousVarStatusExpression;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ForEachTag.class);

    public ForEachTag() {
        _LOG.finest("ForEachTag instance created");
    }

    public void setItems(ValueExpression items) {
        if (items.isLiteralText()) {
            throw new IllegalArgumentException(_LOG.getMessage("MUST_BE_SIMPLE_JSF_EL_EXPRESSION"));
        }
        this._items = items;
    }

    public void setBegin(ValueExpression begin) {
        this._beginVE = begin;
    }

    public void setEnd(ValueExpression end) {
        this._endVE = end;
    }

    public void setStep(ValueExpression step) {
        this._stepVE = step;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setVarStatus(String varStatus) {
        this._varStatus = varStatus;
    }

    public void setJspId(String id) {
        _LOG.finest("setJspId called with ID {0}", (Object)id);
        this._jspId = id;
    }

    public int doStartTag() throws JspException {
        int step;
        int end;
        int begin;
        _LOG.finest("doStartTag called for tag with ID {0}", (Object)this._jspId);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this._parseTagAttributeExpressions(facesContext);
        this._validateAttributes();
        int n = begin = this._begin == null ? 0 : this._begin;
        if (null != this._items) {
            Object items = this._items.getValue(facesContext.getELContext());
            if (items == null) {
                _LOG.fine("Items expression {0} resolved to null.", (Object)this._items);
                return 0;
            }
            this._itemsWrapper = ForEachTag._buildItemsWrapper(items);
            int length = this._itemsWrapper.getSize();
            if (length == 0) {
                _LOG.fine("Items found at {0} is empty.", (Object)this._items);
                return 0;
            }
            if (length < begin) {
                _LOG.fine("Size of 'items' is less than 'begin'");
                return 0;
            }
            int n2 = end = this._end == null ? length - 1 : this._end;
            if (length <= end) {
                end = length - 1;
            }
        } else {
            int n3 = end = this._end == null ? 0 : this._end;
        }
        if (end < begin) {
            return 0;
        }
        int n4 = step = this._step == null ? 1 : this._step;
        if (begin < 0) {
            throw new JspTagException("'begin' < 0");
        }
        if (step < 1) {
            throw new JspTagException("'step' < 1");
        }
        if (step != 1) {
            int count = (int)Math.floor((double)(end - begin) / (double)step + 1.0);
            end = (count - 1) * step + begin;
        }
        this._currentIterationStatus = new IterationStatus(ForEachTag._getIterationKey(this._itemsWrapper, begin), true, begin == end, begin, 1, begin, end, step);
        VariableMapper vm = this.pageContext.getELContext().getVariableMapper();
        this._backupContextVariables(vm);
        if (this._varStatus != null) {
            if (this._iterationUtils == null) {
                this._iterationUtils = new IterationUtils(facesContext, this._getParentComponentScopedId(facesContext), this._jspId);
            }
            CleanupPhaseListener.installListener(facesContext);
            this._iterationUtils.beginIteration(this._currentIterationStatus);
        }
        this._updateVars(vm);
        if (_LOG.isFiner()) {
            _LOG.finer("Initial iteration status: {0}", new Object[]{this._currentIterationStatus});
        }
        return 1;
    }

    public int doAfterBody() {
        if (_LOG.isFinest()) {
            if (this._varStatus == null) {
                _LOG.finest("doAfterBody processing for tag {0}", (Object)this._jspId);
            } else {
                _LOG.finest("doAfterBody processing for iteration ID {0}", (Object)this._iterationUtils.getCurrentIterationId());
            }
        }
        if (this._iterationUtils != null) {
            this._iterationUtils.endIteration();
        }
        this._currentIterationStatus = this._currentIterationStatus.next(this._itemsWrapper);
        VariableMapper vm = this.pageContext.getELContext().getVariableMapper();
        if (this._currentIterationStatus == null) {
            this._restoreContextVariables(vm);
            return 0;
        }
        if (this._iterationUtils != null) {
            this._iterationUtils.beginIteration(this._currentIterationStatus);
        }
        this._updateVars(vm);
        return 2;
    }

    public void release() {
        super.release();
        this._begin = null;
        this._end = null;
        this._step = null;
        this._items = null;
        this._var = null;
        this._varStatus = null;
        this._iterationUtils = null;
        this._previousVarExpression = null;
        this._previousVarStatusExpression = null;
        this._currentIterationStatus = null;
        this._itemsWrapper = null;
        _LOG.finest("release called");
    }

    private void _restoreContextVariables(VariableMapper vm) {
        if (this._var != null) {
            vm.setVariable(this._var, this._previousVarExpression);
            this.pageContext.setAttribute(this._var, this._previousPageContextVarValue);
        }
        if (this._varStatus != null) {
            vm.setVariable(this._varStatus, this._previousVarStatusExpression);
            this.pageContext.setAttribute(this._varStatus, this._previousPageContextVarStatusValue);
        }
    }

    private void _backupContextVariables(VariableMapper vm) {
        if (this._var != null) {
            this._previousVarExpression = vm.resolveVariable(this._var);
            this._previousPageContextVarValue = this.pageContext.getAttribute(this._var);
        }
        if (this._varStatus != null) {
            this._previousVarStatusExpression = vm.resolveVariable(this._varStatus);
            this._previousPageContextVarStatusValue = this.pageContext.getAttribute(this._varStatus);
        }
    }

    private void _updateVars(VariableMapper vm) {
        if (this._var != null) {
            if (this._items != null) {
                KeyedValueExpression keyExpr = new KeyedValueExpression(this._items, this._currentIterationStatus.getKey());
                vm.setVariable(this._var, (ValueExpression)keyExpr);
            }
            if (this._itemsWrapper != null) {
                Object item = this._itemsWrapper.getValue(this._currentIterationStatus.getIndex());
                this.pageContext.setAttribute(this._var, item);
            }
        }
        if (this._varStatus != null) {
            vm.setVariable(this._varStatus, (ValueExpression)new VarStatusValueExpression(this._iterationUtils.getCurrentIterationId()));
            this.pageContext.setAttribute(this._varStatus, (Object)this._currentIterationStatus);
        }
    }

    private Integer _evaluateInteger(FacesContext context, ValueExpression ve) {
        if (ve == null) {
            return null;
        }
        Object val = ve.getValue(context.getELContext());
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        return null;
    }

    private void _parseTagAttributeExpressions(FacesContext facesContext) {
        this._end = this._evaluateInteger(facesContext, this._endVE);
        this._begin = this._evaluateInteger(facesContext, this._beginVE);
        this._step = this._evaluateInteger(facesContext, this._stepVE);
    }

    private void _validateAttributes() throws JspTagException {
        if (null == this._items && (null == this._begin || null == this._end)) {
            throw new JspTagException("'begin' and 'end' should be specified if 'items' is not specified");
        }
        if (this._var != null && this._var.equals(this._varStatus)) {
            throw new JspTagException("'var' and 'varStatus' should not have the same value");
        }
    }

    private String _getParentComponentScopedId(FacesContext facesContext) {
        UIComponentClassicTagBase tag = UIComponentClassicTagBase.getParentUIComponentClassicTagBase((PageContext)this.pageContext);
        UIComponent parentComponent = tag == null ? null : tag.getComponentInstance();
        return parentComponent == null ? "" : ComponentUtils.getLogicalScopedIdForComponent((UIComponent)parentComponent, (UIComponent)facesContext.getViewRoot());
    }

    private static Serializable _getIterationKey(ItemsWrapper itemsWrapper, int index) {
        if (itemsWrapper == null) {
            return Integer.valueOf(index);
        }
        Object key = itemsWrapper.getKey(index);
        if (key instanceof Serializable) {
            return (Serializable)key;
        }
        throw new IllegalStateException("The forEach tag only supports serializable keys for maps and collection models. Key does not implement serializable: " + key + " Class: " + (key == null ? "null" : key.getClass().getName()));
    }

    private static ItemsWrapper _buildItemsWrapper(Object items) {
        if (items.getClass().isArray()) {
            return new ArrayWrapper(items);
        }
        if (items instanceof List) {
            return new ListWrapper((List)items);
        }
        if (items instanceof CollectionModel) {
            return new CollectionModelWrapper((CollectionModel)items);
        }
        if (items instanceof Map) {
            return new MapWrapper((Map)items);
        }
        throw new IllegalArgumentException("Illegal items type: " + items.getClass());
    }

    private static class IterationId
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient Integer _cachedHashCode;
        private final List<IterationState> _iterationStates;

        IterationId(Collection<IterationState> iterationStateStack) {
            this._iterationStates = Collections.unmodifiableList(new ArrayList<IterationState>(iterationStateStack));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof IterationId)) {
                return false;
            }
            IterationId other = (IterationId)object;
            if (this.hashCode() != object.hashCode()) {
                return false;
            }
            return this._iterationStates.equals(other._iterationStates);
        }

        public int hashCode() {
            if (this._cachedHashCode == null) {
                this._cachedHashCode = this._iterationStates.hashCode();
            }
            return this._cachedHashCode;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("IterationId[");
            boolean first = true;
            for (IterationState state : this._iterationStates) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" -> ");
                }
                sb.append(state);
            }
            return sb.append(']').toString();
        }
    }

    private static class IterationUtils {
        private final Map<IterationId, IterationStatus> _iterationStatusMap;
        private final Deque<IterationState> _iterationStateQueue;
        private final Set<IterationId> _usedIterationIds;
        private final String _jspId;
        private final String _parentComponentScopedId;
        private IterationId _currentId;
        private static final String _ITERATION_MAP_KEY = IterationUtils.class.getName() + ".ITER";
        private static final String _CURRENT_ITERATION_STATE_QUEUE_KEY = IterationUtils.class.getName() + ".ISQ";
        private static final String _USED_ITER_IDS_KEY = IterationUtils.class.getName() + ".ITER_IDS";

        static Map<IterationId, IterationStatus> getIterationStatusMap(Map<String, Object> viewAttrs, boolean create) {
            HashMap iterationStatusMap = (HashMap)viewAttrs.get(_ITERATION_MAP_KEY);
            if (iterationStatusMap == null && create) {
                iterationStatusMap = new HashMap();
                viewAttrs.put(_ITERATION_MAP_KEY, iterationStatusMap);
            }
            return iterationStatusMap;
        }

        static Set<IterationId> getUsedIterationIds(Map<String, Object> reqMap, boolean create) {
            HashSet usedIterationIds = (HashSet)reqMap.get(_USED_ITER_IDS_KEY);
            if (usedIterationIds == null && create) {
                usedIterationIds = new HashSet();
                reqMap.put(_USED_ITER_IDS_KEY, usedIterationIds);
            }
            return usedIterationIds;
        }

        IterationUtils(FacesContext facesContext, String parentComponentScopedId, String jspId) {
            Map viewAttrs = facesContext.getViewRoot().getAttributes();
            this._iterationStatusMap = IterationUtils.getIterationStatusMap(viewAttrs, true);
            Map reqMap = facesContext.getExternalContext().getRequestMap();
            ArrayDeque queue = (ArrayDeque)reqMap.get(_CURRENT_ITERATION_STATE_QUEUE_KEY);
            if (queue == null) {
                queue = new ArrayDeque(5);
                reqMap.put(_CURRENT_ITERATION_STATE_QUEUE_KEY, queue);
            }
            this._iterationStateQueue = queue;
            this._usedIterationIds = IterationUtils.getUsedIterationIds(reqMap, true);
            this._jspId = jspId;
            this._parentComponentScopedId = parentComponentScopedId;
        }

        IterationId getCurrentIterationId() {
            return this._currentId;
        }

        void beginIteration(IterationStatus iterationStatus) {
            IterationState state = new IterationState(this._parentComponentScopedId, this._jspId, iterationStatus.getKey());
            this._iterationStateQueue.offerLast(state);
            this._currentId = new IterationId(this._iterationStateQueue);
            this._iterationStatusMap.put(this._currentId, iterationStatus);
            this._usedIterationIds.add(this._currentId);
            _LOG.finest("Iteration begun with ID {0}", (Object)this._currentId);
        }

        void endIteration() {
            _LOG.finest("Iteration ended with ID {0}", (Object)this._currentId);
            this._currentId = null;
            this._iterationStateQueue.removeLast();
        }
    }

    public static class CleanupPhaseListener
    implements PhaseListener {
        private static final long serialVersionUID = 1L;
        private static final String _PL_KEY = CleanupPhaseListener.class.getName();

        static void installListener(FacesContext facesContext) {
            UIViewRoot viewRoot = facesContext.getViewRoot();
            Map viewAttrs = viewRoot.getAttributes();
            if (!viewAttrs.containsKey(_PL_KEY)) {
                CleanupPhaseListener newPhaseListener = new CleanupPhaseListener();
                viewRoot.addPhaseListener((PhaseListener)newPhaseListener);
                viewAttrs.put(_PL_KEY, Boolean.TRUE);
                _LOG.finer("Cleanup phase listener has been installed");
            } else {
                _LOG.finest("Cleanup phase listener has already been installed on the current view");
            }
        }

        public void afterPhase(PhaseEvent event) {
        }

        public void beforePhase(PhaseEvent event) {
            _LOG.finest("Running the iteration status cleanup code");
            RequestContext requestContext = RequestContext.getCurrentInstance();
            if (requestContext.getTagExecutionStatus() == RequestContext.TagExecution.NONE) {
                _LOG.finest("Tag execution is not being run, avoiding cleanup");
                return;
            }
            FacesContext facesContext = event.getFacesContext();
            UIViewRoot viewRoot = facesContext.getViewRoot();
            Map viewAttrs = viewRoot.getAttributes();
            Set<IterationId> usedIterationIds = IterationUtils.getUsedIterationIds(facesContext.getExternalContext().getRequestMap(), false);
            Map<IterationId, IterationStatus> iterStatusMap = IterationUtils.getIterationStatusMap(viewAttrs, false);
            if (iterStatusMap != null) {
                if (_LOG.isFinest()) {
                    if (usedIterationIds == null) {
                        _LOG.finest("No used iteration IDs, all iteration data will be removed");
                    } else {
                        HashSet<IterationId> removeIds = new HashSet<IterationId>(iterStatusMap.keySet());
                        removeIds.removeAll(usedIterationIds);
                        if (removeIds.size() > 0) {
                            StringBuilder sb = new StringBuilder();
                            for (IterationId id : removeIds) {
                                if (sb.length() > 0) {
                                    sb.append(", ");
                                }
                                sb.append(id);
                            }
                            _LOG.finest("Removing {0} iteration IDs. IDs: {1}", new Object[]{removeIds.size(), sb});
                        } else {
                            _LOG.finest("No iteration IDs to remove");
                        }
                    }
                }
                int size = iterStatusMap.size();
                if (usedIterationIds == null) {
                    iterStatusMap.clear();
                    _LOG.finer("All {0} iteration IDs have been removed", (Object)size);
                } else if (iterStatusMap.keySet().retainAll(usedIterationIds)) {
                    if (_LOG.isFiner()) {
                        _LOG.finer("Iteration IDs have been removed. Previous count: {0}, current count: {1}", new Object[]{size, iterStatusMap.size()});
                    }
                } else {
                    _LOG.finer("No iteration IDs were removed this request");
                }
            }
        }

        public PhaseId getPhaseId() {
            return PhaseId.RENDER_RESPONSE;
        }
    }

    public static class IterationStatus
    implements Serializable {
        private static final long serialVersionUID = 2L;
        private final boolean _last;
        private final boolean _first;
        private final int _begin;
        private final int _count;
        private final int _index;
        private final int _end;
        private final int _step;
        private final Serializable _key;

        private IterationStatus(Serializable key, boolean first, boolean last, int begin, int count, int index, int end, int step) {
            this._key = key;
            this._first = first;
            this._last = last;
            this._begin = begin;
            this._count = count;
            this._index = index;
            this._end = end;
            this._step = step;
        }

        public final boolean isLast() {
            return this._last;
        }

        public final boolean isFirst() {
            return this._first;
        }

        public final int getIndex() {
            return this._index;
        }

        public final int getCount() {
            return this._count;
        }

        public final int getBegin() {
            return this._begin;
        }

        public final int getEnd() {
            return this._end;
        }

        public final Serializable getKey() {
            return this._key;
        }

        public final int getStep() {
            return this._step;
        }

        public String toString() {
            return String.format("IterationStatus[key: %s, index: %d, count: %d, first: %s, last: %s, begin: %d, end: %d, step: %d]", this._key, this._index, this._count, this._first, this._last, this._begin, this._end, this._step);
        }

        IterationStatus next(ItemsWrapper itemsWrapper) {
            int nextIndex = this._index + this._step;
            if (nextIndex > this._end) {
                return null;
            }
            return new IterationStatus(ForEachTag._getIterationKey(itemsWrapper, nextIndex), false, nextIndex == this._end, this._begin, this._count + 1, nextIndex, this._end, this._step);
        }
    }

    public static final class IterationState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String _scopedId;
        private final String _jspId;
        private final Serializable _key;

        public IterationState(String parentComponentScopedId, String jspId, Serializable key) {
            this._scopedId = parentComponentScopedId;
            this._jspId = jspId;
            this._key = key;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof IterationState)) {
                return false;
            }
            IterationState other = (IterationState)object;
            if (!(this._scopedId != null ? this._scopedId.equals(other._scopedId) : other._scopedId == null)) {
                return false;
            }
            if (!(this._jspId != null ? this._jspId.equals(other._jspId) : other._jspId == null)) {
                return false;
            }
            return this._key != null ? this._key.equals(other._key) : other._key == null;
        }

        public int hashCode() {
            int PRIME = 37;
            int result = 1;
            result = 37 * result + (this._scopedId == null ? 0 : this._scopedId.hashCode());
            result = 37 * result + (this._jspId == null ? 0 : this._jspId.hashCode());
            result = 37 * result + (this._key == null ? 0 : this._key.hashCode());
            return result;
        }

        public String getScopedId() {
            return this._scopedId;
        }

        public String getJspId() {
            return this._jspId;
        }

        public Serializable getKey() {
            return this._key;
        }

        public String toString() {
            return String.format("IterationState[Scoped ID: %s, JSP ID: %s, Key: %s]", this._scopedId, this._jspId, this._key);
        }
    }

    private static class ArrayWrapper
    extends ItemsWrapper {
        private final Object _array;

        private ArrayWrapper(Object array) {
            this._array = array;
        }

        @Override
        public Object getKey(int index) {
            return index;
        }

        @Override
        public Object getValue(int index) {
            return Array.get(this._array, index);
        }

        @Override
        public int getSize() {
            return Array.getLength(this._array);
        }
    }

    private static class ListWrapper
    extends ItemsWrapper {
        private final List<?> _list;

        private ListWrapper(List<?> list) {
            this._list = list;
        }

        @Override
        public Object getKey(int index) {
            return index;
        }

        @Override
        public Object getValue(int index) {
            return this._list.get(index);
        }

        @Override
        public int getSize() {
            return this._list.size();
        }
    }

    private static class MapWrapper
    extends ItemsWrapper {
        private final Map<?, ?> _map;
        private Iterator<? extends Map.Entry<?, ?>> _iter;
        private Map.Entry<?, ?> _currentEntry;
        private int _currentIndex = -1;

        private MapWrapper(Map<?, ?> map) {
            this._map = map;
        }

        @Override
        public Object getKey(int index) {
            this._moveToIndex(index);
            return this._currentEntry.getKey();
        }

        @Override
        public Object getValue(int index) {
            this._moveToIndex(index);
            return this._currentEntry.getValue();
        }

        @Override
        public int getSize() {
            return this._map.size();
        }

        private void _moveToIndex(int index) {
            if (index == this._currentIndex) {
                return;
            }
            if (this._iter == null || index < this._currentIndex) {
                this._iter = this._map.entrySet().iterator();
                this._currentIndex = -1;
            }
            for (int i = this._currentIndex; i < index; ++i) {
                this._currentEntry = this._iter.next();
            }
            this._currentIndex = index;
        }
    }

    private static class CollectionModelWrapper
    extends ItemsWrapper {
        private CollectionModel _collectionModel;

        private CollectionModelWrapper(CollectionModel collectionModel) {
            this._collectionModel = collectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getKey(int index) {
            Object oldRowKey = this._collectionModel.getRowKey();
            try {
                this._collectionModel.setRowIndex(index);
                Object object = this._collectionModel.getRowKey();
                return object;
            }
            finally {
                this._collectionModel.setRowKey(oldRowKey);
            }
        }

        @Override
        public Object getValue(int index) {
            return this._collectionModel.getRowData(index);
        }

        @Override
        public int getSize() {
            return this._collectionModel.getRowCount();
        }
    }

    private static abstract class ItemsWrapper {
        private ItemsWrapper() {
        }

        public abstract Object getKey(int var1);

        public abstract Object getValue(int var1);

        public abstract int getSize();
    }

    private static class VarStatusValueExpression
    extends ValueExpression
    implements Serializable {
        private static final long serialVersionUID = 4L;
        private final IterationId _iterationId;

        private VarStatusValueExpression(IterationId iterationId) {
            this._iterationId = iterationId;
        }

        public Object getValue(ELContext context) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            assert (facesContext != null) : "Illegal attempt to evaluate for each EL outside of an active faces context";
            UIViewRoot viewRoot = facesContext.getViewRoot();
            assert (viewRoot != null) : "Illegal attempt to evaluate for each EL outside of an active view root";
            IterationStatus status = null;
            Map<IterationId, IterationStatus> map = IterationUtils.getIterationStatusMap(viewRoot.getAttributes(), false);
            if (map != null) {
                status = map.get(this._iterationId);
            }
            if (status == null) {
                _LOG.warning("FOR_EACH_STATUS_UNAVAILABLE");
                return null;
            }
            return status;
        }

        public Class getExpectedType() {
            return IterationStatus.class;
        }

        public void setValue(ELContext context, Object value) {
            throw new UnsupportedOperationException();
        }

        public boolean isReadOnly(ELContext context) {
            return true;
        }

        public Class<?> getType(ELContext context) {
            return IterationStatus.class;
        }

        public String getExpressionString() {
            return null;
        }

        public boolean equals(Object obj) {
            if (obj instanceof VarStatusValueExpression) {
                VarStatusValueExpression vsve = (VarStatusValueExpression)obj;
                return this._iterationId == vsve._iterationId;
            }
            return false;
        }

        public int hashCode() {
            return this._iterationId.hashCode();
        }

        public boolean isLiteralText() {
            return false;
        }
    }

    private static class KeyedValueExpression
    extends ValueExpression {
        private final ValueExpression _itemsExpression;
        private final Serializable _key;
        private static final long serialVersionUID = 1L;

        private KeyedValueExpression(ValueExpression itemsExpression, Serializable key) {
            this._itemsExpression = itemsExpression;
            this._key = key;
        }

        public Object getValue(ELContext context) {
            Object items = this._itemsExpression.getValue(context);
            if (items == null) {
                return null;
            }
            if (items instanceof CollectionModel) {
                CollectionModel model = (CollectionModel)items;
                return model.getRowData((Object)this._key);
            }
            context.setPropertyResolved(false);
            return context.getELResolver().getValue(context, items, (Object)this._key);
        }

        public void setValue(ELContext context, Object value) {
            Object items = this._itemsExpression.getValue(context);
            if (items != null) {
                if (items instanceof CollectionModel) {
                    throw new PropertyNotWritableException();
                }
                context.setPropertyResolved(false);
                context.getELResolver().setValue(context, items, (Object)this._key, value);
            }
        }

        public boolean isReadOnly(ELContext context) {
            Object items = this._itemsExpression.getValue(context);
            if (items == null) {
                return true;
            }
            if (items instanceof CollectionModel) {
                return true;
            }
            return context.getELResolver().isReadOnly(context, items, (Object)this._key);
        }

        public Class<?> getType(ELContext context) {
            return null;
        }

        public Class<?> getExpectedType() {
            return Object.class;
        }

        public String getExpressionString() {
            return this._itemsExpression.getExpressionString();
        }

        public boolean isLiteralText() {
            return false;
        }

        public int hashCode() {
            return this._itemsExpression.hashCode();
        }

        public boolean equals(Object obj) {
            return this._itemsExpression.equals(obj);
        }
    }
}

