/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.expression;

import v14.h2.expression.ValueExpression;
import v14.h2.value.TypeInfo;
import v14.h2.value.Value;
import v14.h2.value.ValueNull;

public class TypedValueExpression
extends ValueExpression {
    private static final Object UNKNOWN = new TypedValueExpression(ValueNull.INSTANCE, TypeInfo.TYPE_BOOLEAN);
    private final TypeInfo type;

    public static TypedValueExpression get(Value value, TypeInfo typeInfo) {
        if (value == ValueNull.INSTANCE && typeInfo.getValueType() == 1) {
            return TypedValueExpression.getUnknown();
        }
        return new TypedValueExpression(value, typeInfo);
    }

    public static TypedValueExpression getUnknown() {
        return (TypedValueExpression)UNKNOWN;
    }

    private TypedValueExpression(Value value, TypeInfo typeInfo) {
        super(value);
        this.type = typeInfo;
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        if (this == UNKNOWN) {
            stringBuilder.append("UNKNOWN");
        } else {
            this.value.getSQL(stringBuilder.append("CAST(")).append(" AS ");
            this.type.getSQL(stringBuilder).append(')');
        }
        return stringBuilder;
    }

    @Override
    public boolean isNullConstant() {
        return this.value == ValueNull.INSTANCE;
    }
}

