/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi.impl;

import java.io.IOException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.RequestConfig;
import org.apache.nifi.toolkit.cli.impl.client.nifi.TenantsClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.AbstractJerseyClient;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.web.api.entity.UserEntity;
import org.apache.nifi.web.api.entity.UserGroupEntity;
import org.apache.nifi.web.api.entity.UserGroupsEntity;
import org.apache.nifi.web.api.entity.UsersEntity;

public class JerseyTenantsClient
extends AbstractJerseyClient
implements TenantsClient {
    private final WebTarget tenantsTarget;

    public JerseyTenantsClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyTenantsClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(requestConfig);
        this.tenantsTarget = baseTarget.path("/tenants");
    }

    @Override
    public UsersEntity getUsers() throws NiFiClientException, IOException {
        return this.executeAction("Error retrieving users", () -> {
            WebTarget target = this.tenantsTarget.path("users");
            return (UsersEntity)this.getRequestBuilder(target).get(UsersEntity.class);
        });
    }

    @Override
    public UserEntity createUser(UserEntity userEntity) throws NiFiClientException, IOException {
        if (userEntity == null) {
            throw new IllegalArgumentException("User entity cannot be null");
        }
        return this.executeAction("Error creating user", () -> {
            WebTarget target = this.tenantsTarget.path("users");
            return (UserEntity)this.getRequestBuilder(target).post(Entity.entity((Object)userEntity, (String)"application/json"), UserEntity.class);
        });
    }

    @Override
    public UserGroupEntity getUserGroup(String id) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("User group id cannot be null");
        }
        return this.executeAction("Error retrieving user group", () -> {
            WebTarget target = this.tenantsTarget.path("user-groups/{id}").resolveTemplate("id", (Object)id);
            return (UserGroupEntity)this.getRequestBuilder(target).get(UserGroupEntity.class);
        });
    }

    @Override
    public UserGroupsEntity getUserGroups() throws NiFiClientException, IOException {
        return this.executeAction("Error retrieving user groups", () -> {
            WebTarget target = this.tenantsTarget.path("user-groups");
            return (UserGroupsEntity)this.getRequestBuilder(target).get(UserGroupsEntity.class);
        });
    }

    @Override
    public UserGroupEntity createUserGroup(UserGroupEntity userGroupEntity) throws NiFiClientException, IOException {
        if (userGroupEntity == null) {
            throw new IllegalArgumentException("User group entity cannot be null");
        }
        return this.executeAction("Error creating user group", () -> {
            WebTarget target = this.tenantsTarget.path("user-groups");
            return (UserGroupEntity)this.getRequestBuilder(target).post(Entity.entity((Object)userGroupEntity, (String)"application/json"), UserGroupEntity.class);
        });
    }

    @Override
    public UserGroupEntity updateUserGroup(UserGroupEntity userGroupEntity) throws NiFiClientException, IOException {
        if (userGroupEntity == null) {
            throw new IllegalArgumentException("User group entity cannot be null");
        }
        if (StringUtils.isBlank((String)userGroupEntity.getId())) {
            throw new IllegalArgumentException("User group entity must contain an id");
        }
        return this.executeAction("Error updating user group", () -> {
            WebTarget target = this.tenantsTarget.path("user-groups/{id}").resolveTemplate("id", (Object)userGroupEntity.getId());
            return (UserGroupEntity)this.getRequestBuilder(target).put(Entity.entity((Object)userGroupEntity, (String)"application/json"), UserGroupEntity.class);
        });
    }
}

