/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.log.ByteIterableWithAddress;
import jetbrains.exodus.log.Loggable;
import jetbrains.exodus.log.RandomAccessLoggableImpl;
import org.jetbrains.annotations.NotNull;

public final class NullLoggable
extends RandomAccessLoggableImpl {
    public static final byte TYPE = 0;
    private static final NullLoggable PROTOTYPE = new NullLoggable(-1L);

    NullLoggable(long address) {
        super(address, (byte)0, ByteIterableWithAddress.getEmpty(address + 1L), 0, 0);
    }

    public static NullLoggable create() {
        return PROTOTYPE;
    }

    @Override
    public long getAddress() {
        return -1L;
    }

    public static boolean isNullLoggable(byte type) {
        return type == 0;
    }

    public static boolean isNullLoggable(@NotNull Loggable loggable) {
        return NullLoggable.isNullLoggable(loggable.getType());
    }
}

