/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.javaspi.text;

import com.ibm.icu.impl.javaspi.ICULocaleServiceProvider;
import com.ibm.icu.impl.jdkadapter.DecimalFormatICU;
import com.ibm.icu.impl.jdkadapter.NumberFormatICU;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import java.text.spi.NumberFormatProvider;
import java.util.Locale;

public class NumberFormatProviderICU
extends NumberFormatProvider {
    private static final int NUMBER = 0;
    private static final int INTEGER = 1;
    private static final int CURRENCY = 2;
    private static final int PERCENT = 3;

    @Override
    public java.text.NumberFormat getCurrencyInstance(Locale locale) {
        return this.getInstance(2, locale);
    }

    @Override
    public java.text.NumberFormat getIntegerInstance(Locale locale) {
        return this.getInstance(1, locale);
    }

    @Override
    public java.text.NumberFormat getNumberInstance(Locale locale) {
        return this.getInstance(0, locale);
    }

    @Override
    public java.text.NumberFormat getPercentInstance(Locale locale) {
        return this.getInstance(3, locale);
    }

    @Override
    public Locale[] getAvailableLocales() {
        return ICULocaleServiceProvider.getAvailableLocales();
    }

    private java.text.NumberFormat getInstance(int type, Locale locale) {
        NumberFormat icuNfmt;
        ULocale actual = ICULocaleServiceProvider.toULocaleNoSpecialVariant(locale);
        switch (type) {
            case 0: {
                icuNfmt = NumberFormat.getNumberInstance(actual);
                break;
            }
            case 1: {
                icuNfmt = NumberFormat.getIntegerInstance(actual);
                break;
            }
            case 2: {
                icuNfmt = NumberFormat.getCurrencyInstance(actual);
                break;
            }
            case 3: {
                icuNfmt = NumberFormat.getPercentInstance(actual);
                break;
            }
            default: {
                return null;
            }
        }
        if (!(icuNfmt instanceof DecimalFormat)) {
            return null;
        }
        java.text.NumberFormat nf = null;
        nf = ICULocaleServiceProvider.useDecimalFormat() ? DecimalFormatICU.wrap((DecimalFormat)icuNfmt) : NumberFormatICU.wrap(icuNfmt);
        return nf;
    }
}

