/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number;

import com.ibm.icu.impl.CurrencyData;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.SimpleFormatterImpl;
import com.ibm.icu.impl.StandardPlural;
import com.ibm.icu.impl.UResource;
import com.ibm.icu.impl.number.DecimalQuantity;
import com.ibm.icu.impl.number.MicroProps;
import com.ibm.icu.impl.number.MicroPropsGenerator;
import com.ibm.icu.impl.number.SimpleModifier;
import com.ibm.icu.number.NumberFormatter;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.ICUException;
import com.ibm.icu.util.MeasureUnit;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.util.EnumMap;
import java.util.Map;

public class LongNameHandler
implements MicroPropsGenerator {
    private final Map<StandardPlural, SimpleModifier> modifiers;
    private final PluralRules rules;
    private final MicroPropsGenerator parent;

    private static void getMeasureData(ULocale locale, MeasureUnit unit, NumberFormatter.UnitWidth width, Map<StandardPlural, String> output) {
        PluralTableSink sink = new PluralTableSink(output);
        ICUResourceBundle resource = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt60b/unit", locale);
        StringBuilder key = new StringBuilder();
        key.append("units");
        if (width == NumberFormatter.UnitWidth.NARROW) {
            key.append("Narrow");
        } else if (width == NumberFormatter.UnitWidth.SHORT) {
            key.append("Short");
        }
        key.append("/");
        key.append(unit.getType());
        key.append("/");
        key.append(unit.getSubtype());
        resource.getAllItemsWithFallback(key.toString(), sink);
    }

    private static void getCurrencyLongNameData(ULocale locale, Currency currency, Map<StandardPlural, String> output) {
        Map<String, String> data = CurrencyData.provider.getInstance(locale, true).getUnitPatterns();
        for (Map.Entry<String, String> e : data.entrySet()) {
            String pluralKeyword = e.getKey();
            StandardPlural plural = StandardPlural.fromString(e.getKey());
            String longName = currency.getName(locale, 2, pluralKeyword, null);
            String simpleFormat = e.getValue();
            simpleFormat = simpleFormat.replace("{1}", longName);
            output.put(plural, simpleFormat);
        }
    }

    private LongNameHandler(Map<StandardPlural, SimpleModifier> modifiers, PluralRules rules, MicroPropsGenerator parent) {
        this.modifiers = modifiers;
        this.rules = rules;
        this.parent = parent;
    }

    public static LongNameHandler forCurrencyLongNames(ULocale locale, Currency currency, PluralRules rules, MicroPropsGenerator parent) {
        EnumMap<StandardPlural, String> simpleFormats = new EnumMap<StandardPlural, String>(StandardPlural.class);
        LongNameHandler.getCurrencyLongNameData(locale, currency, simpleFormats);
        EnumMap<StandardPlural, SimpleModifier> modifiers = new EnumMap<StandardPlural, SimpleModifier>(StandardPlural.class);
        LongNameHandler.simpleFormatsToModifiers(simpleFormats, null, modifiers);
        return new LongNameHandler(modifiers, rules, parent);
    }

    public static LongNameHandler forMeasureUnit(ULocale locale, MeasureUnit unit, NumberFormatter.UnitWidth width, PluralRules rules, MicroPropsGenerator parent) {
        EnumMap<StandardPlural, String> simpleFormats = new EnumMap<StandardPlural, String>(StandardPlural.class);
        LongNameHandler.getMeasureData(locale, unit, width, simpleFormats);
        EnumMap<StandardPlural, SimpleModifier> modifiers = new EnumMap<StandardPlural, SimpleModifier>(StandardPlural.class);
        LongNameHandler.simpleFormatsToModifiers(simpleFormats, null, modifiers);
        return new LongNameHandler(modifiers, rules, parent);
    }

    private static void simpleFormatsToModifiers(Map<StandardPlural, String> simpleFormats, NumberFormat.Field field, Map<StandardPlural, SimpleModifier> output) {
        StringBuilder sb = new StringBuilder();
        for (StandardPlural plural : StandardPlural.VALUES) {
            String simpleFormat = simpleFormats.get((Object)plural);
            if (simpleFormat == null) {
                simpleFormat = simpleFormats.get((Object)StandardPlural.OTHER);
            }
            if (simpleFormat == null) {
                throw new ICUException("Could not find data in 'other' plural variant with field " + field);
            }
            String compiled = SimpleFormatterImpl.compileToStringMinMaxArguments(simpleFormat, sb, 1, 1);
            output.put(plural, new SimpleModifier(compiled, null, false));
        }
    }

    @Override
    public MicroProps processQuantity(DecimalQuantity quantity) {
        MicroProps micros = this.parent.processQuantity(quantity);
        DecimalQuantity copy = quantity.createCopy();
        micros.rounding.apply(copy);
        micros.modOuter = this.modifiers.get((Object)copy.getStandardPlural(this.rules));
        return micros;
    }

    private static final class PluralTableSink
    extends UResource.Sink {
        Map<StandardPlural, String> output;

        public PluralTableSink(Map<StandardPlural, String> output) {
            this.output = output;
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean noFallback) {
            UResource.Table pluralsTable = value.getTable();
            int i = 0;
            while (pluralsTable.getKeyAndValue(i, key, value)) {
                StandardPlural plural;
                if (!(key.contentEquals("dnam") || key.contentEquals("per") || this.output.containsKey((Object)(plural = StandardPlural.fromString(key))))) {
                    String formatString = value.getString();
                    this.output.put(plural, formatString);
                }
                ++i;
            }
        }
    }
}

