/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.transaction;

import java.io.IOException;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.CompactorScanner;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.RegionConnectionFactory;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.omid.HBaseShims;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.committable.hbase.HBaseCommitTable;
import org.apache.omid.committable.hbase.HBaseCommitTableConfig;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmidCompactor
extends BaseRegionObserver {
    private static final Logger LOG = LoggerFactory.getLogger(OmidCompactor.class);
    private static final String HBASE_RETAIN_NON_TRANSACTIONALLY_DELETED_CELLS_KEY = "omid.hbase.compactor.retain.tombstones";
    private static final boolean HBASE_RETAIN_NON_TRANSACTIONALLY_DELETED_CELLS_DEFAULT = true;
    static final String OMID_COMPACTABLE_CF_FLAG = "OMID_ENABLED";
    private boolean enableCompactorForAllFamilies = false;
    private HBaseCommitTableConfig commitTableConf = null;
    private RegionCoprocessorEnvironment env = null;
    @VisibleForTesting
    CommitTable.Client commitTableClient;
    private boolean retainNonTransactionallyDeletedCells;
    private Connection connection;

    public OmidCompactor() {
        this(false);
    }

    public OmidCompactor(boolean enableCompactorForAllFamilies) {
        LOG.info("Compactor coprocessor initialized");
        this.enableCompactorForAllFamilies = enableCompactorForAllFamilies;
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        LOG.info("Starting compactor coprocessor");
        this.commitTableConf = new HBaseCommitTableConfig();
        String commitTableName = env.getConfiguration().get("omid.committable.tablename");
        if (commitTableName != null) {
            this.commitTableConf.setTableName(commitTableName);
        }
        this.connection = RegionConnectionFactory.getConnection(RegionConnectionFactory.ConnectionType.COMPACTION_CONNECTION, (RegionCoprocessorEnvironment)env);
        this.commitTableClient = new HBaseCommitTable(this.connection, this.commitTableConf).getClient();
        this.retainNonTransactionallyDeletedCells = env.getConfiguration().getBoolean(HBASE_RETAIN_NON_TRANSACTIONALLY_DELETED_CELLS_KEY, true);
        LOG.info("Compactor coprocessor started");
    }

    public void stop(CoprocessorEnvironment e) throws IOException {
        LOG.info("Stopping compactor coprocessor");
        LOG.info("Compactor coprocessor stopped");
    }

    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> env, Store store, InternalScanner scanner, ScanType scanType, CompactionRequest request) throws IOException {
        try {
            boolean omidCompactable = this.enableCompactorForAllFamilies ? true : HBaseShims.OmidCompactionEnabled(env, store, OMID_COMPACTABLE_CF_FLAG);
            if (!omidCompactable) {
                return scanner;
            }
            boolean isMajorCompaction = request.isMajor();
            return new CompactorScanner(env, scanner, this.commitTableClient, isMajorCompaction, this.retainNonTransactionallyDeletedCells);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DoNotRetryIOException((Throwable)e);
        }
    }
}

