/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;

public abstract class KeyValueBuilder {
    public static void addQuietly(Mutation m, KeyValue kv) {
        byte[] family = CellUtil.cloneFamily((Cell)kv);
        ArrayList<KeyValue> list = (ArrayList<KeyValue>)m.getFamilyCellMap().get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>();
            m.getFamilyCellMap().put(family, list);
        }
        list.add(kv);
    }

    public static void deleteQuietly(Delete delete, KeyValueBuilder builder, KeyValue kv) {
        try {
            delete.addDeleteMarker((Cell)kv);
        }
        catch (IOException e) {
            throw new RuntimeException("KeyValue Builder " + builder + " created an invalid kv: " + kv + "!");
        }
    }

    public static KeyValueBuilder get(String hbaseVersion) {
        return GenericKeyValueBuilder.INSTANCE;
    }

    public KeyValue buildPut(ImmutableBytesWritable row, ImmutableBytesWritable family, ImmutableBytesWritable qualifier, ImmutableBytesWritable value) {
        return this.buildPut(row, family, qualifier, Long.MAX_VALUE, value);
    }

    public abstract KeyValue buildPut(ImmutableBytesWritable var1, ImmutableBytesWritable var2, ImmutableBytesWritable var3, long var4, ImmutableBytesWritable var6);

    public KeyValue buildDeleteFamily(ImmutableBytesWritable row, ImmutableBytesWritable family, ImmutableBytesWritable qualifier) {
        return this.buildDeleteFamily(row, family, qualifier, Long.MAX_VALUE);
    }

    public abstract KeyValue buildDeleteFamily(ImmutableBytesWritable var1, ImmutableBytesWritable var2, ImmutableBytesWritable var3, long var4);

    public KeyValue buildDeleteColumns(ImmutableBytesWritable row, ImmutableBytesWritable family, ImmutableBytesWritable qualifier) {
        return this.buildDeleteColumns(row, family, qualifier, Long.MAX_VALUE);
    }

    public abstract KeyValue buildDeleteColumns(ImmutableBytesWritable var1, ImmutableBytesWritable var2, ImmutableBytesWritable var3, long var4);

    public KeyValue buildDeleteColumn(ImmutableBytesWritable row, ImmutableBytesWritable family, ImmutableBytesWritable qualifier) {
        return this.buildDeleteColumn(row, family, qualifier, Long.MAX_VALUE);
    }

    public abstract KeyValue buildDeleteColumn(ImmutableBytesWritable var1, ImmutableBytesWritable var2, ImmutableBytesWritable var3, long var4);

    public abstract int compareQualifier(Cell var1, byte[] var2, int var3, int var4);

    public abstract int compareFamily(Cell var1, byte[] var2, int var3, int var4);

    public abstract int compareRow(Cell var1, byte[] var2, int var3, int var4);

    public abstract void getValueAsPtr(Cell var1, ImmutableBytesWritable var2);

    public abstract KeyValue.KVComparator getKeyValueComparator();

    public abstract List<Mutation> cloneIfNecessary(List<Mutation> var1);
}

