/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.util;

public class VersionUtil {
    private VersionUtil() {
    }

    public static int encodeVersion(String version) {
        String[] versionParts = VersionUtil.splitHBaseVersionString(version);
        return VersionUtil.encodeVersion(versionParts[0], versionParts.length > 1 ? versionParts[1] : null, versionParts.length > 2 ? versionParts[2] : null);
    }

    public static String[] splitHBaseVersionString(String version) {
        return version.split("[-\\.]");
    }

    public static int encodeVersion(String major, String minor, String patch) {
        return VersionUtil.encodeVersion(major == null ? 0 : Integer.parseInt(major), minor == null ? 0 : Integer.parseInt(minor), patch == null ? 0 : Integer.parseInt(patch));
    }

    public static int encodeVersion(int major, int minor, int patch) {
        int version = 0;
        version |= major << 16;
        version |= minor << 8;
        return version |= patch;
    }

    public static int encodeMaxPatchVersion(int major, int minor) {
        int version = 0;
        version |= major << 16;
        version |= minor << 8;
        return version |= 0xFF;
    }

    public static int encodeMinPatchVersion(int major, int minor) {
        int version = 0;
        version |= major << 16;
        return version |= minor << 8;
    }

    public static int encodeMaxMinorVersion(int major) {
        int version = 0;
        version |= major << 16;
        return version |= 0xFFFF;
    }

    public static int encodeMinMinorVersion(int major) {
        int version = 0;
        return version |= major << 16;
    }

    public static int decodeMajorVersion(int encodedVersion) {
        return encodedVersion >> 16;
    }

    public static int decodeMinorVersion(int encodedVersion) {
        return encodedVersion >> 8 & 0xFF;
    }

    public static int decodePatchVersion(int encodedVersion) {
        return encodedVersion & 0xFF;
    }
}

