/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.distributed;

import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.tephra.distributed.ThriftClientProvider;
import org.apache.tephra.distributed.TransactionServiceThriftClient;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.twill.discovery.Discoverable;
import org.apache.twill.discovery.DiscoveryServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientProvider
implements ThriftClientProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClientProvider.class);
    private final DiscoveryServiceClient discoveryServiceClient;
    protected final AtomicBoolean initialized = new AtomicBoolean(false);
    final Configuration configuration;
    EndpointStrategy endpointStrategy;

    protected AbstractClientProvider(Configuration configuration, DiscoveryServiceClient discoveryServiceClient) {
        this.configuration = configuration;
        this.discoveryServiceClient = discoveryServiceClient;
    }

    @Override
    public void initialize() throws TException {
        if (this.initialized.compareAndSet(false, true)) {
            this.initDiscovery();
        }
    }

    private void initDiscovery() {
        if (this.discoveryServiceClient == null) {
            LOG.info("No DiscoveryServiceClient provided. Skipping service discovery.");
            return;
        }
        this.endpointStrategy = new TimeLimitEndpointStrategy(new RandomEndpointStrategy(this.discoveryServiceClient.discover(this.configuration.get("data.tx.discovery.service.name", "transaction"))), this.configuration.getInt("data.tx.client.discovery.timeout", 10), TimeUnit.SECONDS);
    }

    protected TransactionServiceThriftClient newClient() throws TException {
        return this.newClient(-1);
    }

    protected TransactionServiceThriftClient newClient(int timeout) throws TException {
        int port;
        String address;
        this.initialize();
        if (this.endpointStrategy == null) {
            LOG.debug("Reading transaction service address and port from configuration.");
            address = this.configuration.get("data.tx.bind.address", "0.0.0.0");
            port = this.configuration.getInt("data.tx.bind.port", 15165);
            LOG.debug("Transaction service configured at {}:{}.", (Object)address, (Object)port);
        } else {
            Discoverable endpoint = this.endpointStrategy.pick();
            if (endpoint == null) {
                throw new TException("Unable to discover transaction service.");
            }
            address = endpoint.getSocketAddress().getHostName();
            port = endpoint.getSocketAddress().getPort();
            LOG.debug("Transaction service discovered at {}:{}.", (Object)address, (Object)port);
        }
        if (timeout < 0) {
            timeout = this.configuration.getInt("data.tx.client.timeout", 30000);
        }
        LOG.debug("Attempting to connect to transaction service at {}:{} with RPC timeout of {} ms." + address, (Object)port, (Object)timeout);
        TFramedTransport transport = new TFramedTransport(new TSocket(address, port, timeout));
        ((TTransport)transport).open();
        TransactionServiceThriftClient newClient = new TransactionServiceThriftClient(transport);
        LOG.debug("Connected to transaction service at {}:{}.", (Object)address, (Object)port);
        return newClient;
    }

    public final class RandomEndpointStrategy
    implements EndpointStrategy {
        private final Iterable<Discoverable> endpoints;

        public RandomEndpointStrategy(Iterable<Discoverable> endpoints) {
            this.endpoints = endpoints;
        }

        @Override
        public Discoverable pick() {
            Discoverable result = null;
            Iterator<Discoverable> itor = this.endpoints.iterator();
            Random random = new Random();
            int count = 0;
            while (itor.hasNext()) {
                Discoverable next = itor.next();
                if (random.nextInt(++count) != 0) continue;
                result = next;
            }
            return result;
        }
    }

    public final class TimeLimitEndpointStrategy
    implements EndpointStrategy {
        private final EndpointStrategy delegate;
        private final long timeout;
        private final TimeUnit timeoutUnit;

        public TimeLimitEndpointStrategy(EndpointStrategy delegate, long timeout, TimeUnit timeoutUnit) {
            this.delegate = delegate;
            this.timeout = timeout;
            this.timeoutUnit = timeoutUnit;
        }

        @Override
        public Discoverable pick() {
            Discoverable pick = this.delegate.pick();
            try {
                long count = 0L;
                while (pick == null && count++ < this.timeout) {
                    this.timeoutUnit.sleep(1L);
                    pick = this.delegate.pick();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return pick;
        }
    }

    public static interface EndpointStrategy {
        public Discoverable pick();
    }
}

