/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import * as React from 'react';
import SvgIcon, { SvgIconProps } from '@material-ui/core/SvgIcon';

export default (props: SvgIconProps) => (
  <SvgIcon style={{ width: 24, height: 24, verticalAlign: 'middle' }} viewBox="0 0 512 512" fill="none" {...props}>
    <path d="M401.6,246.5c17.3-24.9,27.5-55.1,27.5-87.7C429.1,74,360.1,5,275.3,5S121.5,74,121.5,158.8c0,20.4,4,39.9,11.2,57.7
	c-32.8,0.3-63.7,5.1-87.3,13.6C7.9,243.5,0,261.8,0,274.8v86.8c0,0,0,0.1,0,0.1s0,0.1,0,0.1v86.8c0,13,7.9,31.4,45.5,44.8
	c24.5,8.8,56.7,13.6,90.8,13.6s66.3-4.8,90.8-13.6c37.6-13.4,45.5-31.8,45.5-44.8v-86.8c0,0,0-0.1,0-0.1s0-0.1,0-0.1v-49.1
	c0.9,0,1.8,0,2.7,0c18.1,0,35.4-3.1,51.5-8.9l109.3,148.8l75.8-55.7L401.6,246.5z M55.6,258.3c21.3-7.6,50-11.8,80.7-11.8
	c4.4,0,8.7,0.1,12.9,0.3c14.2,20.3,33.2,37,55.3,48.5c-19.5,5.2-43.1,8-68.2,8c-30.7,0-59.4-4.2-80.7-11.8
	c-21-7.5-25.6-15.1-25.6-16.5S34.6,265.8,55.6,258.3z M242.6,448.6c0,1.5-4.5,9-25.6,16.5c-21.3,7.6-50,11.8-80.7,11.8
	c-30.7,0-59.4-4.2-80.7-11.8c-21-7.5-25.6-15.1-25.6-16.5v-48.7c4.5,2.3,9.6,4.5,15.5,6.6c24.5,8.8,56.7,13.6,90.8,13.6
	s66.3-4.8,90.8-13.6c5.8-2.1,11-4.3,15.5-6.6V448.6z M217,378.2c-21.3,7.6-50,11.8-80.7,11.8c-30.7,0-59.4-4.2-80.7-11.8
	c-21-7.5-25.6-15.1-25.6-16.5v-48.5c4.5,2.3,9.6,4.5,15.5,6.6c24.5,8.8,56.7,13.6,90.8,13.6s66.3-4.8,90.8-13.6
	c5.8-2.1,11-4.3,15.5-6.6v48.5h0C242.6,363.1,238,370.6,217,378.2z M275.3,282.5c-68.2,0-123.8-55.5-123.8-123.8S207.1,35,275.3,35
	s123.8,55.5,123.8,123.8C399.1,227,343.5,282.5,275.3,282.5z M354.5,290.6c9.8-5.9,18.8-12.8,27-20.7L470,390.3l-27.4,20.2
        L354.5,290.6z M200.3,143.8h30v30h-30V143.8z M260.3,143.8h30v30h-30V143.8z M320.3,143.8h30v30h-30V143.8z"
    />
  </SvgIcon>
);
