/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataAlarmValue is the corresponding interface of BACnetConstructedDataAlarmValue
type BACnetConstructedDataAlarmValue interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetBinaryPv returns BinaryPv (property field)
	GetBinaryPv() BACnetBinaryPVTagged
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetBinaryPVTagged
	// IsBACnetConstructedDataAlarmValue is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataAlarmValue()
	// CreateBuilder creates a BACnetConstructedDataAlarmValueBuilder
	CreateBACnetConstructedDataAlarmValueBuilder() BACnetConstructedDataAlarmValueBuilder
}

// _BACnetConstructedDataAlarmValue is the data-structure of this message
type _BACnetConstructedDataAlarmValue struct {
	BACnetConstructedDataContract
	BinaryPv BACnetBinaryPVTagged
}

var _ BACnetConstructedDataAlarmValue = (*_BACnetConstructedDataAlarmValue)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataAlarmValue)(nil)

// NewBACnetConstructedDataAlarmValue factory function for _BACnetConstructedDataAlarmValue
func NewBACnetConstructedDataAlarmValue(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, binaryPv BACnetBinaryPVTagged, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataAlarmValue {
	if binaryPv == nil {
		panic("binaryPv of type BACnetBinaryPVTagged for BACnetConstructedDataAlarmValue must not be nil")
	}
	_result := &_BACnetConstructedDataAlarmValue{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		BinaryPv:                      binaryPv,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataAlarmValueBuilder is a builder for BACnetConstructedDataAlarmValue
type BACnetConstructedDataAlarmValueBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(binaryPv BACnetBinaryPVTagged) BACnetConstructedDataAlarmValueBuilder
	// WithBinaryPv adds BinaryPv (property field)
	WithBinaryPv(BACnetBinaryPVTagged) BACnetConstructedDataAlarmValueBuilder
	// WithBinaryPvBuilder adds BinaryPv (property field) which is build by the builder
	WithBinaryPvBuilder(func(BACnetBinaryPVTaggedBuilder) BACnetBinaryPVTaggedBuilder) BACnetConstructedDataAlarmValueBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataAlarmValue or returns an error if something is wrong
	Build() (BACnetConstructedDataAlarmValue, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataAlarmValue
}

// NewBACnetConstructedDataAlarmValueBuilder() creates a BACnetConstructedDataAlarmValueBuilder
func NewBACnetConstructedDataAlarmValueBuilder() BACnetConstructedDataAlarmValueBuilder {
	return &_BACnetConstructedDataAlarmValueBuilder{_BACnetConstructedDataAlarmValue: new(_BACnetConstructedDataAlarmValue)}
}

type _BACnetConstructedDataAlarmValueBuilder struct {
	*_BACnetConstructedDataAlarmValue

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataAlarmValueBuilder) = (*_BACnetConstructedDataAlarmValueBuilder)(nil)

func (b *_BACnetConstructedDataAlarmValueBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataAlarmValue
}

func (b *_BACnetConstructedDataAlarmValueBuilder) WithMandatoryFields(binaryPv BACnetBinaryPVTagged) BACnetConstructedDataAlarmValueBuilder {
	return b.WithBinaryPv(binaryPv)
}

func (b *_BACnetConstructedDataAlarmValueBuilder) WithBinaryPv(binaryPv BACnetBinaryPVTagged) BACnetConstructedDataAlarmValueBuilder {
	b.BinaryPv = binaryPv
	return b
}

func (b *_BACnetConstructedDataAlarmValueBuilder) WithBinaryPvBuilder(builderSupplier func(BACnetBinaryPVTaggedBuilder) BACnetBinaryPVTaggedBuilder) BACnetConstructedDataAlarmValueBuilder {
	builder := builderSupplier(b.BinaryPv.CreateBACnetBinaryPVTaggedBuilder())
	var err error
	b.BinaryPv, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetBinaryPVTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataAlarmValueBuilder) Build() (BACnetConstructedDataAlarmValue, error) {
	if b.BinaryPv == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'binaryPv' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataAlarmValue.deepCopy(), nil
}

func (b *_BACnetConstructedDataAlarmValueBuilder) MustBuild() BACnetConstructedDataAlarmValue {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataAlarmValueBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataAlarmValueBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataAlarmValueBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataAlarmValueBuilder().(*_BACnetConstructedDataAlarmValueBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataAlarmValueBuilder creates a BACnetConstructedDataAlarmValueBuilder
func (b *_BACnetConstructedDataAlarmValue) CreateBACnetConstructedDataAlarmValueBuilder() BACnetConstructedDataAlarmValueBuilder {
	if b == nil {
		return NewBACnetConstructedDataAlarmValueBuilder()
	}
	return &_BACnetConstructedDataAlarmValueBuilder{_BACnetConstructedDataAlarmValue: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataAlarmValue) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataAlarmValue) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ALARM_VALUE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataAlarmValue) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataAlarmValue) GetBinaryPv() BACnetBinaryPVTagged {
	return m.BinaryPv
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataAlarmValue) GetActualValue() BACnetBinaryPVTagged {
	ctx := context.Background()
	_ = ctx
	return CastBACnetBinaryPVTagged(m.GetBinaryPv())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataAlarmValue(structType any) BACnetConstructedDataAlarmValue {
	if casted, ok := structType.(BACnetConstructedDataAlarmValue); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataAlarmValue); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataAlarmValue) GetTypeName() string {
	return "BACnetConstructedDataAlarmValue"
}

func (m *_BACnetConstructedDataAlarmValue) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (binaryPv)
	lengthInBits += m.BinaryPv.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataAlarmValue) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataAlarmValue) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataAlarmValue BACnetConstructedDataAlarmValue, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataAlarmValue"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataAlarmValue")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	binaryPv, err := ReadSimpleField[BACnetBinaryPVTagged](ctx, "binaryPv", ReadComplex[BACnetBinaryPVTagged](BACnetBinaryPVTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_APPLICATION_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'binaryPv' field"))
	}
	m.BinaryPv = binaryPv

	actualValue, err := ReadVirtualField[BACnetBinaryPVTagged](ctx, "actualValue", (*BACnetBinaryPVTagged)(nil), binaryPv)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataAlarmValue"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataAlarmValue")
	}

	return m, nil
}

func (m *_BACnetConstructedDataAlarmValue) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataAlarmValue) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataAlarmValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataAlarmValue")
		}

		if err := WriteSimpleField[BACnetBinaryPVTagged](ctx, "binaryPv", m.GetBinaryPv(), WriteComplex[BACnetBinaryPVTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'binaryPv' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataAlarmValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataAlarmValue")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataAlarmValue) IsBACnetConstructedDataAlarmValue() {}

func (m *_BACnetConstructedDataAlarmValue) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataAlarmValue) deepCopy() *_BACnetConstructedDataAlarmValue {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataAlarmValueCopy := &_BACnetConstructedDataAlarmValue{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetBinaryPVTagged](m.BinaryPv),
	}
	_BACnetConstructedDataAlarmValueCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataAlarmValueCopy
}

func (m *_BACnetConstructedDataAlarmValue) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
