/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.messaging;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.Encoder;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractDescribedListTypeEncoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.Header;

public final class HeaderTypeEncoder
extends AbstractDescribedListTypeEncoder<Header> {
    @Override
    public Class<Header> getTypeClass() {
        return Header.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Header.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Header.DESCRIPTOR_SYMBOL;
    }

    @Override
    public byte getListEncoding(Header value) {
        return -64;
    }

    @Override
    public void writeElement(Header header, int index, ProtonBuffer buffer, Encoder encoder, EncoderState state) {
        switch (index) {
            case 0: {
                if (header.hasDurable()) {
                    buffer.writeByte(header.isDurable() ? (byte)65 : 66);
                    break;
                }
                buffer.writeByte((byte)64);
                break;
            }
            case 1: {
                if (header.hasPriority()) {
                    encoder.writeUnsignedByte(buffer, state, header.getPriority());
                    break;
                }
                buffer.writeByte((byte)64);
                break;
            }
            case 2: {
                if (header.hasTimeToLive()) {
                    encoder.writeUnsignedInteger(buffer, state, header.getTimeToLive());
                    break;
                }
                buffer.writeByte((byte)64);
                break;
            }
            case 3: {
                if (header.hasFirstAcquirer()) {
                    buffer.writeByte(header.isFirstAcquirer() ? (byte)65 : 66);
                    break;
                }
                buffer.writeByte((byte)64);
                break;
            }
            case 4: {
                if (header.hasDeliveryCount()) {
                    encoder.writeUnsignedInteger(buffer, state, header.getDeliveryCount());
                    break;
                }
                buffer.writeByte((byte)64);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Header value index: " + index);
            }
        }
    }

    @Override
    public int getElementCount(Header header) {
        return header.getElementCount();
    }
}

