/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.io.InputStream;
import java.util.Map;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBufferInputStream;
import org.apache.qpid.protonj2.client.Delivery;
import org.apache.qpid.protonj2.client.Message;
import org.apache.qpid.protonj2.client.Receiver;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.exceptions.ClientIllegalStateException;
import org.apache.qpid.protonj2.client.impl.ClientDeliverable;
import org.apache.qpid.protonj2.client.impl.ClientMessageSupport;
import org.apache.qpid.protonj2.client.impl.ClientReceiver;
import org.apache.qpid.protonj2.engine.IncomingDelivery;
import org.apache.qpid.protonj2.engine.util.StringUtils;
import org.apache.qpid.protonj2.types.messaging.DeliveryAnnotations;

public final class ClientDelivery
extends ClientDeliverable<ClientDelivery, ClientReceiver>
implements Delivery {
    private final ProtonBuffer payload;
    private DeliveryAnnotations deliveryAnnotations;
    private Message<?> cachedMessage;
    private InputStream rawInputStream;

    ClientDelivery(ClientReceiver receiver, IncomingDelivery delivery) {
        super(receiver, delivery);
        this.payload = delivery.readAll();
    }

    @Override
    protected ClientDelivery self() {
        return this;
    }

    @Override
    public Receiver receiver() {
        return (Receiver)((Object)this.receiver);
    }

    @Override
    public <E> Message<E> message() throws ClientException {
        if (this.rawInputStream != null) {
            throw new ClientIllegalStateException("Cannot access Delivery Annotations API after requesting an InputStream");
        }
        Message<?> message = this.cachedMessage;
        if (message == null && this.payload.isReadable()) {
            try (ProtonBuffer protonBuffer = this.payload;){
                message = this.cachedMessage = ClientMessageSupport.decodeMessage(this.payload, this::deliveryAnnotations);
            }
        }
        return message;
    }

    @Override
    public InputStream rawInputStream() throws ClientException {
        if (this.cachedMessage != null) {
            throw new ClientIllegalStateException("Cannot access Delivery InputStream API after requesting an Message");
        }
        if (this.rawInputStream == null) {
            try (ProtonBuffer protonBuffer = this.payload;){
                this.rawInputStream = new ProtonBufferInputStream(this.payload);
            }
        }
        return this.rawInputStream;
    }

    @Override
    public Map<String, Object> annotations() throws ClientException {
        this.message();
        if (this.deliveryAnnotations != null && this.deliveryAnnotations.getValue() != null) {
            return StringUtils.toStringKeyedMap((Map)this.deliveryAnnotations.getValue());
        }
        return null;
    }

    void deliveryAnnotations(DeliveryAnnotations deliveryAnnotations) {
        this.deliveryAnnotations = deliveryAnnotations;
    }
}

