/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import org.apache.qpid.protonj2.client.Session;
import org.apache.qpid.protonj2.client.exceptions.ClientIllegalStateException;
import org.apache.qpid.protonj2.client.futures.ClientFuture;
import org.apache.qpid.protonj2.client.impl.ClientTransactionContext;
import org.apache.qpid.protonj2.engine.IncomingDelivery;
import org.apache.qpid.protonj2.types.transport.DeliveryState;

final class ClientNoOpTransactionContext
implements ClientTransactionContext {
    ClientNoOpTransactionContext() {
    }

    @Override
    public ClientTransactionContext begin(ClientFuture<Session> beginFuture) throws ClientIllegalStateException {
        throw new ClientIllegalStateException("Cannot begin from a no-op transaction context");
    }

    @Override
    public ClientTransactionContext commit(ClientFuture<Session> commitFuture, boolean startNew) throws ClientIllegalStateException {
        throw new ClientIllegalStateException("Cannot commit from a no-op transaction context");
    }

    @Override
    public ClientTransactionContext rollback(ClientFuture<Session> rollbackFuture, boolean startNew) throws ClientIllegalStateException {
        throw new ClientIllegalStateException("Cannot roll back from a no-op transaction context");
    }

    @Override
    public boolean isInTransaction() {
        return false;
    }

    @Override
    public boolean isRollbackOnly() {
        return false;
    }

    @Override
    public ClientTransactionContext send(ClientTransactionContext.Sendable sendable, DeliveryState outcome, boolean settled) {
        sendable.send(outcome, settled);
        return this;
    }

    @Override
    public ClientTransactionContext disposition(IncomingDelivery delivery, DeliveryState outcome, boolean settled) {
        delivery.disposition(outcome, settled);
        return this;
    }
}

