/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.impl;

import org.apache.qpid.protonj2.engine.Endpoint;
import org.apache.qpid.protonj2.engine.Transaction;
import org.apache.qpid.protonj2.engine.TransactionState;
import org.apache.qpid.protonj2.engine.impl.ProtonAttachments;
import org.apache.qpid.protonj2.types.Binary;
import org.apache.qpid.protonj2.types.transport.ErrorCondition;

public abstract class ProtonTransaction<E extends Endpoint<?>>
implements Transaction<E> {
    private TransactionState state = TransactionState.IDLE;
    private Transaction.DischargeState dischargeState = Transaction.DischargeState.NONE;
    private ErrorCondition condition;
    private Binary txnId;
    private ProtonAttachments attachments;
    private Object linkedResource;

    @Override
    public TransactionState getState() {
        return this.state;
    }

    ProtonTransaction<E> setState(TransactionState state) {
        this.state = state;
        return this;
    }

    @Override
    public boolean isDeclared() {
        return this.state.ordinal() == TransactionState.DECLARED.ordinal();
    }

    @Override
    public boolean isDischarged() {
        return this.state.ordinal() == TransactionState.DISCHARGED.ordinal();
    }

    @Override
    public boolean isFailed() {
        return this.state.ordinal() > TransactionState.DISCHARGED.ordinal();
    }

    @Override
    public ErrorCondition getCondition() {
        return this.condition;
    }

    ProtonTransaction<E> setCondition(ErrorCondition condition) {
        this.condition = condition;
        return this;
    }

    @Override
    public Transaction.DischargeState getDischargeState() {
        return this.dischargeState;
    }

    ProtonTransaction<E> setDischargeState(Transaction.DischargeState state) {
        this.dischargeState = state;
        return this;
    }

    @Override
    public Binary getTxnId() {
        return this.txnId;
    }

    ProtonTransaction<E> setTxnId(Binary txnId) {
        this.txnId = txnId;
        return this;
    }

    @Override
    public void setLinkedResource(Object resource) {
        this.linkedResource = resource;
    }

    @Override
    public Object getLinkedResource() {
        return this.linkedResource;
    }

    @Override
    public <T> T getLinkedResource(Class<T> typeClass) {
        return typeClass.cast(this.linkedResource);
    }

    @Override
    public ProtonAttachments getAttachments() {
        return this.attachments == null ? (this.attachments = new ProtonAttachments()) : this.attachments;
    }

    @Override
    public abstract E parent();
}

