/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shenyu.plugin.motan.context;

import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

/**
 * The Test Case For MotanShenyuContextDecorator.
 */
public final class MotanShenyuContextDecoratorTest {

    private MotanShenyuContextDecorator motanShenyuContextDecorator;

    private ShenyuContext shenyuContext;

    private MetaData metaData;

    @BeforeEach
    public void setUp() {
        this.motanShenyuContextDecorator = new MotanShenyuContextDecorator();
        this.metaData = new MetaData();
        this.shenyuContext = new ShenyuContext();
    }

    @Test
    public void testDecorator() {
        metaData.setAppName("app");
        metaData.setServiceName("service");
        metaData.setContextPath("localhost");
        motanShenyuContextDecorator.decorator(shenyuContext, metaData);
        Assertions.assertEquals(shenyuContext.getModule(), "app");
    }

    @Test
    public void testRpcType() {
        Assertions.assertEquals(motanShenyuContextDecorator.rpcType(), "motan");
    }
}
