/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.netty.http.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.plugin.netty.http.common.AttributeKeys;
import org.apache.skywalking.apm.plugin.netty.http.utils.TypeUtils;

@ChannelHandler.Sharable
public class NettyHttpResponseDecoderTracingHandler
extends ChannelInboundHandlerAdapter {
    private static final ILog LOGGER = LogManager.getLogger(NettyHttpResponseDecoderTracingHandler.class);

    public static NettyHttpResponseDecoderTracingHandler getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private NettyHttpResponseDecoderTracingHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        try {
            if (!TypeUtils.isHttpResponse(msg)) {
                return;
            }
            HttpResponse response = (HttpResponse)msg;
            int code = response.status().code();
            if (HttpResponseStatus.CONTINUE.code() == code) {
                return;
            }
            Channel channel = ctx.channel();
            AbstractSpan span = (AbstractSpan)channel.attr(AttributeKeys.HTTP_CLIENT_SPAN).getAndSet(null);
            if (span == null) {
                return;
            }
            Tags.HTTP_RESPONSE_STATUS_CODE.set(span, Integer.valueOf(code));
            if (code >= 400) {
                span.errorOccurred();
            }
            span.asyncFinish();
        }
        catch (Exception e) {
            LOGGER.error("Fail to trace netty http response", (Throwable)e);
        }
        finally {
            ctx.fireChannelRead(msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        AbstractSpan span = (AbstractSpan)ctx.channel().attr(AttributeKeys.HTTP_CLIENT_SPAN).getAndSet(null);
        if (span != null) {
            span.asyncFinish();
        }
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        AbstractSpan span = (AbstractSpan)ctx.channel().attr(AttributeKeys.HTTP_CLIENT_SPAN).getAndSet(null);
        if (span != null) {
            span.errorOccurred().log(cause);
            Tags.HTTP_RESPONSE_STATUS_CODE.set(span, Integer.valueOf(500));
            span.asyncFinish();
        }
        super.exceptionCaught(ctx, cause);
    }

    private static class SingletonHolder {
        private static final NettyHttpResponseDecoderTracingHandler INSTANCE = new NettyHttpResponseDecoderTracingHandler();

        private SingletonHolder() {
        }
    }
}

