/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.caffeine.v3;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.caffeine.v3.CaffeineOperationTransform;

public abstract class AbstractCaffeineInterceptor
implements InstanceMethodsAroundInterceptor {
    protected AbstractSpan generateSpanInfo(String methodName) {
        AbstractSpan span = ContextManager.createLocalSpan((String)("Caffeine/" + methodName));
        span.setComponent((Component)ComponentsDefine.CAFFEINE);
        Tags.CACHE_TYPE.set(span, ComponentsDefine.CAFFEINE.getName());
        Tags.CACHE_CMD.set(span, methodName);
        CaffeineOperationTransform.transformOperation(methodName).ifPresent(op -> Tags.CACHE_OP.set(span, op));
        SpanLayer.asCache((AbstractSpan)span);
        return span;
    }

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

